/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.SchoolClassRelation;
import com.ptteng.yi.nucleus.model.SchoolVenuesRelation;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.ptteng.yi.nucleus.service.SchoolVenuesRelationService;
import com.ptteng.yi.nucleus.service.TrainingVenuesService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TrainingVenuesController {
    private static final Log log = LogFactory.getLog(TrainingVenuesController.class);
    @Autowired
    private TrainingVenuesService trainingVenuesService;
    @Autowired
    private SchoolVenuesRelationService schoolVenuesRelationService;
    @Autowired
    private SchoolClassRelationService schoolClassRelationService;
    @Autowired
    private CookieUtil cookieUtil;

    @RequestMapping(value={"/a/u/venues/list"}, method={RequestMethod.GET})
    public String getTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size, Long classId, Long cityId) throws Exception {
        log.info((Object)("/a/u/exam/student/list param is   cityId ===== " + cityId + ", classId ==" + classId + ", page == " + page + " , size == " + size));
        if (DataUtils.isNullOrEmpty((Object)cityId)) {
            model.addAttribute("code", (Object)-21014);
            log.info((Object)"parameter schools is null or empty");
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)classId)) {
            model.addAttribute("code", (Object)-21015);
            log.info((Object)"classId is null or empty");
            return "/common/failure";
        }
        try {
            Map map = DynamicUtil.classIdgetSchoolList((Long)classId);
            log.info((Object)("map is " + map));
            List ids = this.schoolClassRelationService.getIdsByDynamicCondition(SchoolClassRelation.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("ids is " + ids));
            List schoolClassRelationList = this.schoolClassRelationService.getObjectsByIds(ids);
            ArrayList<String> schoolIds = new ArrayList<String>();
            for (int i = 0; i < ids.size(); ++i) {
                schoolIds.add(((SchoolClassRelation)schoolClassRelationList.get(i)).getSchoolId().toString());
            }
            log.info((Object)("schoolIds is " + schoolIds));
            List trainingVenuesList = new ArrayList();
            if (CollectionUtils.isNotEmpty(schoolIds)) {
                Map schoolVenuesRelationMap = DynamicUtil.schoolIdgetVenuesList(schoolIds);
                log.info((Object)("schoolVenuesRelationMap is " + schoolVenuesRelationMap));
                List schoolVenuesRelationIds = this.schoolVenuesRelationService.getIdsByDynamicCondition(SchoolVenuesRelation.class, schoolVenuesRelationMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("schoolVenuesRelationIds is " + schoolVenuesRelationIds));
                List schoolVenuesRelationList = this.schoolVenuesRelationService.getObjectsByIds(schoolVenuesRelationIds);
                ArrayList<Long> venuesIds = new ArrayList<Long>();
                for (int i = 0; i < schoolVenuesRelationList.size(); ++i) {
                    log.info((Object)("venuesIds.contains(schoolVenuesRelationList.get(i).getVenueId() " + venuesIds.contains(((SchoolVenuesRelation)schoolVenuesRelationList.get(i)).getVenueId())));
                    if (venuesIds.contains(((SchoolVenuesRelation)schoolVenuesRelationList.get(i)).getVenueId())) continue;
                    venuesIds.add(((SchoolVenuesRelation)schoolVenuesRelationList.get(i)).getVenueId());
                }
                log.info((Object)("venuesIds is " + venuesIds));
                trainingVenuesList = this.trainingVenuesService.getObjectsByIds(venuesIds);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("trainingVenuesList", trainingVenuesList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/trainingVenues/json/trainingVenuesListJson";
    }
}

