/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.interceptor.UserInterceptor;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.TestPlan;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.nucleus.service.TestPlanService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TestPlanController {
    private static final Logger log = Logger.getLogger(TestPlanController.class);
    @Autowired
    TestPlanService testPlanService;
    @Autowired
    StudentsService studentsService;
    @Autowired
    CookieUtil cookieUtil;
    @Autowired
    SchoolService schoolService;

    @RequestMapping(value={"   /a/u/test/plan"}, method={RequestMethod.GET})
    public String getTestPlanByMonth(Long startTime, Long endTime, String token, Integer page, Integer size, Model model) {
        ArrayList<Long> time;
        Long studentId;
        log.info((Object)("startTime is==" + startTime + "     token is==" + token + "  endTime is==" + endTime + "  page is==" + page + "  size is==" + size));
        if (!DataUtils.isNotNullOrEmpty((Object)token)) {
            model.addAttribute("code", (Object)-2301);
            return "yi-pub-service/testPlan/json/testPlansListJson";
        }
        size = null == size ? 50 : size;
        page = ParamsUtil.calculateStartPosition((Integer)page, (Integer)size);
        log.info((Object)("page is " + page + "size is " + size));
        Map map = UserInterceptor.decodeCookie((String)token);
        Long l = studentId = null != map && 0 != map.size() ? (Long)map.get("userId") : null;
        if (null == studentId) {
            log.info((Object)("userId is==" + studentId));
            log.info((Object)"userId is null,end the request");
            model.addAttribute("code", (Object)-5001);
            return "yi-pub-service/testPlan/json/testPlansListJson";
        }
        log.info((Object)("student id is==" + studentId));
        Students students = null;
        Long schoolId = null;
        List testPlanIds = null;
        List testPlans = null;
        ArrayList<Long> arrayList = time = null != startTime || null != endTime ? new ArrayList<Long>(2) : null;
        if (null != time) {
            time.add(startTime);
            time.add(endTime);
        }
        Integer total = 0;
        try {
            students = this.studentsService.getObjectById(studentId);
            if (null == students) {
                log.info((Object)("student nonexistent,user id is==" + studentId));
                model.addAttribute("code", (Object)-5003);
                return "yi-pub-service/testPlan/json/testPlansListJson";
            }
            schoolId = students.getSchoolId();
            if (null == schoolId) {
                log.info((Object)"coach not binding school");
                model.addAttribute("code", (Object)-2300);
                return "yi-pub-service/testPlan/json/testPlansListJson";
            }
            Map sqlInfo = DynamicUtil.getTestPlanIdsByCondition((Long)schoolId, time);
            if (null != sqlInfo) {
                testPlanIds = this.testPlanService.getIdsByDynamicCondition(TestPlan.class, sqlInfo, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            log.info((Object)("testPlanIds  is==" + testPlanIds));
            total = null != testPlanIds ? testPlanIds.size() : 0;
            testPlanIds = ParametersUtil.splitArrayList((List)testPlanIds, (int)page, (int)(page + size));
            if (null != testPlanIds && 0 != testPlanIds.size()) {
                testPlans = this.testPlanService.getObjectsByIds(testPlanIds);
            }
            log.info((Object)("testPlans is==" + testPlans));
            model.addAttribute("code", (Object)0);
            model.addAttribute("total", (Object)total);
            model.addAttribute("data", (Object)testPlans);
        }
        catch (Exception e) {
            log.error((Object)("has an error,see==" + e));
            model.addAttribute("code", (Object)-100000);
        }
        return "yi-pub-service/testPlan/json/testPlansListJson";
    }

    @RequestMapping(value={"/a/u/test/plan/list"}, method={RequestMethod.GET})
    public String getTestPlanById(Long[] id, String token, Model model, HttpServletRequest request) {
        log.info((Object)("test plan id is==" + (null != id && 0 != id.length ? Arrays.asList(id) : null)));
        if (null == id || 0 == id.length) {
            log.info((Object)"id is illegal,end the request");
            model.addAttribute("code", (Object)-1001);
            return "yi-pub-service/testPlan/json/testPlanDetailJson";
        }
        if (!DataUtils.isNotNullOrEmpty((Object)token)) {
            log.info((Object)"token is null");
            model.addAttribute("code", (Object)-2301);
            return "yi-pub-service/testPlan/json/testPlanDetailJson";
        }
        Map map = UserInterceptor.decodeCookie((String)token);
        Long studentId = (Long)map.get("userId");
        Students students = null;
        List<Long> testPlanIds = Arrays.asList(id);
        List testPlans = null;
        ArrayList<Long> schoolIds = new ArrayList<Long>(16);
        List schools = null;
        log.info((Object)("student id is==" + studentId));
        try {
            if (null != studentId) {
                students = this.studentsService.getObjectById(studentId);
            }
            log.info((Object)("student is==" + students));
            if (students == null) {
                log.info((Object)"student is nonexistent");
                model.addAttribute("code", (Object)-5003);
                return "yi-pub-service/testPlan/json/testPlanDetailJson";
            }
            testPlans = this.testPlanService.getObjectsByIds(testPlanIds);
            int length = null != testPlans ? testPlans.size() : 0;
            for (int i = 0; i < length; ++i) {
                schoolIds.add(((TestPlan)testPlans.get(i)).getSchoolId());
            }
            schools = 0 != schoolIds.size() ? this.schoolService.getObjectsByIds(schoolIds) : null;
            model.addAttribute("code", (Object)0);
            model.addAttribute("testPlan", (Object)testPlans);
            model.addAttribute("schools", (Object)schools);
        }
        catch (Exception e) {
            log.error((Object)("has an error,see==" + e));
            model.addAttribute("code", (Object)-100000);
        }
        return "yi-pub-service/testPlan/json/testPlanDetailJson";
    }
}

