/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.model.StudentPracticeKey;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ListUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Note;
import com.ptteng.yi.nucleus.model.SubjectPractice;
import com.ptteng.yi.nucleus.service.NoteService;
import com.ptteng.yi.nucleus.service.StudentFavoriteRelationService;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SubjectPracticeController {
    private static final Log log = LogFactory.getLog(SubjectPracticeController.class);
    public static final int PRACTICE_SEQUENCE = 0;
    public static final int PRACTICE_NOT_DONE = 1;
    public static final int PRACTICE_WRONG = 2;
    public static final int PRACTICE_FAVORITE = 3;
    public static final int PRACTICE_RANDOM = 4;
    public static final int PRACTICE_MOCK = 5;
    public static final int PRACTICE_SPECIAL = 6;
    public static final int FIRST_PRACTICE = 0;
    public static final int MODE_BACKWARD = 1;
    public static final int MODE_FORWARD = 0;
    @Resource
    private SubjectPracticeService subjectPracticeService;
    @Resource
    private NoteService noteService;
    @Resource
    private StudentFavoriteRelationService studentFavoriteRelationService;

    @RequestMapping(value={"/a/u/practice/portion/list"}, method={RequestMethod.GET})
    public String getPortionOfPractices(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Long practiceId, Integer subjectType, Integer type, Integer size, Integer mode) throws Exception {
        log.info((Object)("Interface GET /a/u/practice/portion/list, Method getPortionOfPractices() parameters : studentId: " + studentId + ", practiceId: " + practiceId + ", subjectType: " + subjectType + ", type: " + type + ", mode: " + mode));
        int actualSize = ParamsUtil.calculateActualSize((Integer)size);
        log.info((Object)("size: " + actualSize));
        int validateResult = ParamsUtil.checkParamsOfGetPortionOfPractices((Long)studentId, (Long)practiceId, (Integer)subjectType, (Integer)type, (Integer)mode);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            List practiceIdListTotal = new ArrayList();
            log.info((Object)("Key parameter: parameter type is : " + type));
            switch (type) {
                case 0: {
                    practiceIdListTotal = this.subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    break;
                }
                case 1: {
                    practiceIdListTotal = this.subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    List hasDoneIdList = this.noteService.getPracticeIdsByStudentIdAndSubjectType(studentId, subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    practiceIdListTotal = ListUtil.eliminateSublist((List)hasDoneIdList, practiceIdListTotal);
                    break;
                }
                case 2: {
                    practiceIdListTotal = this.noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType, Note.RESULT_WRONG, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    break;
                }
                case 3: {
                    practiceIdListTotal = this.studentFavoriteRelationService.getTargetIdsByStudentIdAndTargetType(studentId, subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    break;
                }
            }
            log.info((Object)("get practice id list total, list size is : " + practiceIdListTotal.size()));
            if (practiceId != 0L && !practiceIdListTotal.contains(practiceId)) {
                log.info((Object)("Error value of practiceId, practiceId is: " + practiceId));
                model.addAttribute("code", (Object)-1001);
                return "/common/failure";
            }
            if (practiceId == 0L) {
                practiceId = (Long)practiceIdListTotal.get(0);
                mode = 1;
            }
            List resultIdList = ListUtil.getElementsFromList(practiceIdListTotal, (Integer)practiceIdListTotal.indexOf(practiceId), (Integer)actualSize, (Integer)mode);
            log.info((Object)("get result id list, list size is : " + resultIdList.size()));
            List subjectPracticeList = null;
            if (CollectionUtils.isNotEmpty((Collection)resultIdList)) {
                subjectPracticeList = this.subjectPracticeService.getObjectsByIds(resultIdList);
                log.info((Object)("get practice list data, list size is : " + subjectPracticeList.size()));
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("size", (Object)actualSize);
            model.addAttribute("total", (Object)practiceIdListTotal.size());
            model.addAttribute("subjectPracticeList", (Object)subjectPracticeList);
            return "/yi-nucleus-service/subjectPractice/json/subjectPracticeListJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getPortionOfPractices() failed, studentId: " + studentId + ", practiceId: " + practiceId + ", subjectType: " + subjectType + ", type: " + type + ", mode: " + mode));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/practice/key/list"}, method={RequestMethod.GET})
    public String getPracticeIdList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Integer subjectType, Integer type, String special) throws Exception {
        log.info((Object)("Interface GET /a/u/practice/key/list, Method getPracticeIdList() parameters: studentId: " + studentId + ", subjectType: " + subjectType + ", type: " + type + ", special: " + special));
        int validateResult = ParamsUtil.checkParamsOfGetPracticeIdList((Long)studentId, (Integer)subjectType, (Integer)type, (String)special);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            log.info((Object)("Key parameter: parameter type is : " + type));
            List rightPracticeIds = new ArrayList();
            List wrongPracticeIds = new ArrayList();
            if (type != 1 && type != 5) {
                rightPracticeIds = this.noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType, Note.RESULT_RIGHT, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                wrongPracticeIds = this.noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType, Note.RESULT_WRONG, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("get right practice id list, size is : " + rightPracticeIds.size() + ", get wrong practice id list, size is: " + wrongPracticeIds.size()));
            }
            List practiceIdList = new ArrayList();
            switch (type) {
                case 0: {
                    practiceIdList = this.subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    break;
                }
                case 1: {
                    practiceIdList = this.subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    List hasDoneIdList = this.noteService.getPracticeIdsByStudentIdAndSubjectType(studentId, subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    practiceIdList = ListUtil.eliminateSublist((List)hasDoneIdList, practiceIdList);
                    break;
                }
                case 2: {
                    practiceIdList = wrongPracticeIds;
                    break;
                }
                case 3: {
                    practiceIdList = this.studentFavoriteRelationService.getTargetIdsByStudentIdAndTargetType(studentId, subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    break;
                }
                case 4: {
                    List practiceTotal = this.subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    List hasNotDone = ListUtil.eliminateSublist(wrongPracticeIds, (List)practiceTotal);
                    hasNotDone = ListUtil.eliminateSublist(rightPracticeIds, (List)hasNotDone);
                    practiceIdList = hasNotDone;
                    Collections.shuffle(practiceIdList);
                    Collections.shuffle(wrongPracticeIds);
                    Collections.shuffle(rightPracticeIds);
                    practiceIdList.addAll(wrongPracticeIds);
                    practiceIdList.addAll(rightPracticeIds);
                    break;
                }
                case 5: {
                    practiceIdList = this.subjectPracticeService.getMockExamPracticeIdsBySubjectType(subjectType);
                    break;
                }
                case 6: {
                    Map querySpecialPracticeIdsMap = DynamicUtil.getSpecialPracticeParams((Integer)subjectType, (String)special, (Boolean)false);
                    practiceIdList = this.subjectPracticeService.getIdsByDynamicCondition(SubjectPractice.class, querySpecialPracticeIdsMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    break;
                }
            }
            log.info((Object)("get practice Id list , list size is : " + practiceIdList.size()));
            List favoritePracticeIdList = this.studentFavoriteRelationService.getTargetIdsByStudentIdAndTargetType(studentId, subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get favorite practice id list, list size is : " + favoritePracticeIdList.size()));
            List resultList = StudentPracticeKey.generateStudentPracticeKeyList(practiceIdList, rightPracticeIds, wrongPracticeIds, (List)favoritePracticeIdList, (Integer)type);
            log.info((Object)("get resultList, list size is : " + resultList.size()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("studentPracticeKeyList", (Object)resultList);
            model.addAttribute("total", (Object)practiceIdList.size());
            return "/yi-nucleus-service/subjectPractice/json/subjectPracticeIdList";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getPracticeIdList() failed, parameters: subjectType: " + subjectType + ", type: " + type + ", special: " + special));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/practice/list"}, method={RequestMethod.GET})
    public String getPracticesByIdList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer subjectType, @RequestParam Long[] idList) throws Exception {
        log.info((Object)("Interface GET /a/u/practice/list, Method getPracticesByIdList() parameters: subjectType: " + subjectType + ", idList: " + Arrays.toString((Object[])idList)));
        int validateResult = ParamsUtil.checkParamsOfGetPracticesByIdList((Long[])idList, (Integer)subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            List subjectPracticeList = this.subjectPracticeService.getObjectsByIds(Arrays.asList(idList));
            log.info((Object)("get subjectPractice list , list size is : " + subjectPracticeList.size()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("subjectPracticeList", (Object)subjectPracticeList);
            model.addAttribute("total", (Object)subjectPracticeList.size());
            return "/yi-nucleus-service/subjectPractice/json/subjectPracticeListJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getPracticesByIdList() failed, parameters: subjectType: " + subjectType + ", idList: " + Arrays.toString((Object[])idList)));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }
}

