/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.SubjectOperation;
import com.ptteng.yi.nucleus.service.SubjectOperationService;
import com.qding.common.util.DataUtils;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SubjectOperationController {
    private static final Log log = LogFactory.getLog(SubjectOperationController.class);
    @Resource
    private SubjectOperationService subjectOperationService;

    @RequestMapping(value={"/a/subject/content/list"}, method={RequestMethod.GET})
    public String getSubjectOperationList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer subjectType) throws Exception {
        log.info((Object)("Interface GET /a/subject/content/list, Method getSubjectOperationList() parameter: subjectType: " + subjectType));
        if (DataUtils.isNullOrEmpty((Object)subjectType)) {
            log.info((Object)"Parameter subjectType can not be null");
            model.addAttribute("code", (Object)-1000);
            return "/common/failure";
        }
        if (!subjectType.equals(SubjectOperation.SUBJECT_TWO) && !subjectType.equals(SubjectOperation.SUBJECT_THREE)) {
            log.info((Object)("Error value of parameter subjectType, subjectType is : " + subjectType));
            model.addAttribute("code", (Object)-1001);
            return "/common/failure";
        }
        try {
            List subjectOperationList = this.subjectOperationService.getSubjectOperationListBySubjectTypeAndStatusOrderBySortAndCreateAt(subjectType, SubjectOperation.ON_LINE, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get subjectOperation data list, list size is :" + subjectOperationList.size()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("total", (Object)subjectOperationList.size());
            model.addAttribute("subjectOperationList", (Object)subjectOperationList);
            return "/yi-nucleus-service/subjectOperation/json/subjectOperationListJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getSubjectOperationList() failed, parameter: subjectType: " + subjectType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/subject/content/{id}"}, method={RequestMethod.GET})
    public String getSubjectOperationDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("Interface GET /a/subject/content/{id}, Method getSubjectOperationDetail() parameter: id: " + id));
        try {
            SubjectOperation subjectOperation = this.subjectOperationService.getObjectById(id);
            log.info((Object)("get subjectOperation data success, subjectOperation id is : " + subjectOperation.getId()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("subjectOperation", (Object)subjectOperation);
            return "/yi-nucleus-service/subjectOperation/json/subjectOperationDetailJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getSubjectOperationDetail() failed, parameter: id: " + id));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }
}

