/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.SubjectExam;
import com.ptteng.yi.nucleus.service.SubjectExamService;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SubjectExamController {
    private static final Log log = LogFactory.getLog(SubjectExamController.class);
    @Resource
    private SubjectExamService subjectExamService;

    @RequestMapping(value={"/a/u/mocks/list"}, method={RequestMethod.GET})
    public String getMockExamResult(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Integer subjectType, Integer page, Integer size) throws Exception {
        log.info((Object)("Interface GET /a/u/mocks/list, Method getMockExamResult() parameters: studentId: " + studentId + ", subjectType: " + subjectType));
        int actualSize = ParamsUtil.calculateActualSize((Integer)size);
        int startPosition = ParamsUtil.calculateStartPosition((Integer)page, (Integer)actualSize);
        log.info((Object)("page: " + startPosition + ", size: " + actualSize));
        int validate = ParamsUtil.checkParamsOfStudentIdAndSubjectType((Long)studentId, (Integer)subjectType);
        if (validate != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validate);
            return "/common/failure";
        }
        try {
            List mockExamList = this.subjectExamService.getSubjectExamListByStudentIdAndType(studentId, subjectType, Integer.valueOf(startPosition), Integer.valueOf(actualSize));
            log.info((Object)("get mockExam data list, list size is : " + mockExamList.size()));
            Integer total = this.subjectExamService.countSubjectExamIdsByStudentIdAndType(studentId, subjectType);
            log.info((Object)("count mockExam total, total is : " + total));
            model.addAttribute("code", (Object)0);
            model.addAttribute("size", (Object)actualSize);
            model.addAttribute("total", (Object)total);
            model.addAttribute("subjectExamList", (Object)mockExamList);
            return "/yi-nucleus-service/subjectExam/json/subjectExamListJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getMockExamResult() failed, parameters: studentId: " + studentId + ", subjectType: " + subjectType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/mocks"}, method={RequestMethod.POST})
    public String recordMockExamResult(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Long time, Integer rights, Integer wrong, Integer subjectType) throws Exception {
        log.info((Object)("Interface POST /a/u/mocks, Method recordMockExamResult() parameters: studentId: " + studentId + ", time: " + time + ", rights: " + rights + ", wrong: " + wrong + ", subjectType: " + subjectType));
        int validateResult = ParamsUtil.checkParamsOfRecordMockExamResult((Long)studentId, (Long)time, (Integer)rights, (Integer)wrong, (Integer)subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            SubjectExam mockExam = new SubjectExam();
            mockExam.setStudentId(studentId);
            mockExam.setTime(time);
            mockExam.setRight(rights);
            mockExam.setWrong(wrong);
            mockExam.setType(subjectType);
            mockExam.setCreateBy(studentId);
            mockExam.setUpdateBy(studentId);
            Long mockExamId = this.subjectExamService.insert(mockExam);
            log.info((Object)("insert mock exam result success, id is : " + mockExamId));
            model.addAttribute("code", (Object)0);
            model.addAttribute("id", (Object)mockExamId);
            return "/common/insert";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method recordMockExamResult() failed, parameters: studentId: " + studentId + ", time: " + time + ", rights: " + rights + ", wrong: " + wrong + ", subjectType: " + subjectType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }
}

