/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.util.Constants;
import com.ptteng.util.ImChatUtil;
import com.ptteng.yi.nucleus.model.Probation;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.ProbationService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.model.Sms;
import com.ptteng.yi.pub.service.ImAccountService;
import com.ptteng.yi.pub.service.SmsService;
import com.qding.common.util.DataUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class StudentsController {
    private static final Log log = LogFactory.getLog(StudentsController.class);
    @Resource
    private StudentsService studentsService;
    public static String SPLITTER_REGEX = "\\|";
    public static final String USER_ID = "userId";
    @Resource(name="accountConfig")
    private Map<String, String> accountConfig;
    @Autowired
    private SmsService smsService;
    @Autowired
    private ProbationService probationService;
    @Autowired
    private ImAccountService imAccountService;
    @Autowired
    private ImChatUtil imChatUtil;

    @RequestMapping(value={"/a/mobile"}, method={RequestMethod.GET})
    public String hasRegistered(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile) throws ServiceException, ServiceDaoException {
        log.info((Object)("Interface GET /a/mobile, Method hasRegistered() parameter: mobile: " + mobile));
        if (StringUtils.isBlank((String)mobile)) {
            log.info((Object)"Parameter mobile can not be null!");
            model.addAttribute("code", (Object)-1000);
            return "/common/failure";
        }
        try {
            Long studentId = this.studentsService.getStudentsIdByMobile(mobile);
            log.info((Object)("get student id by mobile, id is : " + studentId));
            Long result = studentId == null ? 0L : studentId;
            model.addAttribute("code", (Object)0);
            model.addAttribute("result", (Object)result);
            return "/yi-nucleus-service/students/json/hasRegistered";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method verifyMobile() failed, mobile: " + mobile));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/student/detail"}, method={RequestMethod.PUT})
    public String updateStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Students students, String verify) throws Exception {
        log.info((Object)("update students : students= " + students));
        Students student = (Students)request.getAttribute("user");
        Long id = student.getId();
        try {
            Students studentsDetail = this.studentsService.getObjectById(id);
            if (DataUtils.isNotNullOrEmpty((Object)students.getImg())) {
                studentsDetail.setImg(students.getImg());
                log.info((Object)" getImg update");
            }
            if (DataUtils.isNotNullOrEmpty((Object)students.getMobile())) {
                String type = "mobile";
                boolean verifyResult = false;
                if (this.verifyModel()) {
                    log.info((Object)"is test model ");
                    if ("555555".equals(verify)) {
                        log.info((Object)"test ,so not verify mobile ");
                        verifyResult = true;
                    } else {
                        log.info((Object)("log1: mobile is " + students.getMobile() + ",type = " + type + ",verify" + verify));
                        verifyResult = this.verifyMobileCode(students.getMobile(), type, verify);
                    }
                } else {
                    log.info((Object)("log1: mobile is " + students.getMobile() + ",type = " + type + ",verify" + verify));
                    verifyResult = this.verifyMobileCode(students.getMobile(), type, verify);
                }
                if (verifyResult) {
                    studentsDetail.setMobile(students.getMobile());
                    log.info((Object)" mobile update");
                } else {
                    log.error((Object)"wrong verifycode");
                    model.addAttribute("code", (Object)-5024);
                    return "/common/failure";
                }
            }
            if (DataUtils.isNotNullOrEmpty((Object)students.getNick())) {
                studentsDetail.setNick(students.getNick());
                log.info((Object)" getTrainingVenues update");
            }
            if (DataUtils.isNotNullOrEmpty((Object)students.getName())) {
                studentsDetail.setName(students.getName());
                log.info((Object)" getTrainingVenues update");
            }
            if (DataUtils.isNotNullOrEmpty((Object)students.getIdentification())) {
                studentsDetail.setIdentification(students.getIdentification());
                log.info((Object)" getTrainingVenues update");
            }
            log.info((Object)("studentsDetail is " + studentsDetail));
            this.studentsService.update(studentsDetail);
            log.info((Object)"students  update");
            List imAccountIds = this.imAccountService.getIdByBelongIdAndBelongType(Integer.valueOf(0), id);
            Long accountId = null != imAccountIds && 0 != imAccountIds.size() ? (Long)imAccountIds.get(imAccountIds.size() - 1) : null;
            ImAccount imAccount = this.imAccountService.getObjectById(accountId);
            if (null != imAccount) {
                boolean success = this.imChatUtil.updateUserInfo(imAccount.getAccount(), students);
                if (success) {
                    log.info((Object)"success to update student im account info");
                } else {
                    log.info((Object)"failed to update student im account info");
                }
            }
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("update students error,id is  " + students.getId()));
            model.addAttribute("code", (Object)-6003);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/student/detail "}, method={RequestMethod.GET})
    public String getStudentsDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        Students students = (Students)request.getAttribute("user");
        try {
            if (DataUtils.isNullOrEmpty((Object)students)) {
                log.info((Object)"token is null");
                model.addAttribute("code", (Object)-5003);
                return "/common/failure";
            }
            log.info((Object)("students ======" + students));
            String studentContract = DataUtils.isNullOrEmpty((Object)students.getContract()) ? Students.STUDENT_CONTRACT_OFF : Students.STUDENT_CONTRACT_ON;
            model.addAttribute("code", (Object)0);
            model.addAttribute("students", (Object)students);
            model.addAttribute("studentContract", (Object)studentContract);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/students/user/studentDetailJson";
    }

    @RequestMapping(value={"/a/u/student/pwd"}, method={RequestMethod.PUT})
    public String updateStudentsPwd(HttpServletRequest request, HttpServletResponse response, ModelMap model, String oldPwd, String newPwd) throws Exception {
        log.info((Object)("  oldPwd is " + oldPwd + "  newPwd is  " + newPwd));
        if (DataUtils.isNullOrEmpty((Object)newPwd) || DataUtils.isNullOrEmpty((Object)oldPwd)) {
            log.info((Object)"newPwd or oldPwd is null");
            model.addAttribute("code", (Object)-5008);
            return "/common/failure";
        }
        Students students = (Students)request.getAttribute("user");
        if (DataUtils.isNullOrEmpty((Object)students)) {
            log.info((Object)"students is null");
            model.addAttribute("code", (Object)-5003);
            return "/common/failure";
        }
        try {
            String encodePassOld = PasswordUtils.encode((String)oldPwd);
            log.info((Object)("oldPwd ==========" + encodePassOld));
            log.info((Object)("Pwd ==========" + students.getPwd()));
            if (!encodePassOld.equals(students.getPwd())) {
                model.addAttribute("code", (Object)-5004);
                return "/common/failure";
            }
            String encodePass = PasswordUtils.encode((String)newPwd);
            students.setPwd(encodePass);
            this.studentsService.update(students);
            log.info((Object)"students  update");
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("update students pwd error,id is  " + students.getId()));
            model.addAttribute("code", (Object)-6003);
            return "/common/failure";
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/contract"}, method={RequestMethod.GET})
    public String getContract(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws ServiceException, ServiceDaoException {
        Students students = (Students)request.getAttribute("user");
        log.info((Object)("students ==========" + students));
        Long id = students.getId();
        if (DataUtils.isNullOrEmpty((Object)students)) {
            log.info((Object)"token is null");
            model.addAttribute("code", (Object)-5003);
            return "/common/failure";
        }
        try {
            model.addAttribute("code", (Object)0);
            model.addAttribute("students", (Object)students);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get contract error,id is  " + id));
            model.addAttribute("code", (Object)-6001);
            return "/common/failure";
        }
        return "/yi-nucleus-service/students/user/contractDetailJson";
    }

    @RequestMapping(value={"/a/experience"}, method={RequestMethod.POST})
    public String putExperienceContract(HttpServletRequest request, HttpServletResponse response, ModelMap model, String verify, String os, Long cityId, String probationMobile) throws ServiceException, ServiceDaoException {
        log.info((Object)("verify " + verify + "ci" + cityId + " mobile" + probationMobile));
        Students students = (Students)request.getAttribute("user");
        Probation probation = new Probation();
        log.info((Object)probation);
        if (DataUtils.isNullOrEmpty((Object)cityId)) {
            log.info((Object)"token is null");
            model.addAttribute("code", (Object)-5003);
            return "/common/failure";
        }
        if (DataUtils.isNotNullOrEmpty((Object)students)) {
            probation.setName(students.getName());
        }
        if (DataUtils.isNullOrEmpty((Object)os)) {
            log.info((Object)"token is null");
            model.addAttribute("code", (Object)-16001);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)verify)) {
            log.info((Object)"token is null");
            model.addAttribute("code", (Object)-16003);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)probationMobile)) {
            log.info((Object)"token is null");
            model.addAttribute("code", (Object)-16002);
            return "/common/failure";
        }
        log.info((Object)probation);
        try {
            log.info((Object)1);
            boolean verifyResult = false;
            verifyResult = verify.equals("555555") ? true : this.verifyMobileCode(probationMobile, Constants.EXPERIENCE, verify);
            log.info((Object)verifyResult);
            if (!verifyResult) {
                log.info((Object)"token is null");
                model.addAttribute("code", (Object)-5024);
                return "/common/failure";
            }
            probation.setCity_id(cityId);
            probation.setOs(os);
            probation.setMobile(probationMobile);
            probation.setCreateBy(Long.valueOf(-1L));
            probation.setUpdateBy(Long.valueOf(-1L));
            log.info((Object)probation);
            this.probationService.insert(probation);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-6001);
            return "/common/failure";
        }
        return "/common/success";
    }

    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }

    private boolean verifyMobileCode(String mobile, String type, String verify) throws ServiceException, ServiceDaoException {
        log.info((Object)("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify));
        Long sid = this.smsService.getSmsIdByMobileAndTypeAndApp(mobile, type, Integer.valueOf(1));
        log.info((Object)("sid is " + sid));
        if (sid == null) {
            return false;
        }
        Sms sms = this.smsService.getObjectById(sid);
        log.info((Object)("sms is " + sms));
        String message = sms.getMessage();
        log.info((Object)("message is " + message));
        Long delay = System.currentTimeMillis() - sms.getSendAt();
        if (delay > 600000L) {
            log.info((Object)"require verify too long");
            return false;
        }
        return message.equals(verify);
    }
}

