/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.StudentFavoriteRelation;
import com.ptteng.yi.nucleus.service.StudentFavoriteRelationService;
import com.qding.common.util.DataUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class StudentFavoriteRelationController {
    private static final Log log = LogFactory.getLog(StudentFavoriteRelationController.class);
    @Resource
    private StudentFavoriteRelationService studentFavoriteRelationService;

    @RequestMapping(value={"/a/u/favorite"}, method={RequestMethod.POST})
    public String recordFavorite(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Long targetId, Integer targetType) throws Exception {
        log.info((Object)("Interface POST /a/u/favorite, Method recordFavorite() parameters, studentId : " + studentId + ", targetId: " + targetId + ", targetType: " + targetType));
        int validateResult = ParamsUtil.checkParamsOfRecordFavorite((Long)studentId, (Long)targetId, (Integer)targetType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            StudentFavoriteRelation studentFavoriteRelation = new StudentFavoriteRelation();
            studentFavoriteRelation.setStudentId(studentId);
            studentFavoriteRelation.setTargetId(targetId);
            studentFavoriteRelation.setTargetType(targetType);
            studentFavoriteRelation.setCreateBy(studentId);
            studentFavoriteRelation.setUpdateBy(studentId);
            Long studentFavoriteRelationId = this.studentFavoriteRelationService.insert(studentFavoriteRelation);
            log.info((Object)("insert studentFavoriteRelation success, studentFavoriteRelation id is : " + studentFavoriteRelationId));
            model.addAttribute("code", (Object)0);
            model.addAttribute("id", (Object)studentFavoriteRelationId);
            return "/common/insert";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method recordFavorite() failed, parameters, studentId : " + studentId + ", targetId: " + targetId + ", targetType: " + targetType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/favorite"}, method={RequestMethod.DELETE})
    public String removeFavorite(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Long targetId) throws Exception {
        log.info((Object)("Interface DELETE /a/u/favorite, Method recordFavorite() parameters, studentId : " + studentId + ", targetId: " + targetId));
        int validateResult = ParamsUtil.checkParamsOfRemoveFavorite((Long)studentId, (Long)targetId);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            Long studentFavoriteRelationId = this.studentFavoriteRelationService.getStudentFavoriteRelationIdByStudentIdAndTargetId(studentId, targetId);
            if (DataUtils.isNullOrEmpty((Object)studentFavoriteRelationId)) {
                log.info((Object)("Can not find studentFavoriteRelation by studentId,targetId: " + studentId + ", " + targetId));
                model.addAttribute("code", (Object)-1001);
                return "/common/failure";
            }
            log.info((Object)("get studentFavoriteRelation id by studentId,targetId, id is : " + studentFavoriteRelationId));
            this.studentFavoriteRelationService.delete(studentFavoriteRelationId);
            log.info((Object)"delete student favorite success");
            model.addAttribute("code", (Object)0);
            return "/common/success";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method recordFavorite() parameters failed , studentId : " + studentId + ", targetId: " + targetId));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }
}

