/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.model.SignsNumber;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Sign;
import com.ptteng.yi.nucleus.model.SubjectPractice;
import com.ptteng.yi.nucleus.service.SignService;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SignController {
    private static final Log log = LogFactory.getLog(SignController.class);
    @Resource
    private SignService signService;
    @Resource
    private SubjectPracticeService subjectPracticeService;
    @Resource
    private String[] trafficSigns;
    @Resource
    private String[] carSigns;

    @RequestMapping(value={"/a/u/sign/record"}, method={RequestMethod.GET})
    public String getSignRecord(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        log.info((Object)"Interface GET /a/u/sign/record, Method getSignRecord() begin----------------------");
        try {
            Integer total = 0;
            log.info((Object)("trafficSigns is " + Arrays.toString(this.trafficSigns)));
            Map trafficMap = this.signService.countNumberOfSigns(Sign.TRAFFIC_SIGNS, this.trafficSigns);
            log.info((Object)("trafficMap =======" + trafficMap));
            Map carMap = this.signService.countNumberOfSigns(Sign.CAR_SIGNS, this.carSigns);
            log.info((Object)("get trafficMap, carMap size is : " + trafficMap + ", " + carMap));
            Map trafficTypeMap = this.urlOfSigns(this.trafficSigns, Integer.valueOf(1));
            Map carTypeMap = this.urlOfSigns(this.carSigns, Integer.valueOf(2));
            List signsNumberList = SignsNumber.convertMapToSignsNumberList((Map)trafficMap, (Integer)Sign.TRAFFIC_SIGNS, new ArrayList(), (Map)trafficTypeMap);
            signsNumberList = SignsNumber.convertMapToSignsNumberList((Map)carMap, (Integer)Sign.CAR_SIGNS, (List)signsNumberList, (Map)carTypeMap);
            log.info((Object)("get signsNumberList data, list size is : " + signsNumberList.size()));
            total = this.signService.countSignIdsByType(Integer.valueOf(1));
            log.info((Object)("total is " + total));
            model.addAttribute("total", (Object)total);
            model.addAttribute("code", (Object)0);
            model.addAttribute("signsNumberList", (Object)signsNumberList);
            return "/yi-nucleus-service/sign/json/signsNumberList";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)"Method getSignRecord() failed ----------------------");
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/sign/list"}, method={RequestMethod.GET})
    public String getSignsList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, String signType, Integer page, Integer size) throws Exception {
        log.info((Object)("Interface GET /a/u/sign/list, Method getSignsList() parameters: type: " + type + ", signType: " + signType));
        int actualSize = ParamsUtil.calculateActualSize((Integer)size);
        int startPosition = ParamsUtil.calculateStartPosition((Integer)page, (Integer)actualSize);
        log.info((Object)("page: " + startPosition + ", size: " + actualSize));
        int validateResult = ParamsUtil.checkParamsOfGetSignsList((Integer)type, (String)signType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            List signList = null;
            Integer total = 0;
            if (type.equals(Sign.EXAM_POINT)) {
                signList = this.signService.getSignListByType(type, Integer.valueOf(startPosition), Integer.valueOf(Integer.MAX_VALUE));
                total = this.signService.countSignIdsByType(type);
            } else {
                signList = this.signService.getSignListByTypeAndSignType(type, signType, Integer.valueOf(startPosition), Integer.valueOf(actualSize));
                total = this.signService.countSignIdsByTypeAndSignType(type, signType);
            }
            log.info((Object)("get sign data list, list size is : " + signList.size()));
            log.info((Object)("count sign total, total is : " + total));
            model.addAttribute("code", (Object)0);
            model.addAttribute("size", (Object)actualSize);
            model.addAttribute("total", (Object)total);
            String[] signsArray = new String[]{"specialList", "signList", "signList"};
            model.addAttribute(signsArray[type], (Object)signList);
            return "/yi-nucleus-service/sign/json/signListJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getSignsList() failed, parameters: type: " + type + ", signType: " + signType + "page: " + page + ", size: " + size));
            model.addAttribute("code", (Object)-1);
            return "/common/success";
        }
    }

    @RequestMapping(value={"/a/u/sign/{id}"}, method={RequestMethod.GET})
    public String getSignDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("Interface GET /a/u/sign/{id}, Method getSignDetail() parameter: id is : " + id));
        try {
            Sign sign = this.signService.getObjectById(id);
            log.info((Object)("get sign data, sign is : " + sign));
            if (DataUtils.isNullOrEmpty((Object)sign)) {
                log.info((Object)("Can not find sign by id, id is : " + id));
                model.addAttribute("code", (Object)-1001);
                return "/common/failure";
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("sign", (Object)sign);
            return "/yi-nucleus-service/sign/json/signDetailJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getSignDetail() failed, parameter: id is : " + id));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/special"}, method={RequestMethod.GET})
    public String getExaminationPoint(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id, String title, Integer subjectType) throws Exception {
        log.info((Object)("Interface GET /a/u/special, Method getExaminationPoint() parameters, id: " + id + ", title: " + title + ", subjectType: " + subjectType));
        int validateResult = ParamsUtil.checkParamsOfGetExaminationPoint((Long)id, (String)title, (Integer)subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            if (DataUtils.isNotNullOrEmpty((Object)title)) {
                id = this.signService.getSignIdByTitle(title);
                if (DataUtils.isNullOrEmpty((Object)id)) {
                    log.info((Object)("Can not find sign by title, title is : " + title));
                    model.addAttribute("code", (Object)-1001);
                    return "/common/failure";
                }
                log.info((Object)("get sign id by title, id is : " + id));
            }
            Sign sign = this.signService.getObjectById(id);
            log.info((Object)("get sign data by id, id is : " + sign.getId()));
            String special = sign.getTitle();
            Map countSpecialPracticeIdsMap = DynamicUtil.getSpecialPracticeParams((Integer)subjectType, (String)special, (Boolean)true);
            Long total = (Long)this.subjectPracticeService.getIdsByDynamicCondition(SubjectPractice.class, countSpecialPracticeIdsMap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).get(0);
            log.info((Object)("count special practice total, total is : " + total));
            model.addAttribute("code", (Object)0);
            model.addAttribute("sign", (Object)sign);
            model.addAttribute("total", (Object)total);
            return "/yi-nucleus-service/sign/json/signDetailJson";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getExaminationPoint() failed, parameters, id: " + id + ", title: " + title + ", subjectType: " + subjectType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    private String getSignTypeUrlBySignType(String signType, Integer type) throws ServiceException, ServiceDaoException {
        log.info((Object)("signType is " + signType));
        List signIds = this.signService.getSignIdsByTypeAndSignType(type, signType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        Sign sign = this.signService.getObjectById(Long.valueOf(String.valueOf(signIds.get(0))));
        String signTypeUrl = sign.getImage();
        return signTypeUrl;
    }

    private Map<String, String> urlOfSigns(String[] signTypes, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" signTypes array is : " + Arrays.toString(signTypes)));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (int i = 0; i < signTypes.length; ++i) {
                String url = this.getSignTypeUrlBySignType(signTypes[i], type);
                map.put(signTypes[i], url);
            }
        }
        catch (Throwable t) {
            log.error((Object)(" get url is  wrong by signType  : " + Arrays.toString(signTypes)));
            log.error((Object)t.getMessage());
            t.printStackTrace();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get urlOfSigns is success , map size is : " + map.size()));
        }
        return map;
    }
}

