/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.Center;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.CenterService;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.ptteng.yi.pub.model.Cities;
import com.ptteng.yi.pub.service.CitiesService;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SchoolController {
    private static final Log log = LogFactory.getLog(SchoolController.class);
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private CenterService centerService;
    @Autowired
    private CitiesService citiesService;

    @RequestMapping(value={"/a/u/school/{id}"}, method={RequestMethod.GET})
    public String getSchoolJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get data : id= " + id));
        try {
            School school = this.schoolService.getObjectById(id);
            log.info((Object)("get school data is " + school));
            model.addAttribute("code", (Object)0);
            model.addAttribute("school", (Object)school);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get school error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/school/json/schoolDetailJson";
    }

    @RequestMapping(value={"/a/city/list"}, method={RequestMethod.GET})
    public String geCityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        try {
            List ids = new ArrayList();
            List cids = new ArrayList();
            Map map = new HashMap();
            Map cmap = new HashMap();
            map = DynamicUtil.geCenterByCityIdAndStatus(null, (Integer)1);
            ids = this.centerService.getIdsByDynamicCondition(Center.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            cmap = DynamicUtil.getCity();
            cids = this.citiesService.getIdsByDynamicCondition(Cities.class, cmap, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List centerList = this.centerService.getObjectsByIds(ids);
            List cityList = this.citiesService.getObjectsByIds(cids);
            for (Center center : centerList) {
                for (Cities cities : cityList) {
                    if (!center.getCityId().equals(cities.getCityid())) continue;
                    center.setName(cities.getCity());
                    log.info((Object)center);
                }
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("centerList", (Object)centerList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/center/json/centerListJson";
    }

    @RequestMapping(value={"/a/u/school/officemobile "}, method={RequestMethod.GET})
    public String getMessageList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        try {
            log.info((Object)"==========\u83b7\u53d6\u7528\u6237ID==========");
            Students student = (Students)request.getAttribute("user");
            Long uid = student.getId();
            log.info((Object)("\u83b7\u53d6\u7684studentId =" + uid));
            Map map = DynamicUtil.geCenterByCityIdAndStatus((Long)student.getCityId(), (Integer)1);
            List centerIds = this.centerService.getIdsByDynamicCondition(Center.class, map, Integer.valueOf(0), Integer.valueOf(1));
            log.info((Object)("get center ids is " + centerIds));
            if (CollectionUtils.isNotEmpty((Collection)centerIds)) {
                Center center = this.centerService.getObjectById((Long)centerIds.get(0));
                Long officeMobile = center.getAfterMobile();
                String mobile = "";
                if (DataUtils.isNotNullOrEmpty((Object)officeMobile)) {
                    mobile = officeMobile.toString();
                }
                log.info((Object)("this center city id is " + student.getCityId() + " ,after mobile is " + officeMobile));
                model.addAttribute("officeMobile", (Object)mobile);
            } else {
                log.info((Object)"this center not found!");
            }
            School school = this.schoolService.getObjectById(student.getSchoolId());
            String hotline = school.getHotline();
            model.addAttribute("hotline", (Object)hotline);
            model.addAttribute("code", (Object)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/school/json/schoolOfficeMobile";
    }
}

