/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.constant.AlipayConstantConfig;
import com.ptteng.constant.WxConstantConfig;
import com.ptteng.util.Base64;
import com.ptteng.util.Calculation;
import com.ptteng.util.Constants;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.MD5;
import com.ptteng.util.OrderIdUtil;
import com.ptteng.util.WxUtil;
import com.ptteng.util.XmlUtil;
import com.ptteng.yi.nucleus.model.Card;
import com.ptteng.yi.nucleus.model.CardType;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.model.EnrollmentDetail;
import com.ptteng.yi.nucleus.model.Order;
import com.ptteng.yi.nucleus.model.Record;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.CardService;
import com.ptteng.yi.nucleus.service.CardTypeService;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.nucleus.service.EnrollmentDetailService;
import com.ptteng.yi.nucleus.service.OrderService;
import com.ptteng.yi.nucleus.service.RecordService;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class OrderController {
    private static final Log log = LogFactory.getLog(OrderController.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private DrivingClassService drivingClassService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private SchoolClassRelationService schoolClassRelationService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private CardService cardService;
    @Autowired
    private CardTypeService cardTypeService;
    @Autowired
    private StudentsService studentsService;
    @Resource
    private EnrollmentDetailService enrollmentDetailService;
    @Resource
    private RecordService recordService;
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    @RequestMapping(value={"/a/u/order/"}, method={RequestMethod.GET})
    public String getOrderJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get data : id= " + id));
        try {
            Students student = (Students)request.getAttribute("user");
            if (DataUtils.isNullOrEmpty((Object)student)) {
                model.addAttribute("code", (Object)-5001);
                log.info((Object)"user has buy");
                return "/common/failure";
            }
            Map map = DynamicUtil.getOrderList(null, (Long)student.getId(), null, null, null, (Integer)3);
            List orderIds = this.orderService.getIdsByDynamicCondition(Order.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            if (DataUtils.isNullOrEmpty((Object)orderIds)) {
                model.addAttribute("code", (Object)-22026);
                log.info((Object)"user has buy");
                return "/common/failure";
            }
            List orderList = this.orderService.getObjectsByIds(orderIds);
            model.addAttribute("code", (Object)0);
            model.addAttribute("orderList", (Object)orderList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get order error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/order/json/orderListJson";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/a/u/order"}, method={RequestMethod.POST})
    public String createOrder(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long targetId, Integer type, Long schoolId, Long cid) throws Exception {
        log.info((Object)("tid " + targetId + "sid " + schoolId + "cid" + cid + "type " + type));
        try {
            Students student = (Students)request.getAttribute("user");
            Order order = new Order();
            Long uid = student.getId();
            Double cost = null;
            Double value = null;
            Double actualPay = null;
            School school = this.schoolService.getObjectById(schoolId);
            HashMap hashMap = new HashMap();
            Map map = DynamicUtil.getOrderList(null, (Long)uid, null, null, null, (Integer)3);
            List uids = this.orderService.getIdsByDynamicCondition(Order.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("uids :" + uids));
            if (uids.size() > 0) {
                model.addAttribute("code", (Object)-21007);
                log.info((Object)"parameter schools is null or empty");
                return "/common/failure";
            }
            log.info((Object)("school :" + school));
            if (DataUtils.isNullOrEmpty((Object)school)) {
                model.addAttribute("code", (Object)-21000);
                log.info((Object)"user has buy");
                return "/common/failure";
            }
            order.setSchoolId(schoolId);
            log.info((Object)("targetId" + targetId));
            DrivingClass drivingClass = null;
            if (!type.equals(0)) {
                model.addAttribute("code", (Object)-9024);
                log.info((Object)"parameter schools is null or empty");
                return "/common/failure";
            }
            drivingClass = this.drivingClassService.getObjectById(targetId);
            log.info((Object)drivingClass);
            if (DataUtils.isNullOrEmpty((Object)drivingClass)) {
                model.addAttribute("code", (Object)-9024);
                log.info((Object)"parameter schools is null or empty");
                return "/common/failure";
            }
            order.setShopName(drivingClass.getName());
            order.setClassId(drivingClass.getId());
            cost = Double.valueOf(drivingClass.getCost());
            if (DataUtils.isNullOrEmpty((Object)uid)) {
                model.addAttribute("code", (Object)-9024);
                log.info((Object)"parameter uid is null or empty");
                return "/common/failure";
            }
            order.setStuId(uid);
            if (DataUtils.isNullOrEmpty((Object)student.getIdentification())) {
                model.addAttribute("code", (Object)-21002);
                log.info((Object)"parameter mobile is null or empty");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty((Object)student.getName())) {
                model.addAttribute("code", (Object)-21003);
                log.info((Object)"parameter mobile is null or empty");
                return "/common/failure";
            }
            log.info((Object)"\u4f18\u60e0\u5238");
            if (DataUtils.isNotNullOrEmpty((Object)cid)) {
                Card card = this.cardService.getObjectById(cid);
                CardType cardType = this.cardTypeService.getObjectById(card.getTid());
                order.setCoupons(cid.toString());
                List schoolList = OrderIdUtil.getarray((String)card.getSchools());
                log.info((Object)(schoolList + "schoolList"));
                List classList = OrderIdUtil.getarray((String)card.getClasses());
                log.info((Object)(classList + "classList"));
                if (!classList.contains(targetId)) {
                    log.info((Object)"class\u4e0d\u53ef\u7528");
                    model.addAttribute("code", (Object)-21006);
                    return "/common/failure";
                }
                if (!schoolList.contains(schoolId)) {
                    log.info((Object)"school\u4e0d\u53ef\u7528");
                    model.addAttribute("code", (Object)-21008);
                    return "/common/failure";
                }
                value = (double)cardType.getValue();
                if (!card.getStatus().equals(Constants.ALLLOW)) {
                    log.info((Object)"card\u4e0d\u53ef\u7528");
                    model.addAttribute("code", (Object)-21011);
                    return "/common/failure";
                }
                log.info((Object)"card\u53ef\u7528");
                order.setCoupons(cid.toString());
            } else {
                value = 0.0;
                order.setCoupons("0");
            }
            cost = Calculation.sub((double)cost, (double)0.0);
            log.info((Object)(cost + "cost============="));
            order.setCost(cost.toString());
            order.setStatus(0);
            order.setPayType(Integer.valueOf(0));
            order.setCityId(school.getCityId());
            actualPay = Calculation.sub((double)cost, (double)value);
            log.info((Object)(actualPay + "acpay"));
            log.info((Object)(cost + "cos"));
            log.info((Object)(value + "value"));
            order.setConcessionaryAmount(value.toString());
            order.setActualPayment(actualPay.toString());
            log.info((Object)("order" + order));
            log.info((Object)"==========\u751f\u6210\u8ba2\u5355\u53f7==========");
            String order_Id = OrderIdUtil.generateOrderId();
            order.setOid(order_Id);
            order.setCreateBy(uid);
            order.setUpdateBy(uid);
            log.info((Object)(order_Id + "orderid"));
            HashMap hashMap2 = new HashMap();
            Map map2 = DynamicUtil.getOrderList(null, (Long)uid, (Long)schoolId, null, (String)order_Id, null);
            List oids = this.orderService.getIdsByDynamicCondition(Order.class, map2, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            while (true) {
                if (oids.size() <= 0) {
                    log.info((Object)order);
                    Long currentTime = System.currentTimeMillis();
                    Long oid = this.orderService.insert(order);
                    model.addAttribute("code", (Object)0);
                    model.addAttribute("oid", (Object)oid);
                    model.addAttribute("orderNo", (Object)order_Id);
                    model.addAttribute("school", (Object)school);
                    model.addAttribute("drivingClass", (Object)drivingClass);
                    model.addAttribute("order", (Object)order);
                    model.addAttribute("currentTime", (Object)currentTime);
                    return "/yi-nucleus-service/order/json/orderDetailJson";
                }
                order_Id = OrderIdUtil.generateOrderId();
                order.setOid(order_Id);
            }
        }
        catch (Throwable t) {
            model.addAttribute("code", (Object)-1);
        }
        return "/yi-nucleus-service/order/json/orderDetailJson";
    }

    @RequestMapping(value={"/a/u/order/contract/{oid}"}, method={RequestMethod.PUT})
    public String updateContract(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid, String contract) throws Exception {
        log.info((Object)("save order : " + oid + " payment type : " + contract));
        Students user = (Students)request.getAttribute("user");
        Long uid = user.getId();
        log.info((Object)("get uid " + uid));
        try {
            log.info((Object)"==========\u68c0\u9a8c\u662f\u5426\u62e5\u6709\u672c\u8ba2\u5355==========");
            Order order = this.orderService.getObjectById(oid);
            Integer status = null;
            if (DataUtils.isNullOrEmpty((Object)contract)) {
                model.addAttribute("code", (Object)-21006);
                log.info((Object)" center roleid is null");
                return "/data/json";
            }
            if (DataUtils.isNotNullOrEmpty((Object)order)) {
                status = order.getStatus();
                log.info((Object)(status + "status"));
                if (!status.equals(0)) {
                    log.info((Object)"not your order");
                    model.addAttribute("code", (Object)-4016);
                    return "/common/success";
                }
            } else {
                log.info((Object)"not your order");
                model.addAttribute("code", (Object)-4016);
                return "/common/success";
            }
            order.setContract(contract);
            log.info((Object)"set contract ");
            this.orderService.update(order);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("update pay way error, oid is  " + oid));
            model.addAttribute("code", (Object)-1);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/order/pay/{oid}"}, method={RequestMethod.PUT})
    public String updatePayWay(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid, Integer payWay) throws Exception {
        log.info((Object)("save order : " + oid + " payment type : " + payWay));
        Students user = (Students)request.getAttribute("user");
        Long uid = user.getId();
        log.info((Object)("get uid " + uid));
        try {
            if (0 != payWay && 1 != payWay && 2 != payWay) {
                log.info((Object)"illegal payWay");
                model.addAttribute("code", (Object)-4017);
                return "/common/success";
            }
            log.info((Object)"==========\u68c0\u9a8c\u662f\u5426\u62e5\u6709\u672c\u8ba2\u5355==========");
            Order order = this.orderService.getObjectById(oid);
            Integer status = order.getStatus();
            if (!order.getStuId().equals(uid) || !status.equals(0)) {
                log.info((Object)("order.getStuId().equals(uid)" + order.getStuId().equals(uid)));
                log.info((Object)("status.equals(0)" + status.equals(0)));
                log.info((Object)"not your order");
                model.addAttribute("code", (Object)-4016);
                return "/common/success";
            }
            log.info((Object)"==========\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f==========");
            order.setPayWay(payWay.intValue());
            this.orderService.update(order);
            log.info((Object)"update payment success");
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("update pay way error, oid is  " + oid));
            model.addAttribute("code", (Object)-1);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/order/result/{oid}"}, method={RequestMethod.PUT})
    public String updateResult(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid, Integer result) throws Exception {
        log.info((Object)("save order : " + oid + " pay result : " + result));
        Students user = (Students)request.getAttribute("user");
        Long uid = user.getId();
        log.info((Object)("get uid " + uid));
        try {
            if (null == result) {
                log.info((Object)"null result");
                model.addAttribute("code", (Object)-4045);
                return "/common/success";
            }
            if (1 != result && 2 != result) {
                log.info((Object)"illegal result");
                model.addAttribute("code", (Object)-4018);
                return "/common/success";
            }
            log.info((Object)"==========\u68c0\u9a8c\u662f\u5426\u62e5\u6709\u672c\u8ba2\u5355==========");
            Order Order2 = this.orderService.getObjectById(oid);
            log.info((Object)Order2);
            if (null == Order2) {
                log.info((Object)"no such order");
                model.addAttribute("code", (Object)-3007);
                return "/common/success";
            }
            if (!uid.equals(Order2.getStuId())) {
                log.info((Object)"not your order");
                model.addAttribute("code", (Object)-4016);
                return "/common/success";
            }
            log.info((Object)"==========\u652f\u4ed8\u7ed3\u679c==========");
            if (DataUtils.isNullOrEmpty((Object)Order2.getPayWay())) {
                log.info((Object)"order payType is null");
                model.addAttribute("code", (Object)-3008);
                return "/common/success";
            }
            Integer status = Order2.getStatus();
            if (!status.equals(0)) {
                log.info((Object)"order payType is null");
                model.addAttribute("code", (Object)-3008);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty((Object)Order2.getContract())) {
                log.info((Object)"order payType is null");
                model.addAttribute("code", (Object)-3008);
                return "/common/success";
            }
            if (0 != Order2.getStatus()) {
                log.info((Object)"close or already pay order");
                model.addAttribute("code", (Object)-3009);
                return "/common/success";
            }
            log.info((Object)(" /pay/check indentCode =  " + Order2.getOid()));
            int payManner = Order2.getPayWay();
            log.info((Object)("  payManner = " + payManner));
            switch (payManner) {
                case 0: {
                    log.info((Object)"==========jia==========");
                    break;
                }
                case 1: {
                    log.info((Object)"==========\u652f\u4ed8\u5b9d==========");
                    break;
                }
            }
            if (result.equals(1)) {
                OrderIdUtil orderIdUtil = new OrderIdUtil();
                log.info((Object)"?!!!!!");
                this.saveStuClass(oid, uid);
                log.info((Object)"???????????");
            } else {
                Order2.setStatus(2);
                this.orderService.update(Order2);
            }
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("update order result error, oid is  " + oid));
            model.addAttribute("code", (Object)-1);
        }
        return "/common/success";
    }

    @RequestMapping(value={"/a/u/order/alipay/key/{oid}"}, method={RequestMethod.GET})
    public String getPrivateKey(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) throws Exception {
        log.info((Object)("/a/u/order/alipay/key/{oid}oid:" + oid));
        String subject = "\u6613\u6559\u7ec3\u8ba2\u5355";
        String body = "";
        String indentCode = null;
        String domain = "http://dev.yi.student.ptteng.com";
        try {
            log.info((Object)"==========\u68c0\u9a8c\u662f\u5426\u62e5\u6709\u672c\u8ba2\u5355==========");
            Order order = this.orderService.getObjectById(oid);
            if (DataUtils.isNullOrEmpty((Object)order)) {
                log.info((Object)"illegal result");
                model.addAttribute("code", (Object)-4018);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty((Object)order.getContract())) {
                log.info((Object)"illegal result");
                model.addAttribute("code", (Object)-21012);
                return "/common/success";
            }
            body = order.getShopName();
            String payBack = domain + "/pay/aliBack/" + indentCode;
            log.info((Object)("get pay back url : " + payBack));
            log.info((Object)"==========\u751f\u6210sign==========");
            String perSign = "partner=\"" + AlipayConstantConfig.partner + "\"&seller_id=\"" + AlipayConstantConfig.seller_id + "\"&out_trade_no=\"" + order.getOid() + "\"&subject=\"" + subject + "\"&body=\"" + body + "\"&total_fee=\"" + order.getActualPayment() + "\"&notify_url=\"http://www.xxx.com\"&service=\"mobile.securitypay.pay\"&payment_type=\"1\"&_input_charset=\"utf-8\"&it_b_pay=\"30m\"&show_url=\"m.alipay.com\"";
            String sign = OrderController.sign((String)perSign, (String)AlipayConstantConfig.private_key, (String)"UTF-8");
            log.info((Object)("perSign is " + perSign));
            log.info((Object)("sign : " + sign));
            sign = URLEncoder.encode(sign);
            log.info((Object)("encode sign : " + sign));
            model.addAttribute("code", (Object)0);
            model.addAttribute("sign", (Object)sign);
            model.addAttribute("privateKey", (Object)AlipayConstantConfig.private_key);
            model.addAttribute("orderSpec", (Object)perSign);
            model.addAttribute("appid", (Object)AlipayConstantConfig.appid);
            model.addAttribute("body", (Object)body);
            model.addAttribute("out_trade_no", (Object)order.getOid());
            model.addAttribute("total_fee", (Object)order.getActualPayment());
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("update pay way error, oid is  " + oid));
            model.addAttribute("code", (Object)-1);
        }
        return "/alipay/tradeQuery";
    }

    @RequestMapping(value={"/a/u/order/wx/key/{oid}"}, method={RequestMethod.GET})
    public String getPayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) {
        log.info((Object)("order : " + oid + " get pay info "));
        XmlUtil xmlUtil = new XmlUtil();
        String name = "";
        try {
            log.info((Object)"==========\u68c0\u9a8c\u662f\u5426\u62e5\u6709\u672c\u8ba2\u5355==========");
            Order order = this.orderService.getObjectById(oid);
            if (null == order) {
                log.info((Object)"already pay the order");
                model.addAttribute("code", (Object)-3007);
                return "/common/success";
            }
            name = order.getShopName();
            BigDecimal money = new BigDecimal(order.getActualPayment());
            money = money.setScale(2, 4);
            Integer total_fee = money.multiply(new BigDecimal(100)).intValue();
            log.info((Object)total_fee);
            Integer status = order.getStatus();
            String nonce_str = OrderController.getRandomStringByLength((int)16);
            String timestamp = OrderController.create_timestamp();
            String perSign = "appid=" + WxConstantConfig.appid + "&body=" + name + "&mch_id=" + WxConstantConfig.mch_id + "&nonce_str=" + nonce_str + "&notify_url=" + WxConstantConfig.notify_url + "&out_trade_no=" + order.getOid() + "&spbill_create_ip=" + WxConstantConfig.spbill_create_ip + "&total_fee=" + total_fee + "&trade_type=APP" + "&key=" + WxConstantConfig.app_key;
            String sign = MD5.MD5Encode((String)perSign);
            sign = WxUtil.exChange((String)sign);
            log.info((Object)("sign is : " + sign));
            String url = "<xml><appid>" + WxConstantConfig.appid + "</appid>" + "<body>" + name + "</body>" + "<mch_id>" + WxConstantConfig.mch_id + "</mch_id>" + "<nonce_str>" + nonce_str + "</nonce_str>" + "<notify_url>" + WxConstantConfig.notify_url + "</notify_url>" + "<out_trade_no>" + order.getOid() + "</out_trade_no>" + "<spbill_create_ip>" + WxConstantConfig.spbill_create_ip + "</spbill_create_ip>" + "<total_fee>" + total_fee + "</total_fee>" + "<trade_type>APP</trade_type>" + "<sign>" + sign + "</sign>" + "</xml>";
            log.info((Object)("url is : " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)WxConstantConfig.order_url, (String)url);
            log.info((Object)("get order url result is " + httpsresponse));
            String prepay_id = xmlUtil.xml(httpsresponse);
            log.info((Object)("prepay_id is :" + prepay_id));
            String perPaySign = "appid=" + WxConstantConfig.appid + "&noncestr=" + nonce_str + "&package=Sign=WXPay" + "&partnerid=" + WxConstantConfig.mch_id + "&prepayid=" + prepay_id + "&timestamp=" + timestamp + "&key=" + WxConstantConfig.app_key;
            String paySign = MD5.MD5Encode((String)perPaySign);
            paySign = WxUtil.exChange((String)paySign);
            log.info((Object)("paySign is :" + paySign));
            model.addAttribute("code", (Object)0);
            model.addAttribute("prepay_id", (Object)prepay_id);
            model.addAttribute("nonceStr", (Object)nonce_str);
            model.addAttribute("partnerid", (Object)WxConstantConfig.mch_id);
            model.addAttribute("appid", (Object)WxConstantConfig.appid);
            model.addAttribute("signType", (Object)"MD5");
            model.addAttribute("timeStamp", (Object)timestamp);
            model.addAttribute("paySign", (Object)paySign);
        }
        catch (Throwable t) {
            log.error((Object)"get signature info error");
            t.printStackTrace();
        }
        return "/weixin/order/show";
    }

    public static String getRandomStringByLength(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public static String setXml(String return_code, String return_msg) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("return_code", return_code);
        parameters.put("return_msg", return_msg);
        return "<xml><return_code><![CDATA[" + return_code + "]]>" + "</return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

    public static String sign(String content, String privateKey, String input_charset) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode((String)privateKey));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            signature.update(content.getBytes(input_charset));
            byte[] signed = signature.sign();
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String saveStuClass(Long oid, Long uid) {
        try {
            log.info((Object)uid);
            log.info((Object)oid);
            Students students = this.studentsService.getObjectById(uid);
            Order order = this.orderService.getObjectById(oid);
            log.info((Object)students);
            order.setStatus(3);
            log.info((Object)order);
            Long c = Long.valueOf(order.getCoupons());
            log.info((Object)c);
            students.setClassId(order.getClassId());
            DrivingClass drivingClass = this.drivingClassService.getObjectById(order.getClassId());
            students.setSectionTwoDenominator(drivingClass.getSubjectTwoHour());
            students.setSectionThreeDenominator(drivingClass.getSubjectThreeHour());
            students.setCost(order.getActualPayment());
            students.setContract(order.getContract());
            students.setCityId(drivingClass.getCityId());
            students.setClassName(drivingClass.getName());
            Long currentTimeMillis = System.currentTimeMillis();
            order.setPayTime(currentTimeMillis.toString());
            students.setRegistrationDate(currentTimeMillis);
            students.setSectionThreeCoach(null);
            students.setSectionTwoCoach(null);
            students.setSectionThreeCoachId(null);
            students.setSectionTwoCoachId(null);
            students.setReceive(Students.RECEIVE_NO.intValue());
            students.setCertification(Students.STATUS_ON.intValue());
            students.setSchoolId(order.getSchoolId());
            School school = this.schoolService.getObjectById(order.getSchoolId());
            students.setCost(order.getActualPayment());
            students.setSectionThreeDenominator(String.valueOf(drivingClass.getSubjectThreeHour()));
            students.setSectionTwoDenominator(String.valueOf(drivingClass.getSubjectTwoHour()));
            EnrollmentDetail enrollmentDetail = new EnrollmentDetail();
            BigDecimal DiscountedAmount = null;
            Double dis = null;
            if (!order.getCoupons().equals("0")) {
                log.info((Object)c);
                Card card = this.cardService.getObjectById(Long.valueOf(order.getCoupons()));
                log.info((Object)Long.valueOf(order.getCoupons()));
                card.setStatus(Integer.valueOf(3));
                log.info((Object)card);
                CardType cardType = this.cardTypeService.getObjectById(card.getTid());
                DiscountedAmount = new BigDecimal(cardType.getValue());
                this.cardService.update(card);
                log.info((Object)"card update");
                log.info((Object)("dis" + DiscountedAmount));
                dis = DiscountedAmount.doubleValue();
            } else {
                DiscountedAmount = new BigDecimal(0);
                dis = DiscountedAmount.doubleValue();
            }
            enrollmentDetail.setCityId(order.getCityId());
            enrollmentDetail.setClassName(drivingClass.getName());
            enrollmentDetail.setCreateBy(uid);
            enrollmentDetail.setUpdateBy(uid);
            enrollmentDetail.setWithdrawId(Long.valueOf(-1L));
            enrollmentDetail.setSettlementId(Long.valueOf(-1L));
            enrollmentDetail.setExpensesId(Long.valueOf(-1L));
            enrollmentDetail.setName(students.getName());
            enrollmentDetail.setWithdrawStatus(EnrollmentDetail.NOT_WITHDRAW.intValue());
            enrollmentDetail.setMobile(students.getMobile());
            enrollmentDetail.setIDNo(students.getIdentification());
            enrollmentDetail.setName(students.getName());
            enrollmentDetail.setSchoolId(students.getSchoolId());
            enrollmentDetail.setSchoolName(school.getName());
            enrollmentDetail.setReceiveTime(Long.valueOf(-1L));
            enrollmentDetail.setPaymentWay(order.getPayWay());
            enrollmentDetail.setStatus(EnrollmentDetail.NOT_WITHDRAW.intValue());
            students.setSchool(school.getName());
            BigDecimal cost = new BigDecimal(order.getCost());
            Double price = cost.doubleValue();
            cost.setScale(2, 4);
            enrollmentDetail.setPrice(cost);
            Double pay = Calculation.sub((double)price, (double)dis);
            BigDecimal payment_amount = new BigDecimal(pay).setScale(2, 4);
            enrollmentDetail.setPaymentAmount(payment_amount);
            log.info((Object)("\u5b9e\u9645\u652f\u4ed8" + payment_amount));
            Double costT = Double.valueOf(order.getCost());
            Double rate = Double.valueOf(school.getRate());
            Double hun = 100.0;
            Double payy = Calculation.div((double)pay, (double)hun);
            Double service_fee = Calculation.mul((double)payy, (double)rate);
            BigDecimal serviceFee = new BigDecimal(service_fee).setScale(2, 4);
            enrollmentDetail.setServiceFee(serviceFee);
            log.info((Object)(serviceFee + "\u670d\u52a1\u8d39"));
            Double actual_income = Calculation.sub((double)pay, (double)service_fee);
            BigDecimal actualIncome = new BigDecimal(actual_income).setScale(4, 4);
            log.info((Object)(actualIncome + "daozhang "));
            enrollmentDetail.setActualIncome(actualIncome);
            students.setCost(payment_amount.toString());
            enrollmentDetail.setDiscountedAmount(DiscountedAmount);
            log.info((Object)("accc   " + actual_income + "serfe " + service_fee + "payment" + payment_amount + "price " + cost));
            log.info((Object)enrollmentDetail);
            Record record = new Record();
            record.setSchoolId(school.getId());
            record.setSchoolName(school.getName());
            record.setAmount(actualIncome);
            record.setStatus(Record.INCOME.intValue());
            record.setUpdateBy(uid);
            record.setCreateBy(uid);
            log.info((Object)"----------");
            log.info((Object)record);
            Long rid = this.recordService.insert(record);
            log.info((Object)"insert record success");
            enrollmentDetail.setIncomeId(rid);
            log.info((Object)enrollmentDetail);
            this.enrollmentDetailService.insert(enrollmentDetail);
            log.info((Object)"insert enrollmentDetail success");
            log.info((Object)students);
            log.info((Object)"update card success");
            this.studentsService.update(students);
            log.info((Object)"update stu success");
            this.orderService.update(order);
            log.info((Object)"update order success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

