/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.util.ListUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Note;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.SubjectExam;
import com.ptteng.yi.nucleus.service.NoteService;
import com.ptteng.yi.nucleus.service.SubjectExamService;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import com.qding.common.util.DataUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class NoteController {
    private static final Log log = LogFactory.getLog(NoteController.class);
    private static final int CLEAR_WRONG_PRACTICE_ON = 1;
    private static final int CLEAR_WRONG_PRACTICE_OFF = 0;
    @Resource
    private NoteService noteService;
    @Resource
    private SubjectPracticeService subjectPracticeService;
    @Resource
    private SubjectExamService subjectExamService;

    @RequestMapping(value={"/a/u/note/error/{id}"}, method={RequestMethod.PUT})
    public String removeErrorPractice(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("Interface PUT /a/u/note/error/{id}, Method removeErrorPractice() parameter, id : " + id));
        try {
            Students students = (Students)request.getAttribute("user");
            Long noteId = this.noteService.getNoteIdByStudentIdAndPracticeId(students.getId(), id);
            Note note = this.noteService.getObjectById(noteId);
            log.info((Object)("get note data by id, note is : " + note));
            if (DataUtils.isNullOrEmpty((Object)note)) {
                log.info((Object)("Can not find note data by id, id is : " + id));
                model.addAttribute("code", (Object)-14000);
                return "/common/failure";
            }
            note.setResult(Note.RESULT_RIGHT);
            this.noteService.update(note);
            log.info((Object)"update note success");
            model.addAttribute("code", (Object)0);
            return "/common/success";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method removeErrorPractice() failed, parameter, id : " + id));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/note/error"}, method={RequestMethod.DELETE})
    public String cleanErrorPractices(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Integer subjectType) throws Exception {
        log.info((Object)("Interface DELETE /a/u/note/error, Method cleanErrorPractices() parameters, studentId: " + studentId + ", subjectType: " + subjectType));
        int validateResult = ParamsUtil.checkParamsOfStudentIdAndSubjectType((Long)studentId, (Integer)subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            List errorPracticeIdList = this.noteService.getNoteIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType, Note.RESULT_WRONG, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get error practice id list, list size is : " + errorPracticeIdList.size()));
            if (CollectionUtils.isNotEmpty((Collection)errorPracticeIdList)) {
                this.noteService.deleteList(Note.class, errorPracticeIdList);
                log.info((Object)"clean up error practices success!");
            }
            model.addAttribute("code", (Object)0);
            return "/common/success";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method cleanErrorPractices() failed, parameters, studentId: " + studentId + ", subjectType: " + subjectType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/note"}, method={RequestMethod.POST})
    public String recordPracticeResult(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Long practiceId, Integer subjectType, Integer result, Integer isRemoved) throws Exception {
        log.info((Object)("Interface POST /a/u/note, Method recordPracticeResult() parameters: studentId : " + studentId + ", practiceId" + practiceId + ", subjectType: " + subjectType + ", result: " + result + ", isRemoved: " + isRemoved));
        int validateResult = ParamsUtil.checkParamsOfRecordPracticeResult((Long)studentId, (Long)practiceId, (Integer)subjectType, (Integer)result, (Integer)isRemoved);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            Long noteId = this.noteService.getNoteIdByStudentIdAndPracticeId(studentId, practiceId);
            log.info((Object)("get note id by studentId and practiceId, note id is : " + noteId));
            if (DataUtils.isNullOrEmpty((Object)noteId)) {
                Note note = new Note();
                note.setStudentId(studentId);
                note.setPracticeId(practiceId);
                note.setSubjectType(subjectType);
                note.setResult(result);
                note.setCreateBy(studentId);
                note.setUpdateBy(studentId);
                noteId = this.noteService.insert(note);
                log.info((Object)("insert note success, note id is : " + noteId));
            } else if (isRemoved == 1 || result.equals(Note.RESULT_WRONG)) {
                Note note = this.noteService.getObjectById(noteId);
                log.info((Object)("get note data by id, note is : " + note));
                note.setResult(result);
                this.noteService.update(note);
                log.info((Object)("update note success, note id is : " + note.getId()));
            }
            model.addAttribute("code", (Object)0);
            return "/common/success";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method recordPracticeResult() failed, parameters: studentId : " + studentId + ", practiceId" + practiceId + ", subjectType: " + subjectType + ", result: " + result));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }

    @RequestMapping(value={"/a/u/exercised/record"}, method={RequestMethod.GET})
    public String getPracticeRecord(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long studentId, Integer subjectType) throws Exception {
        log.info((Object)("Interface GET /a/u/exercised/record, Method getPracticeRecord() parameter: studentId : " + studentId + ", subjectType: " + subjectType));
        int validateResult = ParamsUtil.checkParamsOfStudentIdAndSubjectType((Long)studentId, (Integer)subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", (Object)validateResult);
            return "/common/failure";
        }
        try {
            List total = this.subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List correct = this.noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType, Note.RESULT_RIGHT, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List error = this.noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType, Note.RESULT_WRONG, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get total, correct, error practice size is : " + total + ", " + correct + ", " + error));
            List examList = this.subjectExamService.getSubjectExamListByStudentIdAndType(studentId, subjectType, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get exam data list, list size is : " + examList.size()));
            Integer bestMockScore = null;
            if (1 == subjectType) {
                bestMockScore = ListUtil.getMaxValueFromObjectListByField((List)examList, SubjectExam.class, (String)"right");
                log.info((Object)("get bestMockScore is : " + bestMockScore));
            } else {
                bestMockScore = 2 * ListUtil.getMaxValueFromObjectListByField((List)examList, SubjectExam.class, (String)"right");
                log.info((Object)("get bestMockScore is : " + bestMockScore));
            }
            model.addAttribute("total", (Object)total.size());
            model.addAttribute("correct", (Object)correct.size());
            model.addAttribute("error", (Object)error.size());
            model.addAttribute("code", (Object)0);
            model.addAttribute("bestMockScore", (Object)bestMockScore);
            return "/yi-nucleus-service/note/json/practiceRecord";
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("Method getPracticeRecord() parameter: studentId : " + studentId + ", subjectType: " + subjectType));
            model.addAttribute("code", (Object)-1);
            return "/common/failure";
        }
    }
}

