/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.yi.pub.model.Info;
import com.ptteng.yi.pub.service.CitiesService;
import com.ptteng.yi.pub.service.InfoService;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class InfoController {
    private static final Log log = LogFactory.getLog(InfoController.class);
    @Autowired
    private InfoService infoService;
    @Autowired
    private CitiesService citiesService;

    @RequestMapping(value={"/a/info/{id}"}, method={RequestMethod.GET})
    public String getInfoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("GET request url : /a/info/{id}, get path variable id : " + id));
        try {
            Info info = this.infoService.getObjectById(id);
            log.info((Object)("get info data is " + info));
            if (DataUtils.isNullOrEmpty((Object)info)) {
                log.info((Object)"no this info");
                model.addAttribute("code", (Object)-13000);
                return "/common/failure";
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("info", (Object)info);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get info error, id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-pub-service/info/json/infoDetailJson";
    }

    @RequestMapping(value={"/a/info/list"}, method={RequestMethod.GET})
    public String getMultiInfoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, Long cityId, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("GET request url: /a/info/list, get parameter type: " + type + ", cityId: " + cityId + ", page: " + page + ", size: " + size));
        if (DataUtils.isNullOrEmpty((Object)type)) {
            log.info((Object)"parameter type is null or empty");
            model.addAttribute("code", (Object)-13002);
            return "/common/failure";
        }
        if (type < 0 || type > 4) {
            log.info((Object)"parameter type is illegal");
            model.addAttribute("code", (Object)-13003);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)cityId)) {
            log.info((Object)"parameter cityId is null or empty");
            model.addAttribute("code", (Object)-13005);
            return "/common/failure";
        }
        if (cityId < 1L) {
            log.info((Object)"parameter cityId is illegal");
            model.addAttribute("code", (Object)-13006);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        log.info((Object)("pageList : page= " + start + " , size=" + size));
        try {
            List cityIds = this.citiesService.getCitiesIdsByCityid(cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            if (CollectionUtils.isEmpty((Collection)cityIds)) {
                log.info((Object)"there is no city in DB");
                model.addAttribute("code", (Object)-12003);
                return "/common/failure";
            }
            List infoIds = this.infoService.getInfoIdsByTypeAndStatusAndCityId(type.intValue(), 1, cityId, Integer.valueOf(start), size);
            log.info((Object)("get info id list : " + infoIds));
            Integer total = this.infoService.getInfoIdsByTypeAndStatusAndCityId(type.intValue(), 1, cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).size();
            if (CollectionUtils.isEmpty((Collection)infoIds)) {
                model.addAttribute("infoList", new ArrayList());
            } else {
                List infoList = this.infoService.getObjectsByIds(infoIds);
                log.info((Object)("get infoList data size is " + infoList.size()));
                model.addAttribute("infoList", (Object)infoList);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)total);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get info list error, start is  " + start + " , size " + size));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-pub-service/info/json/infoListJson";
    }
}

