/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.Feedback;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.SubjectPractice;
import com.ptteng.yi.nucleus.service.FeedbackService;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import com.qding.common.util.DataUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class FeedbackController {
    private static final Log log = LogFactory.getLog(FeedbackController.class);
    @Autowired
    private FeedbackService feedbackService;
    @Autowired
    private SubjectPracticeService subjectPracticeService;

    @RequestMapping(value={"/a/u/feedback"}, method={RequestMethod.POST})
    public String addFeedbackJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Feedback feedback) throws Exception {
        log.info((Object)("POST request url: /a/u/feedback, get parameter feedback: " + feedback));
        if (DataUtils.isNullOrEmpty((Object)feedback)) {
            log.info((Object)"no this feedback");
            model.addAttribute("code", (Object)-14000);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty((Object)feedback.getSource())) {
            log.info((Object)"parameter source is null or empty");
            model.addAttribute("code", (Object)-14001);
            return "/common/failure";
        }
        if (feedback.getSource() > 2 || feedback.getSource() < 1) {
            log.info((Object)"parameter source is illegal");
            model.addAttribute("code", (Object)-14002);
            return "/common/failure";
        }
        if (StringUtils.isEmpty((CharSequence)feedback.getDescription())) {
            log.info((Object)"parameter description is null or empty");
            model.addAttribute("code", (Object)-14005);
            return "/common/failure";
        }
        Students student = (Students)request.getAttribute("user");
        try {
            if (feedback.getSource() == 2) {
                if (DataUtils.isNullOrEmpty((Object)feedback.getSpId())) {
                    log.info((Object)"parameter spId is null or empty");
                    model.addAttribute("code", (Object)-14008);
                    return "/common/failure";
                }
                SubjectPractice subjectPractice = this.subjectPracticeService.getObjectById(feedback.getSpId());
                if (subjectPractice == null) {
                    log.info((Object)"no this subjectPractice");
                    model.addAttribute("code", (Object)-14009);
                    return "/common/failure";
                }
                if (DataUtils.isNullOrEmpty((Object)feedback.getScenes())) {
                    log.info((Object)"parameter scenes is null or empty");
                    model.addAttribute("code", (Object)-14003);
                    return "/common/failure";
                }
                if (!feedback.getScenes().matches("([0-9,])*")) {
                    log.info((Object)"parameter scenes is illegal");
                    model.addAttribute("code", (Object)-14010);
                    return "/common/failure";
                }
                String[] scenes = feedback.getScenes().split(",");
                if (scenes.length > 8) {
                    log.info((Object)"parameter scenes length is illegal");
                    model.addAttribute("code", (Object)-14004);
                    return "/common/failure";
                }
                for (int i = 0; i < 9; ++i) {
                    int count = 0;
                    for (int j = 0; j < scenes.length; ++j) {
                        if (Integer.parseInt(scenes[j]) != i) continue;
                        ++count;
                    }
                    if (count <= true) continue;
                    log.info((Object)"the value in scenes is duplicate");
                    model.addAttribute("code", (Object)-14007);
                    return "/common/failure";
                }
            } else {
                feedback.setScenes("");
                feedback.setSpId(Feedback.LONG_NULL_VALUE);
            }
            if (feedback.getImgs() == null) {
                feedback.setImgs("");
            }
            feedback.setId(null);
            if (feedback.getMobile() == null) {
                feedback.setMobile("");
            }
            feedback.setUserMobile(student.getMobile());
            feedback.setName(student.getNick());
            feedback.setCreateBy(student.getId());
            feedback.setUpdateBy(student.getId());
            feedback.setCityId(student.getCityId());
            Long result = this.feedbackService.insert(feedback);
            log.info((Object)("insert feedback result: " + result));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"add feedback error ");
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }
}

