/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class DrivingClassController {
    private static final Log log = LogFactory.getLog(DrivingClassController.class);
    @Autowired
    private DrivingClassService drivingClassService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private SchoolClassRelationService schoolClassRelationService;

    @RequestMapping(value={"/a/class/list "}, method={RequestMethod.GET})
    public String getDrivingClassIdsByStatusOrderByCreateByJsonList(HttpServletRequest request, Integer page, Integer size, HttpServletResponse response, ModelMap model, Long cityId) throws Exception {
        int start;
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        try {
            if (DataUtils.isNullOrEmpty((Object)cityId)) {
                model.addAttribute("code", (Object)-1000);
                log.info((Object)"parameter classes is null or empty");
                return "/common/failure";
            }
            Map map = DynamicUtil.getClassListParams((Long)cityId);
            log.info((Object)("get query news list map : " + map));
            List ids = this.drivingClassService.getIdsByDynamicCondition(DrivingClass.class, map, Integer.valueOf(start), size);
            Integer total = this.drivingClassService.getIdsByDynamicCondition(DrivingClass.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).size();
            List classList = this.drivingClassService.getObjectsByIds(ids);
            model.addAttribute("code", (Object)0);
            model.addAttribute("total", (Object)total);
            model.addAttribute("drivingClassList", (Object)classList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/drivingClass/json/drivingClassListJson";
    }

    @RequestMapping(value={"/a/class/{id}"}, method={RequestMethod.GET})
    public String getDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get data : id= " + id));
        try {
            DrivingClass drivingClass = this.drivingClassService.getObjectById(id);
            log.info((Object)("get drivingClass data is " + drivingClass));
            if (DataUtils.isNullOrEmpty((Object)drivingClass)) {
                model.addAttribute("code", (Object)-21013);
                log.info((Object)"parameter classes is null or empty");
                return "/common/failure";
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("drivingClass", (Object)drivingClass);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get drivingClass error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/drivingClass/json/drivingClassDetailJson";
    }
}

