/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.pub.model.Content;
import com.ptteng.yi.pub.service.CitiesService;
import com.ptteng.yi.pub.service.ContentService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ContentController {
    private static final Log log = LogFactory.getLog(ContentController.class);
    @Autowired
    private ContentService contentService;
    @Autowired
    private CitiesService citiesService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @RequestMapping(value={"/a/content/{id}"}, method={RequestMethod.GET})
    public String getContentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("GET request url : /a/content/{id}, get path variable id : " + id));
        try {
            Content content = this.contentService.getObjectById(id);
            log.info((Object)("get content data is " + content));
            if (DataUtils.isNullOrEmpty((Object)content)) {
                log.info((Object)"no this content");
                model.addAttribute("code", (Object)-12000);
                return "/common/failure";
            }
            content.setReading(content.getReading() + 1);
            this.contentService.update(content);
            model.addAttribute("code", (Object)0);
            model.addAttribute("content", (Object)content);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get content error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-pub-service/content/json/contentDetailJson";
    }

    @RequestMapping(value={"/a/banner/list"}, method={RequestMethod.GET})
    public String getMultiBannerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long cityId) throws Exception {
        log.info((Object)("GET request url: /a/banner/list, get parameter cityId: " + cityId));
        if (DataUtils.isNullOrEmpty((Object)cityId)) {
            log.info((Object)"the parameter cityId is null or empty");
            model.addAttribute("code", (Object)-12001);
            return "/common/failure";
        }
        if (cityId < 1L) {
            log.info((Object)"parameter cityId is illegal");
            model.addAttribute("code", (Object)-13006);
            return "/common/failure";
        }
        try {
            List cityIds = this.citiesService.getCitiesIdsByCityid(cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            if (CollectionUtils.isEmpty((Collection)cityIds)) {
                log.info((Object)"there is no city in DB");
                model.addAttribute("code", (Object)-12003);
                return "/common/failure";
            }
            List bannerIds = this.contentService.getContentIdsByTypeAndStatusAndAppAndCityId(0, 1, 1, cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get banner id list : " + bannerIds));
            if (CollectionUtils.isEmpty((Collection)bannerIds)) {
                model.addAttribute("contentList", new ArrayList());
                model.addAttribute("total", (Object)0);
            } else {
                List bannerList = this.contentService.getObjectsByIds(bannerIds);
                log.info((Object)("get banner list size : " + bannerList.size()));
                model.addAttribute("total", (Object)bannerList.size());
                model.addAttribute("contentList", (Object)bannerList);
            }
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)"get banner list error");
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-pub-service/content/json/contentListJson";
    }

    @RequestMapping(value={"/a/news/list"}, method={RequestMethod.GET})
    public String getMultiNewsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long cityId, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("GET request url: /a/u/news/list, get parameter page : " + page + ", size : " + size + ", cityId: " + cityId));
        if (DataUtils.isNullOrEmpty((Object)cityId)) {
            log.info((Object)"the parameter cityId is null or empty");
            model.addAttribute("code", (Object)-12001);
            return "/common/failure";
        }
        if (cityId < 1L) {
            log.info((Object)"parameter cityId is illegal");
            model.addAttribute("code", (Object)-13006);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        log.info((Object)("pageList : page= " + start + " , size=" + size));
        try {
            List cityIds = this.citiesService.getCitiesIdsByCityid(cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            if (CollectionUtils.isEmpty((Collection)cityIds)) {
                log.info((Object)"there is no city in DB");
                model.addAttribute("code", (Object)-12003);
                return "/common/failure";
            }
            ArrayList<Integer> apps = new ArrayList<Integer>();
            apps.add(1);
            apps.add(2);
            Map map = DynamicUtil.getContentListParams((Integer)1, (Integer)1, apps, (Long)cityId, (Boolean)false);
            log.info((Object)("get query news list map : " + map));
            List newsIds = this.contentService.getIdsByDynamicCondition(Content.class, map, Integer.valueOf(start), size);
            log.info((Object)("get news id list : " + newsIds));
            Integer total = this.contentService.getIdsByDynamicCondition(Content.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).size();
            if (CollectionUtils.isEmpty((Collection)newsIds)) {
                model.addAttribute("contentList", new ArrayList());
            } else {
                List newsList = this.contentService.getObjectsByIds(newsIds);
                log.info((Object)("get newsList data size is " + newsList.size()));
                model.addAttribute("contentList", (Object)newsList);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)total);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get news list error, start is  " + start + " , size " + size));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-pub-service/content/json/contentListJson";
    }

    @RequestMapping(value={"/a/experience"}, method={RequestMethod.GET})
    public String getExperienceJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long cityId) throws Exception {
        log.info((Object)("GET request url : /a/experience, get parameter cityId: " + cityId));
        if (DataUtils.isNullOrEmpty((Object)cityId)) {
            log.info((Object)"the parameter cityId is null or empty");
            model.addAttribute("code", (Object)-12001);
            return "/common/failure";
        }
        if (cityId < 1L) {
            log.info((Object)"parameter cityId is illegal");
            model.addAttribute("code", (Object)-13006);
            return "/common/failure";
        }
        try {
            List cityIds = this.citiesService.getCitiesIdsByCityid(cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            if (CollectionUtils.isEmpty((Collection)cityIds)) {
                log.info((Object)"there is no city in DB");
                model.addAttribute("code", (Object)-12003);
                return "/common/failure";
            }
            List ids = this.contentService.getContentIdsByTypeAndStatusAndAppAndCityId(2, 1, 1, cityId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get experience id : " + ids));
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                Content content = this.contentService.getObjectById((Long)ids.get(0));
                log.info((Object)("get experience content data is " + content));
                model.addAttribute("content", (Object)content);
                Long time = content.getCountAt() + (long)(content.getCountdown() * 86400000);
                Long currentTime = System.currentTimeMillis();
                Long zero = time - currentTime;
                Integer remainingSec = zero.intValue();
                if (remainingSec < 0) {
                    remainingSec = 0;
                }
                model.addAttribute("remainingSec", (Object)remainingSec);
            }
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get experience content error");
            model.addAttribute("code", (Object)-100000);
        }
        return "yi-pub-service/content/json/experienceJson";
    }

    @RequestMapping(value={"/a/u/img/{module}"}, method={RequestMethod.POST})
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestParam MultipartFile file, @PathVariable String module) throws Exception {
        log.info((Object)("hello upload " + module));
        if (StringUtils.isBlank((CharSequence)module)) {
            module = "common";
        }
        boolean code = false;
        log.info((Object)file.getOriginalFilename());
        try {
            String url;
            String type = file.getContentType();
            long size = file.getSize();
            log.info((Object)("  size is =" + size / 0x100000L));
            String extend = FileUtil.getFileExtension((String)file.getOriginalFilename());
            String fileName = "";
            fileName = "apk".equals(extend) ? file.getOriginalFilename() : UUID.randomUUID().toString() + "." + extend;
            log.info((Object)("new name is " + fileName));
            log.info((Object)"--------------------------------------------");
            String filePath = "/data/webs/yi-admin-web/excel/" + fileName;
            log.info((Object)filePath);
            File tempPic = new File(filePath);
            if (tempPic.exists()) {
                log.info((Object)"temp file has exists, do not need to touch");
            } else {
                log.info((Object)"temp file not exists");
                tempPic.createNewFile();
            }
            String tempFileStr = fileName;
            log.info((Object)"--------------------------------------------");
            file.transferTo(tempPic);
            log.info((Object)"--------------------------------------------");
            boolean flag = false;
            if (flag) {
                url = request.getScheme() + "://" + request.getServerName();
                log.info((Object)("url is " + url));
                log.info((Object)"excel file need to parse, temporarily not to delete");
                url = request.getScheme() + "://" + request.getServerName() + "/exceldownload/" + tempFileStr;
            } else {
                url = this.imgStorageUtil.imgStorage(null, module + "/" + fileName, filePath);
                log.info((Object)(module + module + "/" + fileName + filePath));
                log.info((Object)"--------------------------------------------");
                log.info((Object)url);
                log.info((Object)(module + " upload success ,and file name is " + fileName + "temp path is " + filePath + " access url is " + url));
                tempPic.delete();
                log.info((Object)(file.getOriginalFilename() + " delete success !"));
            }
            model.addAttribute("url", (Object)url);
            model.addAttribute("code", (Object)0);
            return "/common/img";
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            return "/common/success";
        }
    }
}

