/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ListUtil;
import com.ptteng.yi.nucleus.model.Card;
import com.ptteng.yi.nucleus.model.CardType;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.CardService;
import com.ptteng.yi.nucleus.service.CardTypeService;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.nucleus.service.SchoolService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CardController {
    private static final Log log = LogFactory.getLog(CardController.class);
    @Autowired
    private CardService cardService;
    @Autowired
    private CardTypeService cardTypeService;
    @Autowired
    private DrivingClassService drivingClassService;
    @Autowired
    private SchoolService schoolService;

    @RequestMapping(value={"/a/u/card/list"}, method={RequestMethod.GET})
    public String getCardJson(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        log.info((Object)"GET request url : /a/u/card/list, no parameter");
        Students student = (Students)request.getAttribute("user");
        Long sid = student.getId();
        log.info((Object)("get student id : " + sid));
        try {
            List cardIds = this.cardService.getCardIdsByOwnerIdAndStatus(sid, Integer.valueOf(4), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get student card id list : " + cardIds));
            if (CollectionUtils.isEmpty((Collection)cardIds)) {
                model.addAttribute("cardList", new ArrayList());
                model.addAttribute("total", (Object)0);
            } else {
                List cardList = this.cardService.getObjectsByIds(cardIds);
                log.info((Object)("get student card list size : " + cardList.size()));
                List tids = MyListUtil.getFieldValueListFromModelList((List)cardList, (boolean)false, (Field)Card.class.getDeclaredField("tid"));
                List cardTypeList = this.cardTypeService.getObjectsByIds(tids);
                List titleList = MyListUtil.getFieldValueListFromModelList((List)cardTypeList, (boolean)false, (Field)CardType.class.getDeclaredField("title"));
                Map cidTitle = ListUtil.convert2Map((List)cardIds, (List)titleList);
                List descriptionList = MyListUtil.getFieldValueListFromModelList((List)cardTypeList, (boolean)false, (Field)CardType.class.getDeclaredField("description"));
                Map cidDescription = ListUtil.convert2Map((List)cardIds, (List)descriptionList);
                List valueList = MyListUtil.getFieldValueListFromModelList((List)cardTypeList, (boolean)false, (Field)CardType.class.getDeclaredField("value"));
                Map cidValue = ListUtil.convert2Map((List)cardIds, (List)valueList);
                ArrayList<Long> allSchoolIds = new ArrayList<Long>();
                ArrayList<Long> allClassIds = new ArrayList<Long>();
                HashMap cidSchlIdLIST = new HashMap();
                HashMap cidClassIdList = new HashMap();
                for (int i = 0; i < cardList.size(); ++i) {
                    Card card = (Card)cardList.get(i);
                    String school = card.getSchools();
                    log.info((Object)("String school : " + school));
                    String clas = card.getClasses();
                    log.info((Object)("String class : " + clas));
                    String[] schools = school.substring(1, school.length() - 1).split(",");
                    String[] classes = clas.substring(1, clas.length() - 1).split(",");
                    ArrayList<Long> schoolsIds = new ArrayList<Long>();
                    ArrayList<Long> classesIds = new ArrayList<Long>();
                    for (int j = 0; j < schools.length; ++j) {
                        schoolsIds.add(Long.parseLong(schools[j]));
                        if (allSchoolIds.indexOf(Long.parseLong(schools[j])) != -1) continue;
                        allSchoolIds.add(Long.parseLong(schools[j]));
                    }
                    for (int k = 0; k < classes.length; ++k) {
                        classesIds.add(Long.parseLong(classes[k]));
                        if (allClassIds.indexOf(Long.parseLong(classes[k])) != -1) continue;
                        allClassIds.add(Long.parseLong(classes[k]));
                    }
                    cidSchlIdLIST.put(card.getId(), schoolsIds);
                    cidClassIdList.put(card.getId(), classesIds);
                }
                List allSchoolList = this.schoolService.getObjectsByIds(allSchoolIds);
                List allClassList = this.drivingClassService.getObjectsByIds(allClassIds);
                HashMap cidScholList = new HashMap();
                HashMap cidDrivingClassList = new HashMap();
                for (int m = 0; m < cardList.size(); ++m) {
                    ArrayList<School> schoolList = new ArrayList<School>();
                    ArrayList<DrivingClass> classList = new ArrayList<DrivingClass>();
                    Card card1 = (Card)cardList.get(m);
                    List schoolIds = (List)cidSchlIdLIST.get(card1.getId());
                    for (int n = 0; n < allSchoolList.size(); ++n) {
                        School school = (School)allSchoolList.get(n);
                        if (schoolIds.indexOf(school.getId()) == -1) continue;
                        schoolList.add(school);
                    }
                    cidScholList.put(card1.getId(), schoolList);
                    List classIds = (List)cidClassIdList.get(card1.getId());
                    for (int q = 0; q < allClassList.size(); ++q) {
                        DrivingClass cla = (DrivingClass)allClassList.get(q);
                        if (classIds.indexOf(cla.getId()) == -1) continue;
                        classList.add(cla);
                    }
                    cidDrivingClassList.put(card1.getId(), classList);
                }
                model.addAttribute("total", (Object)cardList.size());
                model.addAttribute("cardList", (Object)cardList);
                model.addAttribute("cidTitle", (Object)cidTitle);
                model.addAttribute("cidDescription", (Object)cidDescription);
                model.addAttribute("cidValue", (Object)cidValue);
                model.addAttribute("cidScholList", cidScholList);
                model.addAttribute("cidDrivingClassList", cidDrivingClassList);
            }
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get student's card error, id is  " + sid));
            model.addAttribute("code", (Object)-100000);
        }
        return "/yi-nucleus-service/card/json/cardListJson";
    }

    @RequestMapping(value={"/a/u/card"}, method={RequestMethod.POST})
    public String exchangeCardJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd) throws Exception {
        log.info((Object)("GET request url : /a/u/card, get parameter pwd : " + pwd));
        if (StringUtils.isEmpty((CharSequence)pwd)) {
            log.info((Object)"parameter pwd is null or empty");
            model.addAttribute("code", (Object)-11001);
            return "/common/failure";
        }
        Students student = (Students)request.getAttribute("user");
        Long sid = student.getId();
        log.info((Object)("get student id : " + sid));
        try {
            Map map = DynamicUtil.getCardListParams((String)pwd, (Integer)1, (Long)System.currentTimeMillis(), (Boolean)false);
            log.info((Object)("query card map : " + map));
            List cardIds = this.cardService.getIdsByDynamicCondition(Card.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)cardIds);
            if (CollectionUtils.isEmpty((Collection)cardIds)) {
                log.info((Object)"no this card");
                model.addAttribute("code", (Object)-11000);
                return "/common/failure";
            }
            Card card = this.cardService.getObjectById((Long)cardIds.get(0));
            log.info((Object)("get card data is :" + card));
            card.setStatus(Integer.valueOf(4));
            card.setExchangeAt(Long.valueOf(System.currentTimeMillis()));
            card.setOwnerId(sid);
            card.setOwnerMobile(student.getMobile());
            if (!StringUtils.isEmpty((CharSequence)student.getName())) {
                card.setOwnerName(student.getName());
            } else {
                card.setOwnerName("");
            }
            boolean result_1 = this.cardService.update(card);
            Long cardTypeId = card.getTid();
            CardType cardType = this.cardTypeService.getObjectById(cardTypeId);
            cardType.setExchangedAmount(Integer.valueOf(cardType.getExchangedAmount() + 1));
            boolean result_2 = this.cardTypeService.update(cardType);
            model.addAttribute("code", (Object)0);
            log.info((Object)("update card result: " + result_1));
            log.info((Object)("update cardType result: " + result_2));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get card error, student id is  " + sid));
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/success";
    }
}

