package com.ptteng.util;

import java.util.ArrayList;
import java.util.List;

/**
 * @author himly
 */
public class ParametersUtil {

    /**
     * 所有参数均为null
     * @param objects
     * @return
     */
    public static boolean allParametersIsNull(Object... objects) {

        for (Object o : objects) {
            if (o != null) {
                return false;
            }
        }

        return true;
    }

    /**
     * 所有参数均不为null
     * @param objects
     * @return
     */
    public static boolean allParametersIsNotNull(Object... objects) {

        for (Object o : objects) {
            if (o == null) {
                return false;
            }
        }

        return true;
    }

    //分割
    public static List<Long> splitArrayList(List list, int start, int end) {
        List<Long> newList = new ArrayList<>();
        int length = list.size();

        end = length >= end ? end : length;

        for (int i = 0; i < end; ++i) {
            if (i >= start) {
                newList.add((Long) list.get(i));
            }
        }

        return newList;
    }

    public static boolean allParametersIsNotEmpty(String... strings) {

        for (String st : strings) {
            if (st == null || st.equals("")) {
                return false;
            }
        }

        return true;
    }

    public static boolean hasOneParameterIsNotNullAndEmpty(String... strings) {

        for (String st : strings) {
            if (st != null && !st.equals(""))
                return true;
        }

        return false;
    }
}
