package com.ptteng.model;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 *  考点和标志统计类
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
public class SignsNumber {

    /**
     *  类型,考点, 交通标志, 车内标志
     * */
    private Integer type;
    /**
     *  标志类型的具体类型
     * */
    private String signType;
    /**
     *  总数
     * */
    private Integer total;

    private String signTypeUrl;

    public SignsNumber(Integer type, String singType, Integer total, String signTypeUrl) {
        this.type = type;
        this.signType = singType;
        this.total = total;
        this.signTypeUrl = signTypeUrl;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public String getSignTypeUrl() {
        return signTypeUrl;
    }

    public void setSignTypeUrl(String typeUrl) {
        this.signTypeUrl = signTypeUrl;
    }

    /**
     *  将Map转换为List
     * */
    public static List<SignsNumber> convertMapToSignsNumberList(Map<String, Integer> map, Integer type,
            List<SignsNumber> list, Map<String, String> signTypeUrlMap) {
        List<SignsNumber> resultList = list;

        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry) iterator.next();
            SignsNumber signsNumber = new SignsNumber(type, (String) entry.getKey(), (Integer) entry.getValue(),
                    signTypeUrlMap.get(entry.getKey()));
            resultList.add(signsNumber);
        }

        return resultList;
    }
}
