package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.SchoolClassRelation;
import com.ptteng.yi.nucleus.model.SchoolVenuesRelation;
import com.ptteng.yi.nucleus.model.TrainingVenues;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.ptteng.yi.nucleus.service.SchoolVenuesRelationService;
import com.ptteng.yi.nucleus.service.TrainingVenuesService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * TrainingVenues  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TrainingVenuesController {
	private static final Log log = LogFactory.getLog(TrainingVenuesController.class);

	@Autowired
	private TrainingVenuesService trainingVenuesService;

	@Autowired
	private SchoolVenuesRelationService schoolVenuesRelationService;

	@Autowired
	private SchoolClassRelationService schoolClassRelationService;

	@Autowired
	private CookieUtil cookieUtil;

	/**
	 *训练场列表
	 * @param request
	 * @param response
	 * @param model
	 * @param cityId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/venues/list", method = RequestMethod.GET)
	public String getTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,Integer page, Integer size,Long classId,
			Long cityId) throws Exception {

		log.info("/a/u/exam/student/list param is " + "  cityId ===== " + cityId + ", classId ==" + classId
				+ ", page == " + page + " , size == " + size);

//		if (page == null) {
//			page = 1;
//		}
//		if (size == null) {
//			size = 10;
//		}
//		int start = (page - 1) * size;
//		if (start < 0) {
//			start = 0;
//		}

		if (DataUtils.isNullOrEmpty(cityId)) {
			model.addAttribute("code", -21014);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(classId)) {
			model.addAttribute("code", -21015);
			log.info("classId is null or empty");
			return "/common/failure";
		}
		try {

			//通过班型获取驾校ID,班型是运营中心通用,而不同运营中心不通用么?
			Map<String, Object> map = DynamicUtil.classIdgetSchoolList(classId);
			log.info("map is "+map);
			List<Long> ids=schoolClassRelationService.getIdsByDynamicCondition(SchoolClassRelation.class,map,0,Integer.MAX_VALUE);
			log.info("ids is "+ids);
			List<SchoolClassRelation> schoolClassRelationList=schoolClassRelationService.getObjectsByIds(ids);

			List<String> schoolIds=new ArrayList<>();
			for (int i=0;i<ids.size();i++){
				schoolIds.add(schoolClassRelationList.get(i).getSchoolId().toString());
			}
			log.info("schoolIds is "+schoolIds);
			List<TrainingVenues> trainingVenuesList=new ArrayList<>();
			if(CollectionUtils.isNotEmpty(schoolIds)){
				Map<String,Object> schoolVenuesRelationMap=DynamicUtil.schoolIdgetVenuesList(schoolIds);
				log.info("schoolVenuesRelationMap is "+schoolVenuesRelationMap);
				List<Long> schoolVenuesRelationIds=schoolVenuesRelationService.getIdsByDynamicCondition(SchoolVenuesRelation.class,schoolVenuesRelationMap,
						0,Integer.MAX_VALUE);
				log.info("schoolVenuesRelationIds is "+schoolVenuesRelationIds);
				List<SchoolVenuesRelation> schoolVenuesRelationList=schoolVenuesRelationService.getObjectsByIds(schoolVenuesRelationIds);

				List<Long> venuesIds=new ArrayList<>();
				for (int i=0;i<schoolVenuesRelationList.size();i++){
					log.info("venuesIds.contains(schoolVenuesRelationList.get(i).getVenueId() "+venuesIds.contains(schoolVenuesRelationList.get(i).getVenueId()));
					if(!venuesIds.contains(schoolVenuesRelationList.get(i).getVenueId())){
						venuesIds.add(schoolVenuesRelationList.get(i).getVenueId());
					}
				}
				log.info("venuesIds is "+venuesIds);
				trainingVenuesList = trainingVenuesService.getObjectsByIds(venuesIds);
			}


			model.addAttribute("code", 0);
			model.addAttribute("trainingVenuesList", trainingVenuesList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/trainingVenues/json/trainingVenuesListJson";
	}

}
