package com.ptteng.model;

import com.ptteng.controller.SubjectPracticeController;

import java.util.ArrayList;
import java.util.List;

/**
 *  学员对应题目的信息类
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
public class StudentPracticeKey {
    /**
     * 题目Id
     * */
    private Long practiceId;
    /**
     *  题目状态,未做,做错,做对
     * */
    private Integer status;
    /**
     *  该题目是否为收藏, 是, 不是
     * */
    private Integer isFavorite;

    /**
     *  状态: 该题未做
     * */
    private static final int NOT_DONE = 0;

    /**
     *  状态: 已做且做对
     * */
    private static final int RIGHT = 1;

    /**
     *  状态: 已做且做错
     * */
    private static final int WRONG = 2;

    /**
     *  是否收藏: 已经收藏
     * */
    private static final int HAS_FAVORITE = 1;

    /**
     *  是否收藏: 未收藏
     * */
    private static final int NOT_FAVORITE = 0;

    public Long getPracticeId() {
        return practiceId;
    }

    public void setPracticeId(Long practiceId) {
        this.practiceId = practiceId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getIsFavorite() {
        return isFavorite;
    }

    public void setIsFavorite(Integer isFavorite) {
        this.isFavorite = isFavorite;
    }

    @Override
    public String toString() {
        return "StudentPracticeKey{" + "practiceId=" + practiceId + ", status=" + status + ", isFavorite=" + isFavorite
                + '}';
    }

    /**
     *  根据题目IdList生成StudentPracticeKey对象List
     * */
    public static List<StudentPracticeKey> generateStudentPracticeKeyList(List<Long> practiceIds,
            List<Long> rightPracticeIds, List<Long> wrongPracticeIds, List<Long> favoritePracticeIds, Integer type) {
        List<StudentPracticeKey> resultList = new ArrayList<>(practiceIds.size());
        for (int i = 0; i < practiceIds.size(); i++) {
            StudentPracticeKey studentPracticeKey = new StudentPracticeKey();

            studentPracticeKey.setPracticeId(practiceIds.get(i));
            if ((type != SubjectPracticeController.PRACTICE_NOT_DONE)
                    && (type != SubjectPracticeController.PRACTICE_MOCK)) {
                int status = getPracticeStatus(practiceIds.get(i), rightPracticeIds, wrongPracticeIds);
                studentPracticeKey.setStatus(status);
            }

            if (favoritePracticeIds.contains(practiceIds.get(i))) {
                studentPracticeKey.setIsFavorite(HAS_FAVORITE);
            } else {
                studentPracticeKey.setIsFavorite(NOT_FAVORITE);
            }

            resultList.add(studentPracticeKey);
        }

        return resultList;
    }

    /**
     * 根据题目Id获取对应状态
     *
     * */
    private static int getPracticeStatus(Long practiceId, List<Long> rightPracticeIds, List<Long> wrongPracticeIds) {
        if (wrongPracticeIds.contains(practiceId)) {
            return WRONG;
        } else if (rightPracticeIds.contains(practiceId)) {
            return RIGHT;
        } else {
            return NOT_DONE;
        }
    }
}
