package com.ptteng.util;

import com.ptteng.controller.SubjectPracticeController;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ParamsUtil {
    private static final Log log = LogFactory.getLog(ParamsUtil.class);

    public static final Integer VALIDATE_RESULT_SUCCESS = 0;

    /**
     * 根据入参size计算实际获取数据的个数
     */
    public static Integer calculateActualSize(Integer size) {
        Integer result = size;

        if (result == null || result <= 0) {
            result = 10;
        }
        return result;
    }

    /**
     * 计算根据传入的page和实际的size计算分页的起始页
     */
    public static int calculateStartPosition(Integer page, Integer size) {
        if (page == null || page <= 0) {
            page = 1;
        }
        int start = (page - 1) * calculateActualSize(size);
        if (start < 0) {
            start = 0;
        }

        return start;
    }

    /**
     * 判断传入的参数是否为空
     */
    public static int isNullOrEmpty(Object... params) {
        for (int i = 0; i < params.length; i++) {
            if (DataUtils.isNullOrEmpty(params[i])) {
                return i;
            }
        }
        return -1;
    }

    /**
     * 校验 获取顺序/未做题目/错题/收藏题目练习列表接口 的参数
     */
    public static int checkParamsOfGetPortionOfPractices(Long studentId, Long practiceId, Integer subjectType,
            Integer type, Integer mode) {

        String[] paramNames = new String[] { "schoolId", "practiceId", "subjectType", "type", "mode" };
        int result = isNullOrEmpty(studentId, practiceId, subjectType, type, mode);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }
        if (studentId <= 0) {
            log.info("Parameter studentId can not be less than 0, studentId is " + studentId);
            return -1001;
        }
        if (practiceId < 0) {
            log.info("Parameter practiceId can not be less than 0, practiceId is " + practiceId);
            return -1001;
        }
        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType is " + subjectType);
            return -1001;
        }
        if (type < 0 || type > 3) {
            log.info("Error value of parameter type, type is " + type);
            return -1001;
        }
        if (mode != 0 && mode != 1) {
            log.info("Error value of parameter mode, mode is " + mode);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验 getPracticeIdList 的参数
     */
    public static int checkParamsOfGetPracticeIdList(Long studentId, Integer subjectType, Integer type,
            String special) {

        String[] paramNames = new String[] { "studentId", "subjectType", "type" };
        int result = isNullOrEmpty(studentId, subjectType, type);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType : " + subjectType);
            return -1001;
        }
        if (type < 0 || type > 6) {
            log.info("Error value of parameter type, type : " + type);
            return -1001;
        }
        if (type == SubjectPracticeController.PRACTICE_SPECIAL && StringUtils.isBlank(special)) {
            log.info("Parameter special can not be null when type=6");
            return -1001;
        }

        return 0;
    }

    /**
     * 校验 getPracticesByIdList 的参数
     */
    public static int checkParamsOfGetPracticesByIdList(Long[] idArray, Integer subjectType) {
        if (DataUtils.isNullOrEmpty(subjectType)) {
            log.info("Parameter subjectType can not be null");
            return -1000;
        }

        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType : " + subjectType);
            return -1001;
        }

        if ((idArray == null) || (idArray.length == 0)) {
            log.info("Parameter subjectType can not be null");
            return -1000;
        }
        return 0;
    }

    /**
     * 校验 recordPracticeResult 的参数
     */
    public static int checkParamsOfRecordPracticeResult(Long studentId, Long practiceId, Integer subjectType,
            Integer result, Integer isRemoved) {
        String[] paramNames = new String[] { "studentId", "practiceId", "subjectType", "result", "isRemoved" };
        int validate = isNullOrEmpty(studentId, practiceId, subjectType, result, isRemoved);
        if (validate >= 0) {
            log.info("Parameter " + paramNames[validate] + " can not be null");
            return -1000;
        }

        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType : " + subjectType);
            return -1001;
        }

        if (result != 0 && result != 1) {
            log.info("Error value of parameter result, result : " + result);
            return -1001;
        }

        if (isRemoved != 0 && isRemoved != 1) {
            log.info("Error value of parameter isRemoved, isRemoved : " + isRemoved);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验 getPracticeRecord 的参数
     */
    public static int checkParamsOfStudentIdAndSubjectType(Long studentId, Integer subjectType) {
        String[] paramNames = new String[] { "studentId", "subjectType" };
        int validate = isNullOrEmpty(studentId, subjectType);
        if (validate >= 0) {
            log.info("Parameter " + paramNames[validate] + " can not be null");
            return -1000;
        }

        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType : " + subjectType);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验 recordMockExamResult 的参数
     */
    public static int checkParamsOfRecordMockExamResult(Long studentId, Long time, Integer rights, Integer wrong,
            Integer subjectType) {
        String[] paramNames = new String[] { "studentId", "time", "rights", "wrong", "subjectType" };
        int validateResult = isNullOrEmpty(studentId, time, rights, wrong, subjectType);
        if (validateResult >= 0) {
            log.info("Parameter " + paramNames[validateResult] + " can not be null");
            return -1000;
        }

        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType : " + subjectType);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验 recordFavorite 的参数
     */
    public static int checkParamsOfRecordFavorite(Long studentId, Long targetId, Integer targetType) {
        String[] paramNames = new String[] { "studentId", "targetId", "targetType" };
        int validateResult = isNullOrEmpty(studentId, targetId, targetType);
        if (validateResult >= 0) {
            log.info("Parameter " + paramNames[validateResult] + " can not be null");
            return -1000;
        }

        if (targetType < 1 || targetType > 4) {
            log.info("Error value of parameter targetType, targetType : " + targetType);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验 getSignsList 的参数
     */
    public static int checkParamsOfGetSignsList(Integer type, String signType) {
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("Parameter type can not be null");
            return -1000;
        }

        if (type < 0 || type > 2) {
            log.info("Error value of parameter type, type is : " + type);
            return -1000;
        }

        if ((type != 0) && DataUtils.isNullOrEmpty(signType)) {
            log.info("signType can not be null when type!=0");
            return -1001;
        }

        return 0;
    }

    /**
     * 校验 getExaminationPoint 的参数
     */
    public static int checkParamsOfGetExaminationPoint(Long id, String title, Integer subjectType) {
        if (DataUtils.isNullOrEmpty(id) && DataUtils.isNullOrEmpty(title)) {
            log.info("Parameter id and title can not be null at the same time");
            return -1001;
        }

        if (DataUtils.isNotNullOrEmpty(id) && DataUtils.isNotNullOrEmpty(title)) {
            log.info("Parameter id and title can not have value at the same time");
            return -1001;
        }

        if (DataUtils.isNullOrEmpty(subjectType)) {
            log.info("Parameter subjectType can not be null");
            return -1000;
        }

        if (subjectType != 1 && subjectType != 4) {
            log.info("Error value of parameter subjectType, subjectType : " + subjectType);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验 removeFavorite 的参数
     */
    public static int checkParamsOfRemoveFavorite(Long studentId, Long targetId) {
        String[] paramNames = new String[] { "studentId", "targetId", };
        int validateResult = isNullOrEmpty(studentId, targetId);
        if (validateResult >= 0) {
            log.info("Parameter " + paramNames[validateResult] + " can not be null");
            return -1000;
        }

        return 0;
    }

    /**
     * 校验查看消息列表接口的参数
     */
    public static int checkParamsOfGetUserMessageList(Integer messageType, Integer targetReceive, Integer page,
            Integer size) {

        if (ParamsUtil.isNullOrEmpty(messageType, targetReceive) != -1) {
            log.info("one of parameters is null");
            return -1000;
        }

        if (messageType != 1 && messageType != 2) {
            log.info("Error value of parameter messageType, messageType : " + messageType);
            return -1001;
        }

        if (targetReceive != 1 && targetReceive != 2) {
            log.info("Error value of parameter targetReceive, targetReceive : " + targetReceive);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验查看消息列表接口的参数
     */
    public static int checkParamsOfUpdateUserMessagesStatus(Integer messageType, Integer targetReceive) {

        if (ParamsUtil.isNullOrEmpty(messageType, targetReceive) != -1) {
            log.info("one of parameters is null");
            return -1000;
        }

        if (messageType != 1 && messageType != 2) {
            log.info("Error value of parameter messageType, messageType : " + messageType);
            return -1001;
        }

        if (targetReceive != 1 && targetReceive != 2) {
            log.info("Error value of parameter targetReceive, targetReceive : " + targetReceive);
            return -1001;
        }
        return 0;
    }
}
