package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.util.Calculation;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.TimeUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.MyMathUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.apache.commons.collections.CollectionUtils;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigDecimal;

/**
 * Created by wutao on 2018/1/25.
 */
@Controller
public class practiceCarController {
    private static final Log log = LogFactory.getLog(TrainingVenuesController.class);

    @Autowired
    private CoachService coachService;
    @Autowired
    private StudentsService studentsService;
    @Autowired
    private CoachAppointTimeService coachAppointTimeService;
    @Autowired
    private AdvanceTimeService advanceTimeService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private CoachClassRelationService coachClassRelationService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private AppointOrderService appointOrderService;
    @Autowired
    private CoachFreeService coachFreeService;

    /**
     * 搜索教练
     * @param request
     * @param response
     * @param model
     * @param mobile
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/search", method = RequestMethod.GET)
    public String getCoachList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
            Integer page, Integer size) throws Exception {
        log.info("mobile is " + mobile + " page is " + page + " size is " + size);
        if (DataUtils.isNullOrEmpty(mobile)) {
            log.info("mobile is null");
            model.addAttribute("code", -5022);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Students students = (Students) request.getAttribute("user");
        log.info("students is "+students);
        Integer certification = students.getCertification();
        if (certification.equals(Coach.CERTIFICATION_ON)) {
            log.info("students is Certification_ON");
            model.addAttribute("code", -22000);
            return "/common/failure";
        }
        try {
            Map<String, Object> map = DynamicUtil.getCoachList(mobile, null, students.getCityId(),
                    Coach.CERTIFICATION_OFF);
            log.info("map is "+map);
            List<Long> ids = coachService.getIdsByDynamicCondition(Coach.class, map, start, size);
            log.info("ids is "+ids);
            List<Coach> coachList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(ids)){
                coachList = coachService.getObjectsByIds(ids);
            }
            log.info("coachList.size is "+coachList.size());
            Integer total = coachService.getIdsByDynamicCondition(Coach.class, map, 0, Integer.MAX_VALUE).size();

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("coachList", coachList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachListJson";
    }

    /**
     * 班型id搜索教练
     * @param request
     * @param response
     * @param model
     * @param classId
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/class/search", method = RequestMethod.GET)
    public String getCoachList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long classId,
            Integer page, Integer size) throws Exception {
        log.info("classId is " + classId);
        if (DataUtils.isNullOrEmpty(classId)) {
            log.info("mobile is null");
            model.addAttribute("code", -22006);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        try {
            List<Long> ids = coachClassRelationService.getCoachClassRelationIdsByClassId(classId, start, size);
            log.info("ids is "+ids);
            Integer total = coachClassRelationService.getCoachClassRelationIdsByClassId(classId, 0, Integer.MAX_VALUE)
                    .size();
            List<CoachClassRelation> coachClassRelationList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(ids)){
                coachClassRelationList = coachClassRelationService.getObjectsByIds(ids);
            }
            List<Coach> coachList = new ArrayList<>();
            List<Long> coachIds= MyListUtil.getDistinctList(CoachClassRelation.class.getDeclaredField("coachId"),coachClassRelationList);
            coachList=coachService.getObjectsByIds(coachIds);


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("coachList", coachList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachListJson";
    }

    /**
     *关注教练
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/attention/{id}", method = RequestMethod.POST)
    public String attentionCoach(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer subject) throws Exception {
        log.info("id is " + id + " type is " + subject);
        Students students = (Students) request.getAttribute("user");
        log.info("students is " + students);


        try {
            Coach coach = coachService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(coach)){
                log.info("coach  is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            Integer certification = coach.getCertification();
            if (certification.equals(Coach.CERTIFICATION_ON)) {
                log.info("coach  is Certification_ON");
                model.addAttribute("code", -22003);
                return "/common/failure";
            }
            if (subject.equals(AdvanceTime.TWO_SUBJECT)
                    && DataUtils.isNotNullOrEmpty(students.getSectionTwoCoachId())) {
                students.setSectionTwoCoach(null);
                students.setSectionTwoCoachId(null);
            } else if (subject.equals(AdvanceTime.TWO_SUBJECT)
                    && DataUtils.isNullOrEmpty(students.getSectionTwoCoachId())) {
                if (DataUtils.isNullOrEmpty(coach.getName())) {
                    students.setSectionTwoCoach(coach.getNick());
                } else {
                    students.setSectionTwoCoach(coach.getName());
                }
                students.setSectionTwoCoachId(coach.getId().toString());
            }
            if (subject.equals(AdvanceTime.THREE_SUBJECT)
                    && DataUtils.isNotNullOrEmpty(students.getSectionThreeCoachId())) {
                students.setSectionThreeCoach(null);
                students.setSectionThreeCoachId(null);
            } else if (subject.equals(AdvanceTime.THREE_SUBJECT)
                    && DataUtils.isNullOrEmpty(students.getSectionThreeCoachId())) {
                if (DataUtils.isNullOrEmpty(coach.getName())) {
                    students.setSectionThreeCoach(coach.getNick());
                } else {
                    students.setSectionThreeCoach(coach.getName());
                }
                students.setSectionThreeCoachId(coach.getId().toString());
            }

            studentsService.update(students);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 搜索教练约车时段
     * @param request
     * @param response
     * @param model
     * @param subject
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/arrange/{id}", method = RequestMethod.GET)
    public String getCoachArrange(HttpServletRequest request, HttpServletResponse response, ModelMap model, int subject,
            int type, Long time,@PathVariable Long id) throws Exception {
        log.info("type is " + type + " subject is " + subject);
        if (DataUtils.isNullOrEmpty(subject)) {
            log.info("subject is null");
            model.addAttribute("code", -22005);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -22004);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(time)) {
            log.info("time is null");
            model.addAttribute("code", -22011);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("id is null");
            model.addAttribute("code", -22007);
            return "/common/failure";
        }

        try {
            Long coachId=id;
            log.info("coachId is " + coachId);
            Coach coach = coachService.getObjectById(coachId);
            if (DataUtils.isNullOrEmpty(coach)) {
                log.info("coach is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            log.info("coach is "+coach);
            Integer subjectId = subject;
            List<Long> coachAppointTimeIds = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndTypeAndCoachId(
                    CoachAppointTime.COACHADVANCETIME_STATUS_NO, type, coachId, 0, Integer.MAX_VALUE);
            log.info("coachAppointTimeIds is "+coachAppointTimeIds);
            List<AdvanceTime> timeList = new ArrayList<>();
            List<AdvanceTime> advanceTimeList = new ArrayList<>();
            CoachAppointTime coachAppointTime = new CoachAppointTime();
            if (CollectionUtils.isEmpty(coachAppointTimeIds)) {
                List<Long> ids = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndCityIdAndType(
                        CoachAppointTime.COACHADVANCETIME_STATUS_YES, coach.getCityId(), type, 0, Integer.MAX_VALUE);
                log.info("ids is "+ids);
                List<CoachAppointTime> coachAppointTimeList=new ArrayList<>();
                if(CollectionUtils.isNotEmpty(ids)){
                    coachAppointTimeList = coachAppointTimeService.getObjectsByIds(ids);
                }
                if (CollectionUtils.isNotEmpty(ids)) {
                    coachAppointTime = coachAppointTimeList.get(0);
                    log.info("coachAppointTime is "+coachAppointTime);
                    Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
                            AdvanceTime.ADVANCE_TIME_STATUS_ON);
                    log.info("map is "+map);
                    List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
                            Integer.MAX_VALUE);
                    log.info("advanceTimeIds is "+advanceTimeIds);
                    if(CollectionUtils.isNotEmpty(advanceTimeIds)){
                        advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
                    }
                }
            } else {
                List<CoachAppointTime> coachAppointTimeList = coachAppointTimeService
                        .getObjectsByIds(coachAppointTimeIds);
                coachAppointTime = coachAppointTimeList.get(0);
                log.info("coachAppointTime is "+coachAppointTime);
                Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
                        AdvanceTime.ADVANCE_TIME_STATUS_ON);
                log.info("map is "+map);
                List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
                        Integer.MAX_VALUE);
                log.info("advanceTimeIds is "+advanceTimeIds);
                if(CollectionUtils.isNotEmpty(advanceTimeIds)){
                    advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
                }
            }

            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);

            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, time, null,
                    null, coachId, null, subjectId, null, null, null, null);
            log.info("map is "+map);
            List<Long> appointOrderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            List<AppointOrder> appointOrderList=new ArrayList<>();
            log.info("appointOrderIds is "+appointOrderIds);
            if(CollectionUtils.isNotEmpty(appointOrderIds)){
                appointOrderList=appointOrderService.getObjectsByIds(appointOrderIds);
            }
            for (int i = 0; i < advanceTimeList.size(); i++) {
                AdvanceTime advanceTime = advanceTimeList.get(i);
                log.info("advanceTime is "+advanceTime);
                int num=0;
                for(int a =0;a<appointOrderList.size();a++){
                    if(advanceTime.getStartTime().equals(appointOrderList.get(a).getTimeStart())&&advanceTime.getEndTime().equals(appointOrderList.get(a).getTimeEnd())){
                        num++;
                    }
                }
                log.info("length is   " + appointOrderIds.size());
                advanceTime.setArrangeNum(Long.valueOf(num));
                if (subjectId.equals(advanceTime.getSubject())) {
                    timeList.add(advanceTime);
                    log.info("advanceTime =========" + advanceTime);
                }
            }
            String advanceTime = null;
            Integer appointFrequency = null;
            Integer rest = null;
            if (subjectId.equals(AdvanceTime.TWO_SUBJECT)) {
                advanceTime = coachAppointTime.getTwoAdvanceTime();
                appointFrequency = coachAppointTime.getTwoAppointFrequency();
            }
            if (subjectId.equals(AdvanceTime.THREE_SUBJECT)) {
                advanceTime = coachAppointTime.getThreeAdvanceTime();
                appointFrequency = coachAppointTime.getThreeAppointFrequency();
            }
            Map<String, Object> coachFreeMap = DynamicUtil.getCoachFreeList(coachId, time);
            log.info("coachFreeMap is "+coachFreeMap);
            List<Long> ids = coachFreeService.getIdsByDynamicCondition(CoachFree.class, coachFreeMap, 0, Integer.MAX_VALUE);
            log.info("ids is "+ids);
            if (CollectionUtils.isEmpty(ids)) {
                rest = coachAppointTime.getTwoRest();
            } else {
                List<CoachFree> coachFreeList = coachFreeService.getObjectsByIds(ids);
                CoachFree coachFree = coachFreeList.get(0);
                rest = coachFree.getStatus();
            }

            log.info("timeList is " + timeList);
            log.info("advanceTime is " + advanceTime);
            log.info("appointFrequency is " + appointFrequency);
            log.info("rest is " + rest);

            model.addAttribute("code", 0);
            model.addAttribute("timeList", timeList);
            model.addAttribute("advanceTime", advanceTime);
            model.addAttribute("appointFrequency", appointFrequency);
            model.addAttribute("rest", rest);
            model.addAttribute("coachAppointTime", coachAppointTime);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachArrangeDetailJson";
    }

    /**
     * 获取教练详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/{id}", method = RequestMethod.GET)
    public String getCoach(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {
        log.info(" id is " + id);
        try {
            Coach coach = coachService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(coach)) {
                log.info("coach is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            model.addAttribute("code", 0);
            model.addAttribute("coach", coach);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachDetailJson";
    }

    /**
     * 获取常量
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/constant", method = RequestMethod.GET)
    public String getConstant(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        Students students = (Students) request.getAttribute("user");
        log.info("students  is " + students);
        try {
            Constant constant = new Constant();
            List<Long> ids = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                    Constant.CONSTANT_CITY_ID_TYPE, students.getCityId(), 0, Integer.MAX_VALUE);
            log.info("ids is "+ids);
            if (CollectionUtils.isEmpty(ids)) {
                constant.setEvaluate(Constant.EVALUATE_NO);
            } else {
                List<Constant> list = constantService.getObjectsByIds(ids);
                constant = list.get(0);
                log.info("constant is "+constant);
            }
            School school = new School();
            if (DataUtils.isNullOrEmpty(students.getSchoolId())) {
                constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY));
                constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START));
                constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END));
            } else {
                List<Long> constantIds = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                        Constant.CONSTANT_SCHOOL_ID_TYPE, students.getSchoolId(), 0, Integer.MAX_VALUE);
                log.info("constantIds is "+constantIds);

                if (CollectionUtils.isEmpty(constantIds)) {
                    constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY));
                    constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START));
                    constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END));
                } else {
                    List<Constant> constantList = constantService.getObjectsByIds(constantIds);
                    Constant constantData = constantList.get(0);
                    log.info("constantData is "+constantData);
                    constant.setDay(constantData.getDay());
                    constant.setTimeStart(constantData.getTimeStart());
                    constant.setTimeEnd(constantData.getTimeEnd());
                }
                school = schoolService.getObjectById(students.getSchoolId());
                log.info("school is " + school);
            }
            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null,
                    students.getId(), null, null, null, null, null);
            log.info("map is "+map);
            List<Long> orderMaxIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            log.info("orderMaxIds is "+orderMaxIds);

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);
            model.addAttribute("school", school);
            model.addAttribute("length", orderMaxIds.size());

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/constantDetailJson";
    }

    /**
     * 约车
     * @param request
     * @param response
     * @param model
     * @param arrangeId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/arrange", method = RequestMethod.POST)
    public String arrange(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long arrangeId,
            Long time,Long coachId) throws Exception {
        log.info("arrangeId is " + arrangeId + " time is " + time);
        //判断参数是否为空
        if (DataUtils.isNullOrEmpty(arrangeId)) {
            log.info("arrangeId is null");
            model.addAttribute("code", -22008);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(time)) {
            log.info("time is null");
            model.addAttribute("code", -22010);
            return "/common/failure";
        }


        try {
            AdvanceTime advanceTime = advanceTimeService.getObjectById(arrangeId);
            if(DataUtils.isNullOrEmpty(advanceTime)){
                log.info("advanceTime is null");
                model.addAttribute("code", -22027);
                return "/common/failure";
            }
            log.info("advanceTime is "+advanceTime);
            CoachAppointTime coachAppointTime = coachAppointTimeService.getObjectById(advanceTime.getCoachTimeId());
            if(DataUtils.isNullOrEmpty(coachAppointTime)){
                log.info("coachAppointTime is null");
                model.addAttribute("code", -22028);
                return "/common/failure";
            }
            log.info("coachAppointTime is "+coachAppointTime);
            Long todayTime = TimeUtil.getTimesTodayMorningInMillis();
            Long nowTime = System.currentTimeMillis();
            log.info("nowTime is " + nowTime);
            log.info("todayTime is " + todayTime);
            Students students = (Students) request.getAttribute("user");
            Long practiceTime = time + advanceTime.getStartTime();
            log.info("practiceTime is "+practiceTime);
            //判断教练是否休息
            Map<String, Object> coachFreeMap = DynamicUtil.getCoachFreeList(coachId, time);
            log.info("coachFreeMap is "+coachFreeMap);
            List<Long> coachFreeIds = coachFreeService.getIdsByDynamicCondition(CoachFree.class, coachFreeMap, 0,
                    Integer.MAX_VALUE);
            log.info("coachFreeIds is "+coachFreeIds);
            if (CollectionUtils.isEmpty(coachFreeIds)) {
                if (Integer.valueOf(coachAppointTime.getTwoRest()).equals(CoachAppointTime.COACH_REST_YES)) {
                    log.info("coach is rest");
                    model.addAttribute("code", -22024);
                    return "/common/failure";
                }
            } else {
                List<CoachFree> coachFreeList = coachFreeService.getObjectsByIds(coachFreeIds);
                CoachFree coachFree = coachFreeList.get(0);
                log.info("coachFree is "+coachFree);
                if (Integer.valueOf(coachFree.getStatus()).equals(CoachFree.STATUS_ON)) {
                    log.info("coach is rest");
                    model.addAttribute("code", -22024);
                    return "/common/failure";
                }
            }

            if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                //判断是否是练车前x小时
                Long timeDifference = nowTime
                        - (practiceTime - (Long.valueOf(coachAppointTime.getTwoAdvanceTime()) * Constant.ONE_HOUR));
                log.info("timeDifference is"+timeDifference);
                if (timeDifference > 0) {
                    log.info("advanceTime is out");
                    model.addAttribute("code", -22025);
                    return "/common/failure";
                }
            }
            if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                //判断是否是练车前x小时
                Long timeDifference = nowTime
                        - (practiceTime - (Long.valueOf(coachAppointTime.getThreeAdvanceTime()) *Constant.ONE_HOUR));
                log.info("timeDifference is"+timeDifference);
                if (timeDifference > 0) {
                    log.info("advanceTime is out");
                    model.addAttribute("code", -22025);
                    return "/common/failure";
                }
            }

            //判断是否强制评价
            List<Long> constantIds = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                    Constant.CONSTANT_CITY_ID_TYPE, students.getCityId(), 0, Integer.MAX_VALUE);
            log.info("constantIds is "+constantIds);
            if (CollectionUtils.isNotEmpty(constantIds)) {
                List<Constant> constantList = constantService.getObjectsByIds(constantIds);
                Constant constant = constantList.get(0);
                log.info("constant is "+constant);
                Integer evaluate = constant.getEvaluate();
                List<String> typeList = new ArrayList<>();
                typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
                if (evaluate.equals(Constant.EVALUATE_YES)) {
                    Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null,
                            students.getId(), null, null, null, null, null);
                    log.info("map is " + map);
                    List<Long> evaluateIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                            Integer.MAX_VALUE);
                    log.info("evaluateIds is "+evaluateIds);
                    if (CollectionUtils.isNotEmpty(evaluateIds)) {
                        log.info(" evaluate order is no null");
                        model.addAttribute("code", -22012);
                        return "/common/failure";
                    }
                }
            }

            log.info("nowTime-todayTime ====" + (nowTime - todayTime));
            //判断是否在可预约时间内
            if (DataUtils.isNullOrEmpty(students.getSchoolId())) {
                if ((nowTime - todayTime) < Constant.NO_SCHOOL_ID_APPOINT_START
                        || (nowTime - todayTime) > Constant.NO_SCHOOL_ID_APPOINT_END) {
                    log.info(" time  is out");
                    model.addAttribute("code", -22015);
                    return "/common/failure";
                }
            } else {
                List<Long> constantTimeIds = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                        Constant.CONSTANT_SCHOOL_ID_TYPE, students.getSchoolId(), 0, Integer.MAX_VALUE);
                log.info("constantTimeIds is "+constantTimeIds);
                if(CollectionUtils.isEmpty(constantTimeIds)){
                    if ((nowTime - todayTime) < Constant.NO_SCHOOL_ID_APPOINT_START || (nowTime - todayTime) > Constant.NO_SCHOOL_ID_APPOINT_END) {
                        log.info(" time  is out");
                        model.addAttribute("code", -22015);
                        return "/common/failure";
                    }
                    if ((time - todayTime) > (Constant.NO_SCHOOL_ID_APPOINT_DAY *Constant.ONE_DAY)) {
                        log.info(" time  is out");
                        model.addAttribute("code", -22015);
                        return "/common/failure";
                    }
                }else {
                    List<Constant> constantList=constantService.getObjectsByIds(constantTimeIds);
                    Constant constant = constantList.get(0);
                    log.info("constant is "+constant);
                    if ((nowTime - todayTime) < constant.getTimeStart() || (nowTime - todayTime) > constant.getTimeEnd()) {
                        log.info(" time  is out");
                        model.addAttribute("code", -22015);
                        return "/common/failure";
                    }
                    if(DataUtils.isNotNullOrEmpty(constant.getDay())){
                        if ((time - todayTime) > (constant.getDay() * Constant.ONE_DAY)) {
                            log.info(" time  is out");
                            model.addAttribute("code", -22015);
                            return "/common/failure";
                        }
                    }else {
                        if ((time - todayTime) > (Constant.NO_SCHOOL_ID_APPOINT_DAY * Constant.ONE_DAY)) {
                            log.info(" time  is out");
                            model.addAttribute("code", -22015);
                            return "/common/failure";
                        }
                    }
                }
            }

            //判断区域时间是否存在
            log.info("advanceTime is " + advanceTime);
            if (DataUtils.isNullOrEmpty(advanceTime)) {
                log.info("advanceTime is null");
                model.addAttribute("code", -22009);
                return "/common/failure";
            }
            //判断是否达到可预约人数
            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, time, advanceTime.getStartTime(),
                    advanceTime.getEndTime(), coachId, null, advanceTime.getSubject(), null, null,
                    null, null);
            log.info("map is "+map);
            List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            log.info("orderIds is "+orderIds);
            Integer orderIdsSize = orderIds.size();
            if ((orderIdsSize >= advanceTime.getNum())) {
                log.info("num is enough");
                model.addAttribute("code", -22013);
                return "/common/failure";
            }
            //判断是否已预约
            Map<String, Object> userMap = DynamicUtil.getAppointOrderList(typeList, time, advanceTime.getStartTime(),
                    advanceTime.getEndTime(), coachId, students.getId(), advanceTime.getSubject(),
                    null, null, null, null);
            log.info("userMap is "+userMap);
            List<Long> userOrderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, userMap, 0,
                    Integer.MAX_VALUE);
            log.info("userOrderIds is "+userOrderIds);
            if (CollectionUtils.isNotEmpty(userOrderIds)) {
                log.info("order is already exist");
                model.addAttribute("code", -22014);
                return "/common/failure";
            }

            //判断区域时间是否重叠

            //验证学时是否超出
            BigDecimal studyTime = new BigDecimal(
                    (advanceTime.getEndTime() - advanceTime.getStartTime()) / (Constant.ONE_HOUR * advanceTime.getNum()))
                    .setScale(2, BigDecimal.ROUND_HALF_UP);
            if(DataUtils.isNotNullOrEmpty(students.getClassId())) {
                if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                    log.info("getSectionTwoNumerator is " + students);
                    BigDecimal sectionTwoNumerator;
                    if(DataUtils.isNotNullOrEmpty(students.getSectionTwoNumerator())){
                        sectionTwoNumerator = new BigDecimal(students.getSectionTwoNumerator()).setScale(2, BigDecimal.ROUND_HALF_UP);
                    }else {
                        sectionTwoNumerator = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
                    }
                    BigDecimal sectionTwoDenominator = new BigDecimal(Long.valueOf(students.getSectionTwoDenominator())).setScale(2, BigDecimal.ROUND_HALF_UP);
                    double newStudyTime = Calculation.add(studyTime.doubleValue(), sectionTwoNumerator.doubleValue());
                    double differenceTime = Calculation.sub(newStudyTime, sectionTwoDenominator.doubleValue());
                    if (differenceTime > 0) {
                        log.info("studyTime is already exist");
                        model.addAttribute("code", -22023);
                        return "/common/failure";
                    }
                    students.setSectionTwoNumerator(Double.toString(newStudyTime));
                }
                if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                    log.info("getSectionThreeNumerator is " + students);
                    BigDecimal sectionThreeNumerator;
                    if(DataUtils.isNotNullOrEmpty(students.getSectionThreeNumerator())){
                        sectionThreeNumerator = new BigDecimal(students.getSectionThreeNumerator()).setScale(2,
                                BigDecimal.ROUND_HALF_UP);
                    }else {
                        sectionThreeNumerator = new BigDecimal(0).setScale(2,
                                BigDecimal.ROUND_HALF_UP);
                    }


                    BigDecimal sectionThreeDenominator = new BigDecimal(students.getSectionThreeDenominator()).setScale(2,
                            BigDecimal.ROUND_HALF_UP);
                    double newStudyTime = Calculation.add(studyTime.doubleValue(), sectionThreeNumerator.doubleValue());
                    double differenceTime = Calculation.sub(newStudyTime, sectionThreeDenominator.doubleValue());
                    if (differenceTime > 0) {
                        log.info("studyTime is already exist");
                        model.addAttribute("code", -22023);
                        return "/common/failure";
                    }
                    students.setSectionThreeNumerator(Double.toString(newStudyTime));
                }
            }
            Coach coach=coachService.getObjectById(coachId);
            if(DataUtils.isNullOrEmpty(coach)){
                log.info("coach is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            log.info("coach is "+coach);
            AppointOrder appointOrder = new AppointOrder();
            appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED);
            appointOrder.setTime(time);
            appointOrder.setCoach(coachId);
            if(DataUtils.isNullOrEmpty(coach.getName())){
                appointOrder.setCoachName(coach.getNick());
            }else {
                appointOrder.setCoachName(coach.getName());
            }
            appointOrder.setCoachMobile(coach.getMobile());
            appointOrder.setStudent(students.getId());
            appointOrder.setStudentName(students.getName());
            appointOrder.setStudentMobile(students.getMobile());
            appointOrder.setTimeStart(advanceTime.getStartTime());
            appointOrder.setTimeEnd(advanceTime.getEndTime());
            appointOrder.setSubject(advanceTime.getSubject());
            appointOrder.setAdvanceId(arrangeId);
            appointOrder.setStudyTime(studyTime.toString());
            appointOrder.setCityId(students.getCityId());
            appointOrder.setSchoolId(students.getSchoolId());
            log.info("appointOrder is " + appointOrder);

            appointOrderService.insert(appointOrder);
            studentsService.update(students);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     *我的订单
     * @param request
     * @param response
     * @param model
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/car/order/list", method = RequestMethod.GET)
    public String getCarOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer type, Integer page, Integer size) throws Exception {

        log.info("type is " + type);
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -22016);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            List<String> typeList = new ArrayList<>();

            switch (type){
                case AppointOrder.ORDER_TYPE_PENDING:
                    typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
                    break;
                case AppointOrder.ORDER_TYPE_PROCESSING:
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
                    break;
                case AppointOrder.ORDER_TYPE_COMPLETED:
                    typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
                    typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
                    break;
                case AppointOrder.ORDER_TYPE_SOLD:
                    typeList.add(AppointOrder.ORDER_SOLD_INQUIRE);
                    break;
                default:
                    break;
            }

            Students students = (Students) request.getAttribute("user");
            log.info("students is "+students);
            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null,
                    students.getId(), null, null, null, null, null);
            log.info("map is "+map);
            List<Long> orderMaxIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            log.info("orderMaxIds is "+orderMaxIds);
            List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, start, size);
            log.info("orderIds is "+orderIds);
            Integer total = orderMaxIds.size();
            List<AppointOrder> appointOrderList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(orderIds)){
                appointOrderList = appointOrderService.getObjectsByIds(orderIds);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("appointOrderList", appointOrderList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/carOrderList";
    }

    /**
     *取消订单
     * @param request
     * @param response
     * @param model
     * @param id
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/car/order/cancel/{id}", method = RequestMethod.PUT)
    public String carOrderCancel(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer type, String cancel) throws Exception {
        log.info("type is " + type + " id is " + id);
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -22017);
            return "/common/failure";
        }
        Students students = (Students) request.getAttribute("user");
        try {
            AppointOrder appointOrder = appointOrderService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(appointOrder)){
                log.info("appointOrder is null");
                model.addAttribute("code", -22026);
                return "/common/failure";
            }
            log.info("appointOrder is "+appointOrder);
            Integer orderType = appointOrder.getType();
            log.info("orderType is "+orderType+"  type  is "+type);
            if (orderType.equals(AppointOrder.STUDENT_PENDING_COACH_CANCEL)) {//学员待处理，教练取消
                if (type.equals(AppointOrder.ORDER_AGREE_YES)) {//学员同意取消
                    appointOrder.setType(AppointOrder.ORDER_SOLD);
                    appointOrder.setCancelTime(System.currentTimeMillis());
                    if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                        BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionTwoDenominator())
                                - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                        students.setSectionTwoDenominator(time.toString());
                    }
                    if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                        BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator())
                                - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                        students.setSectionTwoDenominator(time.toString());
                    }
                } else {//学员拒绝取消
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED);
                    appointOrder.setCancel(null);
                }
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED)) {//学员进行中，教练未确认
                if (type.equals(AppointOrder.ORDER_AGREE_YES)) {//教练同意订单
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED);
                } else if (type.equals(AppointOrder.ORDER_AGREE_NO)) {//教练拒绝订单
                    appointOrder.setType(AppointOrder.STUDENT_PENDING_COACH_CANCEL);
                    appointOrder.setCancel(cancel);
                } else {//学员直接取消订单
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL);
                    appointOrder.setCancel(cancel);
                }
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED)) {//学员进行中，教练已确认
                appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL);//学员取消订单
                appointOrder.setCancel(cancel);
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL)) {//学员进行中，取消订单，教练未确认，
                if (type.equals(AppointOrder.ORDER_AGREE_YES)) {//教练同意取消
                    if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                        BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionTwoDenominator())
                                - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                        students.setSectionTwoDenominator(time.toString());
                    }
                    if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                        BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator())
                                - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                        students.setSectionTwoDenominator(time.toString());
                    }
                    appointOrder.setType(AppointOrder.ORDER_SOLD);
                    appointOrder.setCancelTime(System.currentTimeMillis());
                } else {//教练拒绝取消
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED);
                    appointOrder.setCancel(null);
                }
            } else {
                log.info("order is over");
                model.addAttribute("code", -22018);
                return "/common/failure";
            }

            appointOrderService.update(appointOrder);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     *评价订单
     * @param request
     * @param response
     * @param model
     * @param id
     * @param score
     * @param content
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/car/order/evaluate/{id}", method = RequestMethod.PUT)
    public String carOrderEvaluate(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, String score, String content) throws Exception {
        log.info("content is " + content + " id is " + id + " score is " + score);
        if (DataUtils.isNullOrEmpty(content)) {
            log.info("content is null");
            model.addAttribute("code", -22019);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(score)) {
            log.info("score is null");
            model.addAttribute("code", -22020);
            return "/common/failure";
        }
        Students students = (Students) request.getAttribute("user");


        try {
            AppointOrder appointOrder = appointOrderService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(appointOrder)){
                log.info("appointOrder is null");
                model.addAttribute("code", -22026);
                return "/common/failure";
            }
            log.info("appointOrder is "+appointOrder);
            Long studentId = students.getId();
            if (!studentId.equals(appointOrder.getStudent())) {
                log.info("studentId is error");
                model.addAttribute("code", -22022);
                return "/common/failure";
            }
            Integer type = appointOrder.getType();
            log.info("type is "+type);
            if (type.equals(AppointOrder.ORDER_COMPLETED_EVALUATED_NO)) {
                appointOrder.setComment(content);
                appointOrder.setScore(score);
                appointOrder.setType(AppointOrder.ORDER_COMPLETED_EVALUATED_YES);
                appointOrderService.update(appointOrder);
            } else {
                log.info("type is error");
                model.addAttribute("code", -22021);
                return "/common/failure";
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     *评价列表
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/evaluate/list/{id}", method = RequestMethod.GET)
    public String getCarOrderEvaluateList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer page, Integer size) throws Exception {
        log.info(" id is " + id);
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, id, null, null, null,
                    null, null, null);
            log.info("map is " + map);
            List<Long> orderMaxIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, start, size);
            log.info("orderIds is " + orderIds);
            Integer total = orderMaxIds.size();
            List<AppointOrder> appointOrderList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(orderIds)){
                appointOrderList = appointOrderService.getObjectsByIds(orderIds);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("appointOrderList", appointOrderList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/CarOrderEvaluateList";
    }

}
