package com.ptteng.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.VersionIsForceUpdateCode;
import com.ptteng.yi.pub.model.Version;
import com.ptteng.yi.pub.service.VersionService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Controller
public class VersionController {
    private static final Log log = LogFactory.getLog(VersionController.class);

    @Autowired
    private VersionService versionService;

    private static final String OS = "os";

    private static final String VERSIONCODE = "versionCode";

    private static final String VERSIONNUMBER = "versionNumber";

    private static final String TYPE = "type";

    /**
     * create_by:qingshan
     * create_at:2018.1.31
     * 获取版本列表接口
     *
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/version", method = RequestMethod.GET)
    public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info("version update control begin ==================");
        String os = request.getParameter(OS);
        String versionCode = request.getParameter(VERSIONCODE);
        String versionNumber = request.getParameter(VERSIONNUMBER);
        String type = request.getParameter(TYPE);
        if (StringUtil.isEmpty(versionCode)) {
            versionCode = request.getHeader(VERSIONCODE);
        }
        if (StringUtil.isEmpty(versionNumber)) {
            versionNumber = request.getHeader(VERSIONNUMBER);
        }
        if (StringUtil.isEmpty(os)) {
            os = request.getHeader(OS);
        }
        if (StringUtil.isEmpty(type)) {
            os = request.getHeader(TYPE);
        }
        log.info("os = " + os + "     versionCode = " + versionCode + "     versionNumber" + versionNumber
                + "       type = " + type);
        try {

            Integer needUpdate = 1;//只要不是最新版本，都需要更新，其中会有是否需要强制更新的差别

            //参数校验
            if (StringUtil.isEmpty(os)) {
                log.info("arg os is empty and need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            if (StringUtil.isEmpty(versionCode)) {
                log.info("arg versionCode is empty need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            if (StringUtil.isEmpty(versionNumber)) {
                log.info("arg versionNumber is empty need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", needUpdate);
                return "/yi-pub-service/version/json/version";
            }
            if (StringUtil.isEmpty(type)) {
                log.info("arg version is empty need force updating");
                model.addAttribute("code", 0);
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                model.addAttribute("needUpdate", needUpdate);
                return "/yi-pub-service/version/json/version";
            }

            //获取最新版本
            Map<String, Object> params = DynamicUtil.getPlQuery(Integer.valueOf(os), Integer.valueOf(type));
            log.info("patient android version params is :" + params);
            List<Long> paramsList = versionService.getIdsByDynamicCondition(Version.class, params, 0,
                    Integer.MAX_VALUE);
            log.info("patient android version params get dynamic ids is :" + paramsList);

            List<Version> versionListByOsAndType = versionService.getObjectsByIds(paramsList);
            Collections.sort(versionListByOsAndType);

            List<Version> versionList = new ArrayList<>();
            model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.noNeedForceUpdate.getValue());
            for (Version systemVersion : versionListByOsAndType) {
                switch (systemVersion.compareCode(systemVersion.getVersion_number(), Integer.valueOf(versionNumber))) {
                case 1:
                    versionList.add(systemVersion);
                    if (systemVersion.getIs_force_update() == 1) {
                        log.info("need force updating");
                        model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.needForceUpdate.getValue());
                    } else {
                        log.info("version : " + systemVersion.getVersion_code()
                                + " is a new version but not need tu force updating");
                    }
                    break;
                default:
                    break;
                }
            }

            Version latestVersion = null;
            log.info("new version list is" + versionList);
            if (CollectionUtils.isEmpty(versionList)) {
                log.info("version is new and don't need force updating");
                needUpdate = 0;//versionList 为空说明当前版本为最新版本，不需要更新
                model.addAttribute("isForceUpdate", VersionIsForceUpdateCode.latestUpdateVersion.getValue());
            } else {
                log.info("version is not new but don't need force updating");
                latestVersion = versionList.get(0);
            }
            log.info("latest version is" + latestVersion);
            log.info("get latestVersionInfo finish ==========");

            model.addAttribute("code", 0);
            model.addAttribute("needUpdate", needUpdate);
            model.addAttribute("version", latestVersion);

        } catch (Exception e) {
            log.error("VersionManager error...", e);
            log.error("try cat a exception!");
            model.addAttribute("code", -100000);
        }
        log.info("version update control end ==================");
        return "/yi-pub-service/version/json/version";
    }
}
