package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.constant.CookieConstant;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.UserNameUtil;
import com.ptteng.yi.nucleus.model.Probation;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.ProbationService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.model.Sms;
import com.ptteng.yi.pub.service.CitiesService;
import com.ptteng.yi.pub.service.ImAccountService;
import com.ptteng.yi.pub.service.SmsService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Student  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private StudentsService studentsService;

    @Autowired
    private SmsService smsService;

    @Autowired
    private CitiesService citiesService;

    @Autowired
    ImAccountService imAccountService;

    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;

    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ProbationService probationService;

    @Autowired
    ImChatUtil imChatUtil;

    /**
     * 用户注册
     * @param request
     * @param response
     * @param model
     * @param mobile 手机号
     * @param verify 验证码
     * @param pwd 密码
     * @param cityId 城市id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/register", method = RequestMethod.POST)
    public String register(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
            String verify, String pwd, Long cityId) throws Exception {

        log.info("POST request url: /a/register, get parameter mobile: " + mobile + ", verify: " + verify + ", pwd: "
                + pwd + ", cityId: " + cityId);

        if (StringUtils.isEmpty(mobile)) {
            log.info("parameter mobile is null or empty");
            model.addAttribute("code", -5022);
            return "/common/failure";
        }

        if (mobile.length() != 11) {
            log.info("parameter mobile is illegal");
            model.addAttribute("code", -5023);
            return "/common/failure";
        }

        if (StringUtils.isEmpty(pwd)) {
            log.info("parameter pwd is null or empty");
            model.addAttribute("code", -5008);
            return "/common/failure";
        }

        if (pwd.length() < 6 || pwd.length() > 16) {
            log.info("parameter pwd length is illegal");
            model.addAttribute("code", -5026);
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("parameter cityId is null or empty");
            model.addAttribute("code", -5036);
            return "/common/failure";
        }

        if (cityId < 1L) {
            log.info("parameter cityId is illegal");
            model.addAttribute("code", -5037);
            return "/common/failure";
        }

        Long id = null;
        Long imAccountId = null;

        try {
            List<Long> cityIds = citiesService.getCitiesIdsByCityid(cityId, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(cityIds)) {
                log.info("there is no city in DB");
                model.addAttribute("code", -12003);
                return "/common/failure";
            }

            String type = "register";

            boolean verifyResult = false;

            if (verifyModel()) {
                log.info("is test model ");
                if ("555555".equals(verify)) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                    verifyResult = verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            }

            if (verifyResult) {
                Long sid = studentsService.getStudentsIdByMobile(mobile);

                if (sid != null) {
                    log.info("the mobile is already registered");
                    model.addAttribute("code", -5025);
                    return "/common/failure";
                } else {
                    Students student = new Students();
                    student.setMobile(mobile);
                    student.setPwd(PasswordUtils.encode(pwd));
                    student.setStatus(1);
                    student.setCertification(0);
                    student.setUpdateBy(-1L);
                    student.setCreateBy(-1L);
                    student.setCityId(cityId);

                    UserNameUtil userNameUtil = new UserNameUtil();
                    student.setNick(userNameUtil.getRandomName());

                    id = studentsService.insert(student);

                    if (id != null) {
                        String token = IdentityUtil.encodeCookie("uid", id);

                        //创建网易云IM即时通讯账号并存入数据库
                        String accid = imChatUtil.getAccid(id, ImChatUtil.AccidType.STUDENT);
                        String accidToken = null;
                        String code = null;
                        String message = null;
                        Map<String, String> result = imChatUtil.createImAccount(accid);
                        log.info("result is==" + (null != result && 0 != result.size() ? Arrays.asList(result)
                                : " null or size is zero"));

                        code = result.get("code");
                        if (code.equals("200")) {
                            log.info("create im account success");
                            accidToken = result.get("token");
                            accid = result.get("accid");
                            ImAccount imAccount = new ImAccount();
                            imAccount.setAccount(accid);
                            imAccount.setBelongId(id);
                            imAccount.setBelongtType(0);
                            imAccount.setToken(accidToken);
                            imAccount.setCreateAt(System.currentTimeMillis());
                            imAccount.setCreateBy(id);
                            imAccount.setUpdateAt(System.currentTimeMillis());
                            imAccount.setUpdateBy(id);

                            imAccountId = imAccountService.insert(imAccount);
                            log.info("create im account success,insert to DB success");

                            boolean success = imChatUtil.updateUserInfo(accid, student);
                            if (success)
                                log.info("update student info success");
                            else
                                log.info("update student info failed");

                        } else {
                            message = result.get("message");
                            log.info("create im account failed,see==" + message);
                            studentsService.delete(id);
                            throw new Exception("register failed,cause create im account failed");
                        }

                        Map<String, String> maps = new HashMap();
                        maps.put(CookieUtil.USER_ID, id.toString());
                        maps.put(CookieConstant.COOKIE_WEB_MOBILE, mobile);
                        cookieUtil.setIdentity(request, response, maps, id);

                        model.addAttribute("token", token);
                        model.addAttribute("uid", id);

                        model.addAttribute("code", "0");
                    }
                }
            } else {
                log.info("create im account failed or insert im account to DB failed");
                log.error("wrong verifycode");
                model.addAttribute("code", -5024);

                return "/common/failure";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("student register error ");
            if (null != t.getMessage() && t.getMessage().equals("register failed,cause create im account failed")) {
                model.addAttribute("code", -24000);
            } else {
                model.addAttribute("code", -100000);
            }

            if (null != imAccountId)
                imAccountService.delete(imAccountId);

            if (null != id)
                studentsService.delete(id);
        }

        return "/common/register";
    }

    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }

    /**
     * 验证码校验 */

    private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify)
            throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndTypeAndApp(mobile, type, Sms.APP_STUDENT);
        log.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            log.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }

    /**
     * 验证码发送
     * @param request
     * @param response
     * @param model
     * @param mobile 手机号
     * @param type 验证码类型
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
            String type) throws Exception {
        log.info(mobile + " want send sms of type " + type);

        if (StringUtils.isEmpty(mobile)) {
            log.info("parameter mobile is null or empty");
            model.addAttribute("code", -5022);
            return "/common/failure";
        }

        if (StringUtils.isEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -5028);
            return "/common/failure";
        }
        if (StringUtils.isEmpty(type)) {
            log.info("parameter type is null or empty");
            model.addAttribute("code", -5033);
            return "/common/failure";
        }

        try {

            if ("register".equals(type) || "mobile".equals(type)) {
                Long uid = studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {

                    log.info(type + " is already exist  " + mobile);

                    model.addAttribute("code", -5019);
                    return "/common/failure";
                }

            } else if ("experience".equals(type)) {
                Long uid = studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {
                    Map<String, Object> map = new HashMap<>();
                    map = DynamicUtil.getStudentClueListParams(mobile);
                    List<Long> clueList = probationService.getIdsByDynamicCondition(Probation.class, map, 0,
                            Integer.MAX_VALUE);

                    if (clueList.size() > 0) {
                        log.info("this mobile is already use in experience  " + mobile);
                        model.addAttribute("code", -5032);
                        return "/common/failure";
                    }
                }

            } else if ("password".equals(type)) {
                Long uid = studentsService.getStudentsIdByMobile(mobile);
                if (uid == null) {

                    log.info(type + " is not already exist  " + mobile);

                    model.addAttribute("code", -5003);
                    return "/common/failure";
                }
            } else {
                log.info("parameter type is illegal");
                model.addAttribute("code", -5034);
                return "/common/failure";
            }

            int code = 0;

            log.info("sms is start");
            String result = this.smsService.sendSms(mobile, type, "msg", Sms.APP_STUDENT);

            switch (result) {
            case SmsService.ERRORCODE_SMS_INVALIDTYPE:
                code = -5029;
                break;
            case SmsService.ERRORCODE_SMS_MORETHAN5:
                code = -5030;
                break;
            default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", -100000);

        }
        return "/common/success";

    }

    /**
     * 语音验证码
     * @param request
     * @param response
     * @param model
     * @param mobile 手机号
     * @param type 验证码类型
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
            String type) throws Exception {
        log.info(mobile + " want send voice of type " + type);

        if (StringUtils.isEmpty(mobile)) {
            log.info("parameter mobile is null or empty");
            model.addAttribute("code", -5022);
            return "/common/failure";
        }
        if (StringUtils.isEmpty(type)) {
            log.info("parameter type is null or empty");
            model.addAttribute("code", -5033);
            return "/common/failure";
        }
        try {

            if ("register".equals(type) || "mobile".equals(type)) {
                Long uid = studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {

                    log.info(type + " is already exist  " + mobile);

                    model.addAttribute("code", -5019);
                    return "/common/failure";
                }

            } else if ("experience".equals(type)) {
                Long uid = studentsService.getStudentsIdByMobile(mobile);
                if (uid != null) {

                    Map<String, Object> map = new HashMap<>();
                    map = DynamicUtil.getStudentClueListParams(mobile);
                    List<Long> clueList = probationService.getIdsByDynamicCondition(Probation.class, map, 0,
                            Integer.MAX_VALUE);

                    if (clueList.size() > 0) {
                        log.info("this mobile is already use in experience  " + mobile);
                        model.addAttribute("code", -5032);
                        return "/common/failure";
                    }
                }

            } else if ("password".equals(type)) {
                Long uid = studentsService.getStudentsIdByMobile(mobile);
                if (uid == null) {

                    log.info(type + " is not already exist  " + mobile);

                    model.addAttribute("code", -5003);
                    return "/common/failure";
                }
            } else {
                log.info("parameter type is illegal");
                model.addAttribute("code", -5034);
                return "/common/failure";
            }

            String realMobile = mobile;
            log.info("final mobile is : " + realMobile);

            int code = 0;

            String result = this.smsService.sendSms(realMobile, type, "voice", Sms.APP_STUDENT);
            switch (result) {
            case SmsService.ERRORCODE_SMS_INVALIDTYPE:
                code = -5029;
                break;
            case SmsService.ERRORCODE_SMS_MORETHAN5:
                code = -5030;
                break;
            case SmsService.ERRORCODE_SENDERROR:
                code = -5031;
                break;
            default:

            }

            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send voice error of type " + type);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 用户登陆
     * @param request
     * @param response
     * @param mapModel
     * @param mobile 手机号
     * @param pwd 密码
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap mapModel, String mobile,
            String pwd) throws Exception {

        log.info("POST request url: /a/login, get parameter mobile: " + mobile + ", pwd: " + pwd);

        log.info("========= uri is :" + request.getRequestURI());
        log.info("========= url is :" + request.getRequestURL());

        if (mobile == null) {
            mapModel.addAttribute("code", -5022);
            return "/common/failure";
        }

        Long uid = studentsService.getStudentsIdByMobile(mobile);
        String token = IdentityUtil.encodeCookie("uid", uid);

        if (uid == null) {
            mapModel.addAttribute("code", -5003);
            return "common/failure";
        }
        log.info("uid is " + uid);
        Students user = this.studentsService.getObjectById(uid);
        Integer status = user.getStatus();
        if (status.equals(0)) {
            mapModel.addAttribute("code", -5038);
            return "common/failure";
        }

        String pass = PasswordUtils.encode(pwd);
        Boolean verify = user.getPwd().equals(pass);

        if (verify) {
            log.info(uid + " login ");
            Map<String, String> maps = new HashMap();

            maps.put(CookieUtil.USER_ID, uid + "");
            maps.put(CookieConstant.COOKIE_WEB_MOBILE, mobile);
            cookieUtil.setIdentity(request, response, maps, uid);

            mapModel.addAttribute("code", 0);
            mapModel.addAttribute("user", user);
            mapModel.addAttribute("token", token);
        } else {
            log.info(mobile + " wrong pwd " + pwd);
            mapModel.put("code", -5006);
            return "/common/failure";
        }

        return "/common/login";
    }

    /**
     * 忘记密码
     * @param request
     * @param response
     * @param model
     * @param mobile 手机号
     * @param verify 验证码
     * @param newPwd 新密码
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/password/forget", method = RequestMethod.PUT)
    public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
            String verify, String newPwd) throws Exception {
        try {

            log.info(" mobile = " + mobile + " verify  = " + verify + " pwd = " + newPwd);

            if (StringUtil.isEmpty(mobile)) {
                log.info("params mobile is null or empty");
                model.addAttribute("code", -5022);

                return "/common/failure";
            }
            if (StringUtil.isEmpty(verify)) {
                log.info("params verify is null or empty");
                model.addAttribute("code", -5028);

                return "/common/failure";
            }
            if (StringUtil.isEmpty(newPwd)) {
                log.info("params newPwd is null or empty");
                model.addAttribute("code", -5027);

                return "/common/failure";
            }

            // 是否已注册
            Long uid = studentsService.getStudentsIdByMobile(mobile);

            // 用户不存在
            if (uid == null) {
                log.info(mobile + " not exist ");
                model.addAttribute("code", -5003);

                return "/common/failure";

            } else {
                log.info(mobile + " exist and uid is " + uid);
            }

            boolean verifyResult = false;

            String type = "password";

            // 测试模式
            if (verifyModel()) {
                if ("555555".equals(verify)) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            }

            if (verifyResult) {
                Students user = studentsService.getObjectById(uid);

                String encodePass = PasswordUtils.encode(newPwd);
                user.setPwd(encodePass);
                boolean result = studentsService.update(user);

                log.info(mobile + " change password," + newPwd + "result is " + result);
                log.info("rewrite password success! ");

                model.addAttribute("code", 0);
                model.addAttribute("message", "密码修改成功");

            } else {
                log.error("rewritepwd verifycode");
                model.addAttribute("code", -5024);

                return "/common/failure";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -100000);
        }

        return "/common/success";

    }

    //2.注销
    @RequestMapping(value = "/a/u/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager logout ");

        try {
            cookieUtil.clearCookie(response);

            model.addAttribute("code", 0);
            model.addAttribute("result", "/login/index");

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager logout error  ");
            model.addAttribute("code", -5005);
            model.addAttribute("result", null);
        }

        return "/data/json";
    }

    /**
     * 修改用户密码
     * @param request
     * @param response
     * @param model
     * @param oldPwd 旧密码
     * @param newPwd 新密码
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/pwd", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String oldPwd,
            String newPwd) throws Exception {
        log.info(" oldPwd = " + oldPwd + " newPwd = " + newPwd);
        Students user = (Students) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            log.info(" user : " + uid + " want update pwd");

            if (StringUtil.isEmpty(newPwd) || StringUtils.isEmpty(oldPwd)) {
                log.info("params is null");
                model.addAttribute("code", -5008);
                return "/common/failure";
            }

            String pass = PasswordUtils.encode(oldPwd);
            Boolean verify = user.getPwd().equals(pass);
            if (verify) {
                log.info(uid + " have right pwd ");

                String encodePass = PasswordUtils.encode(newPwd);
                user.setPwd(encodePass);
                boolean result = studentsService.update(user);

            } else {
                log.info(uid + " wrong pwd " + oldPwd);
                model.put("code", -5006);
                return "/common/failure";
            }

            model.addAttribute("code", 0);
            return "/common/failure";

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("student " + uid + " update pwd error ");
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 强制更新版本重定向到此请求
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    //    @RequestMapping(value = "/a/force/update/version", method = RequestMethod.GET)
    //    public String forceUpdate(HttpServletRequest request, HttpServletResponse response,
    //                              ModelMap model) {
    //        log.info("method forceUpdate begin...");
    //
    //        try {
    //           /*医师*/
    //            Long constantIdByDoctorCode = constantService.getConstantIdByTypeAndName("doctorCode", "version");
    //            Long constantIdByDoctorIosCode = constantService.getConstantIdByTypeAndName("doctorIosCode", "version");
    //            Long constantIdByDoctorAndCode = constantService.getConstantIdByTypeAndName("doctorAndroidCode", "version");
    //            Long constantIdByDoctorUrl = constantService.getConstantIdByTypeAndName("doctorUrl", "version");
    //            Long constantIdByDoctorIosName = constantService.getConstantIdByTypeAndName("doctorIosName", "version");
    //            Long constantIdByDoctorAndroidName = constantService.getConstantIdByTypeAndName("doctorAndroidName", "version");
    //            Long constantIdByDoctorInfo = constantService.getConstantIdByTypeAndName("doctorInfo", "version");
    //
    //            if (null != constantIdByDoctorCode && null != constantIdByDoctorUrl) {
    //                Constant constantByDoctorIosCode = constantService.getObjectById(constantIdByDoctorIosCode);
    //                Constant constantDoctorByAndCode = constantService.getObjectById(constantIdByDoctorAndCode);
    //                Constant constantByDoctorCode = constantService.getObjectById(constantIdByDoctorCode);
    //                Constant constantByDoctorUrl = constantService.getObjectById(constantIdByDoctorUrl);
    //                Constant constantByDoctorIosName = constantService.getObjectById(constantIdByDoctorIosName);
    //                Constant constantByDoctorAndroidName = constantService.getObjectById(constantIdByDoctorAndroidName);
    //                Constant constantByDoctorInfo = constantService.getObjectById(constantIdByDoctorInfo);
    //
    //                String doctorIosName = constantByDoctorIosName.getValue();
    //                String doctorAndroidName = constantByDoctorAndroidName.getValue();
    //                String doctorUrl = constantByDoctorUrl.getValue();
    //                String doctorVersionCode = constantByDoctorCode.getValue();
    //                String doctorIosCode = constantByDoctorIosCode.getValue();
    //                String doctorAndroidCode = constantDoctorByAndCode.getValue();
    //                String doctorInfo = constantByDoctorInfo.getValue();
    //
    //                model.addAttribute("doctorUrl", doctorUrl);
    //                model.addAttribute("doctorIosName", doctorIosName);
    //                model.addAttribute("doctorAndroidName", doctorAndroidName);
    //                model.addAttribute("doctorInfo", doctorInfo);
    //                model.addAttribute("doctorVersionCode", doctorVersionCode);
    //                model.addAttribute("doctorIosCode", doctorIosCode);
    //                model.addAttribute("doctorAndroidCode", doctorAndroidCode);
    //
    //                log.info("get version : doctorIosName =  " + doctorIosName + " doctorAndroidName " + doctorAndroidName + " url = " + doctorUrl +
    //                        " doctorVersionCode = " + doctorVersionCode + " doctorIosCode = " + doctorIosCode + " doctorAndroidCode = " + doctorAndroidCode + " doctorInfo = " + doctorInfo);
    //            } else {
    //                log.info("no version");
    //            }
    //
    //
    //            /*患者*/
    //            Long constantIdByPatientCode = constantService.getConstantIdByTypeAndName("patientCode", "version");
    //            Long constantIdByPatientIosCode = constantService.getConstantIdByTypeAndName("patientIosCode", "version");
    //            Long constantIdByPatientAndCode = constantService.getConstantIdByTypeAndName("patientAndroidCode", "version");
    //            Long constantIdByPatientUrl = constantService.getConstantIdByTypeAndName("patientUrl", "version");
    //            Long constantIdByPatientIosName = constantService.getConstantIdByTypeAndName("patientIosName", "version");
    //            Long constantIdByPatientAndroidName = constantService.getConstantIdByTypeAndName("patientAndroidName", "version");
    //            Long constantIdByPatientInfo = constantService.getConstantIdByTypeAndName("patientInfo", "version");
    //
    //            if (null != constantIdByPatientCode && null != constantIdByPatientUrl) {
    //                Constant constantByPatientIosCode = constantService.getObjectById(constantIdByPatientIosCode);
    //                Constant constantPatientByAndCode = constantService.getObjectById(constantIdByPatientAndCode);
    //                Constant constantByPatientCode = constantService.getObjectById(constantIdByPatientCode);
    //                Constant constantByPatientUrl = constantService.getObjectById(constantIdByPatientUrl);
    //                Constant constantByPatientIosName = constantService.getObjectById(constantIdByPatientIosName);
    //                Constant constantByPatientAndroidName = constantService.getObjectById(constantIdByPatientAndroidName);
    //                Constant constantByPatientInfo = constantService.getObjectById(constantIdByPatientInfo);
    //
    //                String patientIosName = constantByPatientIosName.getValue();
    //                String patientAndroidName = constantByPatientAndroidName.getValue();
    //                String patientUrl = constantByPatientUrl.getValue();
    //                String PatientVersionCode = constantByPatientCode.getValue();
    //                String patientIosCode = constantByPatientIosCode.getValue();
    //                String patientAndroidCode = constantPatientByAndCode.getValue();
    //                String patientInfo = constantByPatientInfo.getValue();
    //
    //                model.addAttribute("patientUrl", patientUrl);
    //                model.addAttribute("patientIosName", patientIosName);
    //                model.addAttribute("patientAndroidName", patientAndroidName);
    //                model.addAttribute("patientInfo", patientInfo);
    //                model.addAttribute("PatientVersionCode", PatientVersionCode);
    //                model.addAttribute("patientIosCode", patientIosCode);
    //                model.addAttribute("patientAndroidCode", patientAndroidCode);
    //
    //                log.info("get version : patientIosName =  " + patientIosName + " patientAndroidName " + patientAndroidName + " url = " + patientUrl +
    //                        " PatientVersionCode = " + PatientVersionCode + " patientIosCode = " + patientIosCode + " patientAndroidCode = " + patientAndroidCode + " patientInfo = " + patientInfo);
    //            } else {
    //                log.info("no version");
    //            }
    //            model.addAttribute("code", -9);
    //
    //        } catch (Exception e) {
    //            e.printStackTrace();
    //            log.error(e.getMessage());
    //            model.addAttribute("code", -9);
    //            return "/common/success";
    //        }
    //
    //        return "/common/versionUpdate";
    //    }

    /**
     * 修改用户友盟推送号
     *
     * @param request
     * @param response
     * @param model
     * @param deviceToken
     * @return
     * @throws Exception
     */
    //    @RequestMapping(value = "/a/u/patient/{deviceToken}/{platform}", method = RequestMethod.PUT)
    //    public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model,
    //                                @PathVariable String deviceToken, @PathVariable String platform) throws Exception {
    //        log.info(" update user deviceToken  = " + deviceToken);
    //
    //        User user = (User) request.getAttribute("user");
    //        Long uid = user.getId();
    //
    //        try {
    //
    //            if(deviceToken.equals(user.getDeviceToken())){
    //                model.addAttribute("code", 0);
    //                return "/common/success";
    //            }else {
    //
    //                if(DataUtils.isNullOrEmpty(user.getDeviceToken())){
    //                    log.info("user no device before");
    //                }else {
    //                    Long startAt = null;
    //                    Long endAt = System.currentTimeMillis() + (7 * 24 * 60 * 60 * 1000);
    //                    log.info(" startAt = " + startAt);
    //
    //                    String result = "";
    //                    String message = "您的账号已于" + dateTime() +
    //                            "在其他设备登录。如非本人操作，则您的密码可能泄漏，请尽快修改密码，或联系客服010-62971892。";
    //                    log.info("message : " + message);
    //                    if ("android".equals(user.getOs())) {
    //                        log.info(" android ");
    //                        result = androidPushServiceImpl.pushMessaeForList("android", "notification", "unicast",
    //                                user.getDeviceToken().toString(), "下线通知", "下线通知", message, "go_app", "", "", "",
    //                                "", startAt, "", "true", endAt, "回家学习通知");
    //                        log.info(" anResult = " + result);
    //                    } else if ("ios".equals(user.getOs())) {
    //                        log.info(" ios ");
    //                        result = iosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast",
    //                                user.getDeviceToken().toString(), "下线通知", "下线通知", message, "go_app", "", "", "",
    //                                "", startAt, "", "false", endAt, "回家学习通知");
    //                        log.info(" iosResult = " + result);
    //                    } else {
    //                        log.info("user platform : " + user.getOs());
    //                    }
    //
    //                    if (DataUtils.isNotNullOrEmpty(result)) {
    //                        JSONObject jsonObject = JSONObject.fromObject(result);
    //                        if ("SUCCESS".equals((String) jsonObject.get("ret"))) {
    //                            log.info(" push success ");
    //                        } else {
    //                            log.info("fail" + jsonObject.get("data"));
    //                            JSONObject data = JSONObject.fromObject(jsonObject.get("data").toString());
    //                            log.info(" data = " + data);
    //                            log.info(" errorCode = " + data.get("error_code"));
    //                        }
    //                    } else {
    //                        log.info("user no device before");
    //                    }
    //                }
    //
    //                user.setDeviceToken(deviceToken);
    //                user.setOs(platform);
    //                userService.update(user);
    //
    //                model.addAttribute("code", 0);
    //            }
    //
    //        } catch (Throwable t) {
    //            log.error("user logout error  ");
    //            t.printStackTrace();
    //
    //        }
    //
    //        return "/common/success";
    //    }
    //
    //
    //    public String dateTime() {
    //        Long time = System.currentTimeMillis();
    //        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    //        String date = format.format(time);
    //        return date;
    //    }

}
