package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.TrainingVenues;
import com.ptteng.yi.nucleus.service.TrainingVenuesService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TrainingVenues  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TrainingVenuesController {
	private static final Log log = LogFactory.getLog(TrainingVenuesController.class);

	@Autowired
	private TrainingVenuesService trainingVenuesService;

	@Autowired
	private CookieUtil cookieUtil;

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param cityId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/venues/list", method = RequestMethod.GET)
	public String getTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long cityId) throws Exception {

		try {
			if (DataUtils.isNullOrEmpty(cityId)) {
				model.addAttribute("code", -21014);
				log.info("parameter schools is null or empty");
				return "/common/failure";
			}
			Map<String, Object> map = new HashMap<>();
			map = DynamicUtil.getVenuesList(cityId);
			List<Long> ids = trainingVenuesService.getIdsByDynamicCondition(TrainingVenues.class, map, 0,
					Integer.MAX_VALUE);
			List<TrainingVenues> trainingVenuesList = trainingVenuesService.getObjectsByIds(ids);
			log.info("get trainingVenues data is " + trainingVenuesList);

			model.addAttribute("code", 0);

			model.addAttribute("trainingVenuesList", trainingVenuesList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/trainingVenues/json/trainingVenuesListJson";
	}

}
