package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ptteng.interceptor.UserInterceptor;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.TestPlan;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.nucleus.service.TestPlanService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.xml.crypto.Data;
import java.util.Map;

/**
 * TestPlan  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TestPlanController {
    private static final Logger log = Logger.getLogger(TestPlanController.class);
    @Autowired
    TestPlanService testPlanService;

    @Autowired
    StudentsService studentsService;

    @Autowired
    CookieUtil cookieUtil;

    @Autowired
    SchoolService schoolService;

    /**
     * 获取指定时间范围的学员所在驾校的考试计划(考试计划相当于一个公告板,由驾校后台添加)
     * @param startTime
     * @param endTime
     * @param page
     * @param size
     * @param model
     * @return
     */
    @RequestMapping(value = "   /a/u/test/plan", method = RequestMethod.GET)
    public String getTestPlanByMonth(Long startTime, Long endTime, String token, Integer page, Integer size,
            Model model) {

        log.info("startTime is==" + startTime + "     token is==" + token + "  endTime is==" + endTime + "  page is=="
                + page + "  size is==" + size);


        if (!DataUtils.isNotNullOrEmpty(token)) {
            model.addAttribute("code", -2301);
            return "yi-pub-service/testPlan/json/testPlansListJson";
        }
        size = null == size ? 10 : size;
        page = ParamsUtil.calculateStartPosition(page, size);


        Map map = UserInterceptor.decodeCookie(token);
        Long studentId = null!=map&&0!=map.size()?
                (Long) map.get(UserInterceptor.USER_ID):null;

        if (null == studentId) {
            log.info("userId is==" + studentId);
            log.info("userId is null,end the request");
            model.addAttribute("code", -5001);
            return "yi-pub-service/testPlan/json/testPlansListJson";
        }
        log.info("coach id is==" + studentId);

        Students students = null;
        Long schoolId = null;
        List<Long> testPlanIds = null;
        List<TestPlan> testPlans = null;
        //若起始时间世界时间均为null则时间不参与sql过滤条件设置为null,否则new一个对象并将时间存入.
        List<Long> time = null != startTime || null != endTime ? new ArrayList<Long>(2) : null;
        if (null != time) {
            time.add(startTime);
            time.add(endTime);
        }
        Integer total = 0;
        try {
            students = studentsService.getObjectById(studentId);
            if (null == students) {
                log.info("student nonexistent,user id is==" + studentId);
                model.addAttribute("code", -5003);
                return "yi-pub-service/testPlan/json/testPlansListJson";
            }

            schoolId = students.getSchoolId();
            if (null == schoolId) {
                log.info("coach not binding school");
                model.addAttribute("code", -2300);
                return "yi-pub-service/testPlan/json/testPlansListJson";
            }

            Map<String, Object> sqlInfo = DynamicUtil.getTestPlanIdsByCondition(schoolId, time);
            if (null!=sqlInfo) {
                testPlanIds = testPlanService.getIdsByDynamicCondition(
                        TestPlan.class,
                        sqlInfo,
                        0,
                        Integer.MAX_VALUE
                );
            }
            log.info("testPlanIds  is==" + testPlanIds);

            total = null != testPlanIds ? testPlanIds.size() : 0;
            testPlanIds = ParametersUtil.splitArrayList(testPlanIds, page, page + size);
            if (null!=testPlanIds&&0!=testPlanIds.size()) {
                testPlans = testPlanService.getObjectsByIds(testPlanIds);
            }

            log.info("testPlans is==" + testPlans);
            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("data", testPlans);
        } catch (Exception e) {
            log.error("has an error,see==" + e);
            model.addAttribute("code", -100000);
        }

        return "yi-pub-service/testPlan/json/testPlansListJson";
    }

    /**
     * 查询获取考试计划
     * @param id
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/a/u/test/plan/list", method = RequestMethod.GET)
    public String getTestPlanById(Long[] id, String token, Model model, HttpServletRequest request) {

        log.info("test plan id is==" + (null != id && 0 != id.length ? Arrays.asList(id) : null));

        if (null == id || 0 == id.length) {
            log.info("id is illegal,end the request");
            model.addAttribute("code", -1001);
            return "yi-pub-service/testPlan/json/testPlanDetailJson";
        }


        if (!DataUtils.isNotNullOrEmpty(token)) {
            log.info("token is null");
            model.addAttribute("code", -2301);
            return "yi-pub-service/testPlan/json/testPlanDetailJson";
        }

        Map map = UserInterceptor.decodeCookie(token);
        Long studentId = (Long) map.get(UserInterceptor.USER_ID);
        Students students = null;
        List<Long> testPlanIds = Arrays.asList(id);
        List<TestPlan> testPlans = null;
        List<Long> schoolIds = new ArrayList<>(16);
        List<School> schools = null;
        log.info("student id is==" + studentId);
        try {

            if (null!=studentId) {
                students = studentsService.getObjectById(studentId);
            }
            log.info("student is==" + students);

            if (students == null) {
                log.info("student is nonexistent");
                model.addAttribute("code", -5003);
                return "yi-pub-service/testPlan/json/testPlanDetailJson";
            }

            testPlans = testPlanService.getObjectsByIds(testPlanIds);
            int length = null != testPlans ? testPlans.size() : 0;
            for (int i = 0; i < length; ++i) {
                schoolIds.add(testPlans.get(i).getSchoolId());
            }
            schools = 0 != schoolIds.size() ? schoolService.getObjectsByIds(schoolIds) : null;

            model.addAttribute("code", 0);
            model.addAttribute("testPlan", testPlans);
            model.addAttribute("schools", schools);
        } catch (Exception e) {
            log.error("has an error,see==" + e);
            model.addAttribute("code", -100000);
        }

        return "yi-pub-service/testPlan/json/testPlanDetailJson";
    }
}
