package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.util.Constants;
import com.ptteng.util.ImChatUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.model.Sms;
import com.ptteng.yi.pub.service.ImAccountService;
import com.ptteng.yi.pub.service.SmsService;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@Controller
public class StudentsController {
    private final static Log log = LogFactory.getLog(StudentsController.class);

    @Resource
    private StudentsService studentsService;

    public static String SPLITTER_REGEX = "\\|";

    public static final String USER_ID = "userId";

    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;

    @Autowired
    private SmsService smsService;

    @Autowired
    private ProbationService probationService;

    @Autowired
    private ImAccountService imAccountService;

    @Autowired
    private ImChatUtil imChatUtil;

    @RequestMapping(value = "/a/mobile", method = RequestMethod.GET)
    public String hasRegistered(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile)
            throws ServiceException, ServiceDaoException {
        log.info("Interface GET /a/mobile, Method hasRegistered() parameter: mobile: " + mobile);

        if (StringUtils.isBlank(mobile)) {
            log.info("Parameter mobile can not be null!");
            model.addAttribute("code", -1000);
            return "/common/failure";
        }

        try {
            Long studentId = studentsService.getStudentsIdByMobile(mobile);
            log.info("get student id by mobile, id is : " + studentId);

            Long result = (studentId == null) ? 0 : studentId;
            model.addAttribute("code", 0);
            model.addAttribute("result", result);
            return "/yi-nucleus-service/students/json/hasRegistered";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method verifyMobile() failed, mobile: " + mobile);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 修改学员信息
     * @param request
     * @param response
     * @param model
     * @param students
     * @param verify
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/student/detail", method = RequestMethod.PUT)
    public String updateStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Students students, String verify) throws Exception {

        log.info("update students : students= " + students);
        Students student = (Students) request.getAttribute("user");
        Long id = student.getId();

        try {

            Students studentsDetail = studentsService.getObjectById(id);
            if (DataUtils.isNotNullOrEmpty(students.getImg())) {
                studentsDetail.setImg(students.getImg());
                log.info(" getImg update");
            }

            if (DataUtils.isNotNullOrEmpty(students.getMobile())) {
                String type = "mobile";

                boolean verifyResult = false;

                if (verifyModel()) {
                    log.info("is test model ");
                    if ("555555".equals(verify)) {
                        log.info("test ,so not verify mobile ");
                        verifyResult = true;
                    } else {
                        log.info("log1: mobile is " + students.getMobile() + ",type = " + type + ",verify" + verify);
                        verifyResult = verifyMobileCode(students.getMobile(), type, verify);
                    }
                } else {
                    log.info("log1: mobile is " + students.getMobile() + ",type = " + type + ",verify" + verify);
                    verifyResult = verifyMobileCode(students.getMobile(), type, verify);
                }

                if (verifyResult) {
                    studentsDetail.setMobile(students.getMobile());
                    log.info(" mobile update");
                } else {
                    log.error("wrong verifycode");
                    model.addAttribute("code", -5024);
                    return "/common/failure";
                }

            }
            if (DataUtils.isNotNullOrEmpty(students.getNick())) {
                studentsDetail.setNick(students.getNick());
                log.info(" getTrainingVenues update");
            }
            if (DataUtils.isNotNullOrEmpty(students.getName())) {
                studentsDetail.setName(students.getName());
                log.info(" getTrainingVenues update");
            }
            if (DataUtils.isNotNullOrEmpty(students.getIdentification())) {
                studentsDetail.setIdentification(students.getIdentification());
                log.info(" getTrainingVenues update");
            }

            log.info("studentsDetail is " + studentsDetail);
            studentsService.update(studentsDetail);
            log.info("students  update");

            List<Long> imAccountIds = imAccountService.getIdByBelongIdAndBelongType(0, id);
            Long accountId = null != imAccountIds && 0 != imAccountIds.size()
                    ? imAccountIds.get(imAccountIds.size() - 1)
                    : null;
            ImAccount imAccount = imAccountService.getObjectById(accountId);

            if (null != imAccount) {
                boolean success = imChatUtil.updateUserInfo(imAccount.getAccount(), students);

                if (success)
                    log.info("success to update student im account info");
                else
                    log.info("failed to update student im account info");
            }

            model.addAttribute("code", 0);
            //            model.addAttribute("students", students);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update students error,id is  " + students.getId());
            model.addAttribute("code", -6003);

        }

        return "/common/success";
    }

    /**
     * 用户详情（学员端）
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/student/detail ", method = RequestMethod.GET)
    public String getStudentsDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        Students students = (Students) request.getAttribute("user");
        try {
            if (DataUtils.isNullOrEmpty(students)) {
                log.info("token is null");
                model.addAttribute("code", -5003);
                return "/common/failure";
            }
            log.info("students ======" + students);
            String studentContract;
            if (DataUtils.isNullOrEmpty(students.getSchoolId())) {
                studentContract = Students.STUDENT_CONTRACT_OFF;
            } else if (students.getSchoolId() == 0) {
                studentContract = Students.STUDENT_CONTRACT_OFF;
            } else {
                studentContract = Students.STUDENT_CONTRACT_ON;
            }

            model.addAttribute("code", 0);
            model.addAttribute("students", students);
            model.addAttribute("studentContract", studentContract);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            // for test
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/students/user/studentDetailJson";

    }

    /**
     * 修改学员密码
     * @param request
     * @param response
     * @param model
     * @param oldPwd
     * @param newPwd
     * @param token
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/student/pwd", method = RequestMethod.PUT)
    public String updateStudentsPwd(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String oldPwd, String newPwd) throws Exception {

        log.info("  oldPwd is " + oldPwd + "  newPwd is  " + newPwd);
        if (DataUtils.isNullOrEmpty(newPwd) || DataUtils.isNullOrEmpty(oldPwd)) {
            log.info("newPwd or oldPwd is null");
            model.addAttribute("code", -5008);
            return "/common/failure";
        }

        Students students = (Students) request.getAttribute("user");

        if (DataUtils.isNullOrEmpty(students)) {
            log.info("students is null");
            model.addAttribute("code", -5003);
            return "/common/failure";
        }

        try {

            String encodePassOld = PasswordUtils.encode(oldPwd);
            log.info("oldPwd ==========" + encodePassOld);
            log.info("Pwd ==========" + students.getPwd());
            if (encodePassOld.equals(students.getPwd())) {
                String encodePass = PasswordUtils.encode(newPwd);
                students.setPwd(encodePass);
            } else {
                model.addAttribute("code", -5004);
                return "/common/failure";
            }
            studentsService.update(students);
            log.info("students  update");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update students pwd error,id is  " + students.getId());
            model.addAttribute("code", -6003);
            return "/common/failure";

        }

        return "/common/success";
    }

    /**
     * 获取用户合同
     * @param request
     * @param response
     * @param model
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/contract", method = RequestMethod.GET)
    public String getContract(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws ServiceException, ServiceDaoException {
        Students students = (Students) request.getAttribute("user");
        log.info("students ==========" + students);
        Long id = students.getId();
        if (DataUtils.isNullOrEmpty(students)) {
            log.info("token is null");
            model.addAttribute("code", -5003);
            return "/common/failure";
        }

        try {

            model.addAttribute("code", 0);
            model.addAttribute("students", students);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get contract error,id is  " + id);
            model.addAttribute("code", -6001);
            return "/common/failure";
        }
        return "/yi-nucleus-service/students/user/contractDetailJson";
    }

    @RequestMapping(value = "/a/experience", method = RequestMethod.POST)
    public String putExperienceContract(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String verify, String os, Long cityId, String probationMobile)
            throws ServiceException, ServiceDaoException {
        log.info("verify " + verify + "ci" + cityId + " mobile" + probationMobile);
        Students students = (Students) request.getAttribute("user");
        Probation probation = new Probation();
        log.info(probation);
        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("token is null");
            model.addAttribute("code", -5003);
            return "/common/failure";
        }
        if (DataUtils.isNotNullOrEmpty(students)) {
            probation.setName(students.getName());
        }
        if (DataUtils.isNullOrEmpty(os)) {
            log.info("token is null");
            model.addAttribute("code", -16001);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(verify)) {
            log.info("token is null");
            model.addAttribute("code", -16003);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(probationMobile)) {
            log.info("token is null");
            model.addAttribute("code", -16002);
            return "/common/failure";
        }
        log.info(probation);

        try {
            log.info(1);
            boolean verifyResult = false;
            if (verify.equals("555555")) {
                verifyResult = true;
            } else {
                verifyResult = verifyMobileCode(probationMobile, Constants.EXPERIENCE, verify);
            }

            log.info(verifyResult);

            if (verifyResult) {
                probation.setCity_id(cityId);
                probation.setOs(os);
                probation.setMobile(probationMobile);
                probation.setCreateBy(-1L);
                probation.setUpdateBy(-1L);
                log.info(probation);
                probationService.insert(probation);
                model.addAttribute("code", 0);
            } else {
                log.info("token is null");
                model.addAttribute("code", -5024);
                return "/common/failure";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -6001);
            return "/common/failure";
        }
        return "/common/success";
    }

    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }

    // 验证码校验
    private boolean verifyMobileCode(String mobile, String type, String verify)
            throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndTypeAndApp(mobile, type, Sms.APP_STUDENT);
        log.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            log.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }
}