package com.ptteng.controller;

import java.util.*;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.model.SignsNumber;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.SubjectPractice;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.Sign;
import com.ptteng.yi.nucleus.service.SignService;

/**
 * 考点和标志相关接口
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
@Controller
public class SignController {
    private static final Log log = LogFactory.getLog(SignController.class);

    @Resource
    private SignService signService;

    @Resource
    private SubjectPracticeService subjectPracticeService;

    @Resource
    private String[] trafficSigns;

    @Resource
    private String[] carSigns;

    /**
     * 统计交通/车内标志数量接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/sign/record", method = RequestMethod.GET)
    public String getSignRecord(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {
        log.info("Interface GET /a/u/sign/record, Method getSignRecord() begin----------------------");

        try {

            Integer total = 0;
            log.info("trafficSigns is " + Arrays.toString(trafficSigns));
            Map<String, Integer> trafficMap = signService.countNumberOfSigns(Sign.TRAFFIC_SIGNS, trafficSigns);
            log.info("trafficMap =======" + trafficMap);
            Map<String, Integer> carMap = signService.countNumberOfSigns(Sign.CAR_SIGNS, carSigns);
            log.info("get trafficMap, carMap size is : " + trafficMap + ", " + carMap);

            //获取图片链接类型对应url
            Map<String, String> trafficTypeMap = urlOfSigns(trafficSigns, 1);
            Map<String, String> carTypeMap = urlOfSigns(carSigns, 2);

            List<SignsNumber> signsNumberList = SignsNumber.convertMapToSignsNumberList(trafficMap, Sign.TRAFFIC_SIGNS,
                    new ArrayList<SignsNumber>(), trafficTypeMap);
            signsNumberList = SignsNumber.convertMapToSignsNumberList(carMap, Sign.CAR_SIGNS, signsNumberList,
                    carTypeMap);
            log.info("get signsNumberList data, list size is : " + signsNumberList.size());

            total = signService.countSignIdsByType(1);
            log.info("total is " + total);
            model.addAttribute("total", total);
            model.addAttribute("code", 0);
            model.addAttribute("signsNumberList", signsNumberList);
            return "/yi-nucleus-service/sign/json/signsNumberList";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSignRecord() failed ----------------------");
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 查询考点/交通标志/车内标志列表接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/sign/list", method = RequestMethod.GET)
    public String getSignsList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type,
            String signType, Integer page, Integer size) throws Exception {

        log.info("Interface GET /a/u/sign/list, Method getSignsList() parameters: type: " + type + ", signType: "
                + signType);
        int actualSize = ParamsUtil.calculateActualSize(size);
        int startPosition = ParamsUtil.calculateStartPosition(page, actualSize);
        log.info("page: " + startPosition + ", size: " + actualSize);

        int validateResult = ParamsUtil.checkParamsOfGetSignsList(type, signType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            List<Sign> signList = null;
            Integer total = 0;
            if (type.equals(Sign.EXAM_POINT)) {
                signList = signService.getSignListByType(type, startPosition, actualSize);
                total = signService.countSignIdsByType(type);
            } else {
                signList = signService.getSignListByTypeAndSignType(type, signType, startPosition, actualSize);
                total = signService.countSignIdsByTypeAndSignType(type, signType);
            }
            log.info("get sign data list, list size is : " + signList.size());
            log.info("count sign total, total is : " + total);

            model.addAttribute("code", 0);
            model.addAttribute("size", actualSize);
            model.addAttribute("total", total);
            String[] signsArray = { "specialList", "signList", "signList" };
            model.addAttribute(signsArray[type], signList);
            return "/yi-nucleus-service/sign/json/signListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSignsList() failed, parameters: type: " + type + ", signType: " + signType + "page: "
                    + page + ", size: " + size);
            model.addAttribute("code", -1);
            return "/common/success";
        }
    }

    /**
     * 查询标志详情接口
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/sign/{id}", method = RequestMethod.GET)
    public String getSignDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("Interface GET /a/u/sign/{id}, Method getSignDetail() parameter: id is : " + id);

        try {
            Sign sign = signService.getObjectById(id);
            log.info("get sign data, sign is : " + sign);
            if (DataUtils.isNullOrEmpty(sign)) {
                log.info("Can not find sign by id, id is : " + id);
                model.addAttribute("code", -1001);
                return "/common/failure";
            }

            model.addAttribute("code", 0);
            model.addAttribute("sign", sign);
            return "/yi-nucleus-service/sign/json/signDetailJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSignDetail() failed, parameter: id is : " + id);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 查询考点详情接口
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/special", method = RequestMethod.GET)
    public String getExaminationPoint(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
            String title, Integer subjectType) throws Exception {
        log.info("Interface GET /a/u/special, Method getExaminationPoint() parameters, id: " + id + ", title: " + title
                + ", subjectType: " + subjectType);

        int validateResult = ParamsUtil.checkParamsOfGetExaminationPoint(id, title, subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            if (DataUtils.isNotNullOrEmpty(title)) {
                id = signService.getSignIdByTitle(title);
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("Can not find sign by title, title is : " + title);
                    model.addAttribute("code", -1001);
                    return "/common/failure";
                }
                log.info("get sign id by title, id is : " + id);
            }

            Sign sign = signService.getObjectById(id);
            log.info("get sign data by id, id is : " + sign.getId());

            String special = sign.getTitle();
            Map<String, Object> countSpecialPracticeIdsMap = DynamicUtil.getSpecialPracticeParams(subjectType, special,
                    true);
            Long total = subjectPracticeService
                    .getIdsByDynamicCondition(SubjectPractice.class, countSpecialPracticeIdsMap, 0, Integer.MAX_VALUE)
                    .get(0);
            log.info("count special practice total, total is : " + total);

            model.addAttribute("code", 0);
            model.addAttribute("sign", sign);
            model.addAttribute("total", total);
            return "/yi-nucleus-service/sign/json/signDetailJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getExaminationPoint() failed, parameters, id: " + id + ", title: " + title
                    + ", subjectType: " + subjectType);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    private String getSignTypeUrlBySignType(String signType, Integer type)
            throws ServiceException, ServiceDaoException {
        log.info("signType is " + signType);

        List signIds = signService.getSignIdsByTypeAndSignType(type, signType, 0, Integer.MAX_VALUE);

        Sign sign = signService.getObjectById(Long.valueOf(String.valueOf(signIds.get(0))));

        String signTypeUrl = sign.getImage();

        return signTypeUrl;
    }

    private Map<String, String> urlOfSigns(String[] signTypes, Integer type)
            throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" signTypes array is : " + Arrays.toString(signTypes));
        }

        Map<String, String> map = new HashMap<>();

        try {
            for (int i = 0; i < signTypes.length; i++) {
                String url = getSignTypeUrlBySignType(signTypes[i], type);
                map.put(signTypes[i], url);
            }
        } catch (Throwable t) {
            log.error(" get url is  wrong by signType  : " + Arrays.toString(signTypes));
            log.error(t.getMessage());
            t.printStackTrace();

        }

        if (log.isInfoEnabled()) {
            log.info(" get urlOfSigns is success , map size is : " + map.size());
        }
        return map;
    }

}
