package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.Center;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.service.CenterService;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.ptteng.yi.pub.model.Cities;
import com.ptteng.yi.pub.service.CitiesService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * School  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SchoolController {
	private static final Log log = LogFactory.getLog(SchoolController.class);

	@Autowired
	private SchoolService schoolService;

	@Autowired
	private CenterService centerService;
	@Autowired
	private CitiesService citiesService;

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	//	@RequestMapping(value = "/a/u/school/list ", method = RequestMethod.GET)
	//	public String getSchoolIdsByStatusOrderByCreateByJsonList(HttpServletRequest request, HttpServletResponse response,
	//			ModelMap model, Integer page, Integer size) throws Exception {
	//
	//		if (page == null) {
	//			page = 1;
	//		}
	//		if (size == null) {
	//			size = 10;
	//		}
	//		int start = (page - 1) * size;
	//		if (start < 0) {
	//			start = 0;
	//		}
	//
	//		log.info("pageList : page= " + start + " , size=" + size);
	//
	//		try {
	//
	//			List<Long> ids = schoolService.getSchoolIdsByStatusOrderByCreateAt(0, start, size);
	//			log.info(ids);
	//			log.info("get countSchoolIdsByStatusOrderByCreateBy size is " + ids.size());
	//
	//			List<School> schoolList = schoolService.getObjectsByIds(ids);
	//			log.info("get school data is " + schoolList.size());
	//
	//			Integer total = schoolService.countSchoolIdsByStatusOrderByCreateAt(0);
	//			log.info("get school count is " + total);
	//
	//			model.addAttribute("code", 0);
	//			model.addAttribute("page", page);
	//			model.addAttribute("size", size);
	//
	//			model.addAttribute("total", total);
	//
	//			model.addAttribute("schoolList", schoolList);
	//
	//		} catch (Throwable t) {
	//			t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("get school list error,page is  " + start + " , size " + size);
	//			// for test
	//			model.addAttribute("code", -100000);
	//		}
	//
	//		return "/yi-nucleus-service/school/json/schoolListJson";
	//	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/school/{id}", method = RequestMethod.GET)
	public String getSchoolJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			School school = schoolService.getObjectById(id);
			log.info("get school data is " + school);

			model.addAttribute("code", 0);

			model.addAttribute("school", school);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get school error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/school/json/schoolDetailJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/city/list", method = RequestMethod.GET)
	public String geCityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {
		try {
			List<Long> ids = new ArrayList<>();
			List<Long> cids = new ArrayList<>();
			Map<String, Object> map = new HashMap<>();
			Map<String, Object> cmap = new HashMap<>();
			map = DynamicUtil.geCenterByCityIdAndStatus(null, 1);
			ids = centerService.getIdsByDynamicCondition(Center.class, map, 0, Integer.MAX_VALUE);
			cmap = DynamicUtil.getCity();
			cids = citiesService.getIdsByDynamicCondition(Cities.class, cmap, 0, Integer.MAX_VALUE);
			List<Center> centerList = centerService.getObjectsByIds(ids);
			List<Cities> cityList = citiesService.getObjectsByIds(cids);
			for (Center center : centerList) {
				for (Cities cities : cityList) {
					if ((center.getCityId()).equals(cities.getCityid())) {
						center.setName(cities.getCity());
						log.info(center);
					}
				}
			}
			model.addAttribute("code", 0);
			model.addAttribute("centerList", centerList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/center/json/centerListJson";
	}

}
