package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ListUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Card  crud
 * 
 * @author wangmeng
 * @Date 2017-12-20 13:43
 * 
 */
@Controller
public class CardController {
    private static final Log log = LogFactory.getLog(CardController.class);

    @Autowired
    private CardService cardService;

    @Autowired
    private CardTypeService cardTypeService;

    @Autowired
    private DrivingClassService drivingClassService;

    @Autowired
    private SchoolService schoolService;

    /**
     * 查看我的卡券(已拥有的)
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/card/list", method = RequestMethod.GET)
    public String getCardJson(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info("GET request url : /a/u/card/list, no parameter");

        Students student = (Students) request.getAttribute("user");
        Long sid = student.getId();

        log.info("get student id : " + sid);

        try {
            List<Long> cardIds = cardService.getCardIdsByOwnerIdAndStatus(sid, Card.STATUS_UNUSED, 0,
                    Integer.MAX_VALUE);

            log.info("get student card id list : " + cardIds);

            if (CollectionUtils.isEmpty(cardIds)) {
                model.addAttribute("cardList", new ArrayList());
                model.addAttribute("total", 0);
            } else {
                List<Card> cardList = cardService.getObjectsByIds(cardIds);
                log.info("get student card list size : " + cardList.size());

                //封装需要泛型通配加反射，先搁置，用基本方法实现

                List<Long> tids = MyListUtil.getFieldValueListFromModelList(cardList, false,
                        Card.class.getDeclaredField("tid"));
                List<CardType> cardTypeList = cardTypeService.getObjectsByIds(tids);

                List<String> titleList = MyListUtil.getFieldValueListFromModelList(cardTypeList, false,
                        CardType.class.getDeclaredField("title"));
                Map<Long, String> cidTitle = ListUtil.convert2Map(cardIds, titleList);

                List<String> descriptionList = MyListUtil.getFieldValueListFromModelList(cardTypeList, false,
                        CardType.class.getDeclaredField("description"));
                Map<Long, String> cidDescription = ListUtil.convert2Map(cardIds, descriptionList);

                List<String> valueList = MyListUtil.getFieldValueListFromModelList(cardTypeList, false,
                        CardType.class.getDeclaredField("value"));
                Map<Long, String> cidValue = ListUtil.convert2Map(cardIds, valueList);

                //处理可用驾校和可用班型数据，先合cardList中并所有的驾校id和班型id，一次性调service取出来，避免for循环调service
                //然后再根据每个card可用的驾校和班型去结果list中取数据

                //存储所有可用驾校和班型id
                List<Long> allSchoolIds = new ArrayList<>();
                List<Long> allClassIds = new ArrayList<>();

                //存储card id和对应的驾校id、班型id
                Map<Long, List<Long>> cidSchlIdLIST = new HashMap<>();
                Map<Long, List<Long>> cidClassIdList = new HashMap<>();

                //处理cardList
                for (int i = 0; i < cardList.size(); i++) {
                    Card card = cardList.get(i);
                    String school = card.getSchools();
                    log.info("String school : " + school);
                    String clas = card.getClasses();
                    log.info("String class : " + clas);

                    String[] schools = school.substring(1, school.length() - 1).split(",");
                    String[] classes = clas.substring(1, clas.length() - 1).split(",");

                    List<Long> schoolsIds = new ArrayList<>();
                    List<Long> classesIds = new ArrayList<>();

                    for (int j = 0; j < schools.length; j++) {
                        schoolsIds.add(Long.parseLong(schools[j]));

                        if (allSchoolIds.indexOf(Long.parseLong(schools[j])) == -1) {
                            allSchoolIds.add(Long.parseLong(schools[j]));
                        }
                    }

                    for (int k = 0; k < classes.length; k++) {
                        classesIds.add(Long.parseLong(classes[k]));

                        if (allClassIds.indexOf(Long.parseLong(classes[k])) == -1) {
                            allClassIds.add(Long.parseLong(classes[k]));
                        }
                    }

                    cidSchlIdLIST.put(card.getId(), schoolsIds);
                    cidClassIdList.put(card.getId(), classesIds);
                }

                //一次性取出所有可用驾校和班型
                List<School> allSchoolList = schoolService.getObjectsByIds(allSchoolIds);
                List<DrivingClass> allClassList = drivingClassService.getObjectsByIds(allClassIds);

                //构建card id 和对应的驾校、班型list
                Map<Long, List<School>> cidScholList = new HashMap<>();
                Map<Long, List<DrivingClass>> cidDrivingClassList = new HashMap<>();

                for (int m = 0; m < cardList.size(); m++) {

                    List<School> schoolList = new ArrayList<>();
                    List<DrivingClass> classList = new ArrayList<>();

                    Card card1 = cardList.get(m);

                    List<Long> schoolIds = cidSchlIdLIST.get(card1.getId());

                    for (int n = 0; n < allSchoolList.size(); n++) {
                        School school = allSchoolList.get(n);

                        if (schoolIds.indexOf(school.getId()) != -1) {
                            schoolList.add(school);
                        }
                    }

                    cidScholList.put(card1.getId(), schoolList);

                    List<Long> classIds = cidClassIdList.get(card1.getId());

                    for (int q = 0; q < allClassList.size(); q++) {
                        DrivingClass cla = allClassList.get(q);

                        if (classIds.indexOf(cla.getId()) != -1) {
                            classList.add(cla);
                        }
                    }
                    cidDrivingClassList.put(card1.getId(), classList);
                }

                model.addAttribute("total", cardList.size());
                model.addAttribute("cardList", cardList);
                model.addAttribute("cidTitle", cidTitle);
                model.addAttribute("cidDescription", cidDescription);
                model.addAttribute("cidValue", cidValue);
                model.addAttribute("cidScholList", cidScholList);
                model.addAttribute("cidDrivingClassList", cidDrivingClassList);
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get student's card error, id is  " + sid);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/card/json/cardListJson";
    }

    /**
     * 兑换卡券
     * @param request
     * @param response
     * @param model
     * @param pwd 兑换码
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/card", method = RequestMethod.POST)
    public String exchangeCardJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd)
            throws Exception {

        log.info("GET request url : /a/u/card, get parameter pwd : " + pwd);

        if (StringUtils.isEmpty(pwd)) {
            log.info("parameter pwd is null or empty");
            model.addAttribute("code", -11001);
            return "/common/failure";
        }

        Students student = (Students) request.getAttribute("user");
        Long sid = student.getId();

        log.info("get student id : " + sid);

        try {
            Map<String, Object> map = DynamicUtil.getCardListParams(pwd, Card.STATUS_UNEXCHANGED,
                    System.currentTimeMillis(), false);
            log.info("query card map : " + map);

            List<Long> cardIds = cardService.getIdsByDynamicCondition(Card.class, map, 0, Integer.MAX_VALUE);
            log.info(cardIds);
            if (CollectionUtils.isEmpty(cardIds)) {
                log.info("no this card");
                model.addAttribute("code", -11000);
                return "/common/failure";
            } else {
                Card card = cardService.getObjectById(cardIds.get(0));
                log.info("get card data is :" + card);

                card.setStatus(Card.STATUS_UNUSED);
                card.setExchangeAt(System.currentTimeMillis());
                card.setOwnerId(sid);
                card.setOwnerMobile(student.getMobile());

                if (!StringUtils.isEmpty(student.getName())) {
                    card.setOwnerName(student.getName());
                } else {
                    card.setOwnerName(Card.STRING_NULL_VALUE);
                }

                boolean result = cardService.update(card);
                model.addAttribute("code", 0);
                log.info("update card result: " + result);

            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get card error, student id is  " + sid);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

}
