package com.ptteng.util.httpUtils.httpRequestUtils;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

import java.util.*;

/**
 * @author himly
 */

public class HttpReqUtil {
    private static final Logger log = Logger.getLogger(HttpReqUtil.class);
    private static final CloseableHttpClient httpClient = HttpClients.createDefault();

    /**
     * 发送post请求
     *
     * @param url 请求地址
     * @param headers 头部信息,key为参数名,value为值
     * @param values 请求参数 key为参数名,value为值
     * @return
     */
    public static CloseableHttpResponse sendPost(String url, Map<String,String> headers, Map<String,String> values) throws Exception{

        log.info(
                "url is=="+url
                +"  headers is=="+(null!=headers&&0!=headers.size()?Arrays.asList(headers):"null or size is zero")
                +"  values is=="+(null!=values&&0!=values.size()?Arrays.asList(values):"null or size is zero")
        );

        if (null==headers||null==values||null==url) {
            log.info("args is null");
            throw new Exception("args can not be null");
        }
        if (url.isEmpty()) {
            log.info("url is empty");
            throw new Exception("url can not be empty");
        }

//        //解决hostname in certificate did,n't match
//        SSLSocketFactory.getSocketFactory().setHostnameVerifier(new AllowAllHostnameVerifier());

        HttpPost httpPost = new HttpPost(url);
        Set<String> keys = headers.keySet();
        String value = null;
        for (String key:keys) {
            value = headers.get(key);
            if (null==value)
                continue;

            httpPost.addHeader(key,value);
        }

        List<NameValuePair> nameValuePairs = new ArrayList<>(16);
        keys.clear();
        value = null;
        keys = values.keySet();
        for (String key:keys) {
            value = values.get(key);
            if (null==value)
                continue;

            nameValuePairs.add(new BasicNameValuePair(key,value));
        }
        httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs,"utf-8"));



        return httpClient.execute(httpPost);
    }
}
