package com.ptteng.util;

import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;

public class ParamsUtil {
    private static final Log log = LogFactory.getLog(ParamsUtil.class);

    public static final Integer VALIDATE_RESULT_SUCCESS = 0;

    /**
     * 根据入参size计算实际获取数据的个数
     */
    public static Integer calculateActualSize(Integer size) {
        Integer result = size;

        if (result == null || result <= 0) {
            result = 10;
        }
        return result;
    }

    /**
     * 计算根据传入的page和实际的size计算分页的起始页
     */
    public static int calculateStartPosition(Integer page, Integer size) {
        if (page == null || page <= 0) {
            page = 1;
        }
        int start = (page - 1) * calculateActualSize(size);
        if (start < 0) {
            start = 0;
        }

        return start;
    }

    /**
     * 判断传入的参数是否为空
     */
    public static int isNullOrEmpty(Object... params) {
        for (int i = 0; i < params.length; i++) {
            if (DataUtils.isNullOrEmpty(params[i])) {
                return i;
            }
        }
        return -1;
    }

    /**
     * 校验getSettlementList()方法参数
     */
    public static int checkParametersOfGetSettlementList(Long schoolId, Integer status, Long cityId) {
        if (DataUtils.isNullOrEmpty(schoolId) && DataUtils.isNullOrEmpty(cityId)) {
            log.info("Parameter schoolId and cityId can not be null at the same time, " + "schoolId, cityId: "
                    + schoolId + ", " + cityId);
            return -1000;
        }

        if (DataUtils.isNotNullOrEmpty(schoolId) && DataUtils.isNotNullOrEmpty(cityId)) {
            log.info("Parameter schoolId and cityId can not have value at the same time, " + "schoolId, cityId: "
                    + schoolId + ", " + cityId);
            return -1001;
        }

        if (DataUtils.isNotNullOrEmpty(status) && (status != 0 && status != 1)) {
            log.info("Error value of parameter status, status is : " + status);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验getRecordList()方法参数
     */
    public static int checkParametersOfGetRecordList(Long schoolId, Integer status) {
        if (DataUtils.isNullOrEmpty(schoolId)) {
            log.info("Parameter schoolId can not be null, schoolId is : " + schoolId);
            return -1000;
        }
        if (DataUtils.isNotNullOrEmpty(status) && (status < 0 || status > 2)) {
            log.info("Error value of parameter status, status is : " + status);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验addWithdrawOrder()方法参数
     */
    public static int checkParametersOfAddWithdrawOrder(Long schoolId, BigDecimal withdrawAmount, Long[] idArray) {
        String[] paramNames = new String[] { "schoolId", "withdrawAmount", "idArray" };
        int result = ParamsUtil.isNullOrEmpty(schoolId, withdrawAmount, idArray);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        return 0;
    }

    /**
     * 校验dealWithdrawOrder()方法参数
     */
    public static int checkParametersOfDealWithdrawOrder(Integer operate, Long[] idArray) {
        String[] paramNames = new String[] { "operate", "idArray" };
        int result = ParamsUtil.isNullOrEmpty(operate, idArray);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        if (operate < 0 || operate > 1) {
            log.info("Error value of parameter operate, operate is : " + operate);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验getEnrollmentList()方法参数
     */
    public static int checkParametersOfGetEnrollmentList(String platform, Long schoolId, Integer type, Integer status) {
        if (DataUtils.isNullOrEmpty(platform)) {
            log.info("Parameter platform can not be null, platform: " + platform);
            return -1000;
        }
        if (!platform.equals("school") && !platform.equals("center")) {
            log.info("Error value of parameter platform, platform: " + platform);
            return -1001;
        }
        if (platform.equals("school") && DataUtils.isNullOrEmpty(schoolId)) {
            log.info("Parameter schoolId can not be null when platform=school, platform: " + platform + ", schoolId: "
                    + schoolId);
            return -1001;
        }
        if (DataUtils.isNotNullOrEmpty(type) && (type < 0 || type > 1)) {
            log.info("Error value of parameter type, type: " + type);
            return -1001;
        }
        if (DataUtils.isNotNullOrEmpty(status) && platform.equals("school") && (status < 0 || status > 2)) {
            log.info("Error value of parameter status, status: " + status);
            return -1001;
        }
        if (DataUtils.isNotNullOrEmpty(status) && platform.equals("center") && (status < 0 || status > 1)) {
            log.info("Error value of parameter status, status: " + status);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验getWithdrawalList()方法参数
     */
    public static int checkParametersOfGetWithdrawalList(Integer status) {
        if (DataUtils.isNotNullOrEmpty(status) && (status < 0 || status > 2)) {
            log.info("Parameter status can not be null");
            return -1001;
        }

        return 0;
    }

    /**
     * 校验GetFinanceRecordDetailList()方法参数
     */
    public static int checkParametersOfGetFinanceRecordDetailList(Long id, Integer type) {

        String[] paramNames = new String[] { "id", "type" };
        int result = ParamsUtil.isNullOrEmpty(id, type);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        if (type < 0 || type > 3) {
            log.info("Error value of parameter type, type: " + type);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验GetSchoolEnrollmentIdList()方法参数
     */
    public static int checkParametersOfGetSchoolEnrollmentIdList(Long schoolId, Integer withdrawStatus) {

        String[] paramNames = new String[] { "schoolId", "withdrawStatus" };
        int result = ParamsUtil.isNullOrEmpty(schoolId, withdrawStatus);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        if (withdrawStatus < 0 || withdrawStatus > 2) {
            log.info("Error value of parameter withdrawStatus, withdrawStatus: " + withdrawStatus);
            return -1001;
        }
        return 0;
    }

    /**
     * 校验GetFinanceOfCenterTotal()参数
     */
    public static int checkParametersOfGetFinanceOfCenter(Integer type, Integer status, Long cityId) {
        if (DataUtils.isNotNullOrEmpty(type) && (type < 0 || type > 1)) {
            log.info("Error value of parameter type, type is : " + type);
            return -1001;
        }
        if (DataUtils.isNotNullOrEmpty(status) && (status < 0 || status > 1)) {
            log.info("Error value of parameter status, status is : " + status);
            return -1001;
        }

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("Parameter cityId can not be null");
            return -1000;
        }
        return 0;
    }

    /**
     * 校验getSubjectOperationList参数
     */
    public static int checkParametersOfGetSubjectOperationList(Integer subjectType, Integer type, Integer status) {
        if (DataUtils.isNullOrEmpty(subjectType)) {
            log.info("Parameter subjectType can not be null");
            return -1000;
        }

        if (subjectType != 2 && subjectType != 3) {
            log.info("Error value of parameter subjectType, subjectType is : " + subjectType);
            return -1001;
        }

        if (DataUtils.isNotNullOrEmpty(type) && (type < 0 || type > 1)) {
            log.info("Error value of parameter type, type is : " + type);
            return -1001;
        }

        if (DataUtils.isNotNullOrEmpty(status) && (status < 0 || status > 1)) {
            log.info("Error value of paramter status, status is :" + status);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验modifySubjectOperationStatus参数
     */
    public static int checkParametersOfModifySubjectOperationStatus(Long id, Integer operate) {

        if (id <= 0) {
            log.info("Error value of parameter id, id is: " + id);
            return -1001;
        }
        if (DataUtils.isNullOrEmpty(operate)) {
            log.info("Parameter operate can not be null");
            return -1000;
        }
        if (operate != 0 && operate != 1) {
            log.info("Error value of parameter operate, operate is : " + operate);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验addSubjectOperation和updateSubjectOperation参数
     */
    public static int checkParametersOfModifySubjectOperation(String title, String cover, String content,
            Integer subjectType, Integer type) {

        String[] paramNames = { "title", "cover", "content", "subjectType", "type" };
        int result = ParamsUtil.isNullOrEmpty(title, cover, content, subjectType, type);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        if (subjectType != 2 && subjectType != 3) {
            log.info("Error value of parameter subjectType, subjectType is: " + subjectType);
            return -1001;
        }
        if (type != 0 && type != 1) {
            log.info("Error value of parameter type, type is: " + type);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验getSubjectBroadcastList参数
     */
    public static int checkParametersOfGetSubjectBroadcastList(Integer subjectType, Integer type) {
        if (DataUtils.isNullOrEmpty(subjectType)) {
            log.info("Parameter subjectType can not be null");
            return -1000;
        }

        if (subjectType != 2 && subjectType != 3) {
            log.info("Error value of parameter subjectType, subjectType is : " + subjectType);
            return -1001;
        }

        if (DataUtils.isNotNullOrEmpty(type) && (type != 0 && type != 1)) {
            log.info("Error value of parameter type, type is :" + type);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验AddSubjectBroadcast和 updateSubjectBroadcast参数
     */
    public static int checkParametersOfModifySubjectBroadcast(String icon, String title, String voiceUrl,
            Integer subjectType, Integer type) {
        String[] paramNames = { "icon", "title", "voiceUrl", "subjectType", "type" };
        int result = ParamsUtil.isNullOrEmpty(icon, title, voiceUrl, subjectType, type);
        if (result >= 0) {
            log.info("Parameter " + paramNames[result] + " can not be null");
            return -1000;
        }

        if (subjectType != 2 && subjectType != 3) {
            log.info("Error value parameter of subjectType, subjectType is :" + subjectType);
            return -1001;
        }

        if (subjectType == 2 && type != -1) {
            log.info("Error value parameter of type when subjectType=2, type is: " + type);
            return -1001;
        }

        if (subjectType == 3 && (type != 0 && type != 1)) {
            log.info("Error value parameter of type when subjectType=3, type is: " + type);
            return -1001;
        }

        return 0;
    }

    /**
     * 校验sortSubject参数
     */
    public static int checkParametersOfSortSubject(Integer type, Long[] ids) {
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("Parameter type can not be null");
            return -1000;
        }

        if (type != 0 && type != 1) {
            log.info("Error value of parameter type, type is : " + type);
            return -1001;
        }

        if ((ids == null) || (ids.length == 0)) {
            log.info("Parameter ids can not be null or empty");
            return -1000;
        }

        return 0;
    }

    /**
     * 增加消息接口
     */
    public static int checkParametersOfAddUserMessage(Integer messageType,  Integer target,
            String content, Integer noticeStatus, Integer pushType, Long[] coachUids, Long[] studentUids,
            Integer targetSend, Integer progress, Integer examSubject, Long examTime) {
        if (studentUids.length == 0) {
            log.info("one of parameters is null");
            return -1000;
        }

        if (ParamsUtil.isNullOrEmpty(messageType,  target, content, noticeStatus, pushType, targetSend
                ) != -1) {
            log.info("one of parameters is null");
            return -1000;
        }
        //        判断发送人群和uid的空值
        if ((target == 1 && ParamsUtil.isNullOrEmpty(studentUids) != -1)) {
            log.info("one of parameters is null");
            return -1000;
        }
        if ((noticeStatus == 2 && (DataUtils.isNullOrEmpty(pushType) == true)
                || (noticeStatus == 1 && DataUtils.isNullOrEmpty(pushType)) == true)) {
            log.info("Parameter id and title can not be null at the same time");
            return -1001;
        }
        if (messageType == 1) {
            if ((DataUtils.isNullOrEmpty(examSubject) || DataUtils.isNullOrEmpty(examTime))) {
                log.info("If the test information, examTime and examSubject can not be null  ");
                return -1001;
            }
            if (examSubject != 0 && examSubject != 1 && examSubject != 2 && examSubject != 3 &&examSubject != 4 && examSubject != 5
                    && examSubject != 6) {
                log.info("Error value of parameter examSubject, examSubject is : " + examSubject);
                return -1001;
            }
        } else if (messageType == 2) {
            if ((DataUtils.isNullOrEmpty(examSubject) == false || DataUtils.isNullOrEmpty(examTime) == false)) {
                log.info("If the system information, examTime and examSubject must be null  ");
                return -1001;
            }
        }
        if (messageType != 1 && messageType != 2) {
            log.info("Error value of parameter messageType, messageType is : " + messageType);
            return -1001;
        }
        if (target != 1 && target != 2 && target != 3) {
            log.info("Error value of parameter target, target is : " + target);
            return -1001;
        }
        if (noticeStatus != 1 && noticeStatus != 2) {
            log.info("Error value of parameter noticeStatus, noticeStatus is : " + noticeStatus);
            return -1001;
        }
        if (pushType != 1 && pushType != 2 && pushType != 3) {
            log.info("Error value of parameter pushType, pushType is : " + pushType);
            return -1001;
        }
        if (targetSend != 1 && targetSend != 2) {
            log.info("Error value of parameter targetSend, targetSend is : " + targetSend);
            return -1001;
        }
        if (DataUtils.isNotNullOrEmpty(progress)){
        //改了
        if (progress != 0 && progress != 1 && progress != 2 && progress != 3 && progress != 4 && progress != 5 && progress != 6 && progress != 7 ) {
            log.info("Error value of parameter progress, progress is : " + progress);
            return -1001;
        }
        }

        return 0;
    }

    /**
     * 校验sortSubject参数
     */
    public static int checkParametersOfUpdateVersion(String versionCode, Integer versionNumber, String url,
            Integer isForceUpdate, String summary) {
        if (ParamsUtil.isNullOrEmpty(versionCode, versionNumber, url, isForceUpdate, summary) != -1) {
            log.info("one of the params is null");
            return -1000;
        }

        if (isForceUpdate != 0 && isForceUpdate != 1) {
            log.info("Error value of parameter isForceUpdate, isForceUpdate is : " + isForceUpdate);
            return -1001;
        }

        return 0;
    }
}
