package com.ptteng.util;

import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author himly
 */
public class ParametersUtil {
    private static final Logger log = Logger.getLogger(ParametersUtil.class);

    /**
     * 所有参数均为null
     * @param objects
     * @return
     */
    public static boolean allParamtersIsNull(Object... objects) {

        for (Object o : objects) {
            if (o != null) {
                return false;
            }
        }

        return true;
    }

    /**
     * 所有参数均不为null
     * @param objects
     * @return
     */
    public static boolean allParametersIsNotNull(Object... objects) {

        for (Object o : objects) {
            if (o == null) {
                return false;
            }
        }

        return true;
    }

    public static boolean allParametersIsNotEmpty(String... strings) {

        for (String st : strings) {
            if (st == null || st.equals("")) {
                return false;
            }
        }

        return true;
    }

    public static boolean isMobile(String mobile) {

        if (null == mobile) {
            return false;
        }

        String regExp = "^((13[0-9])|(15[^4])|(18[0-9])|(17[0-9])|(147))\\d{8}$";
        Pattern p = Pattern.compile(regExp);

        Matcher m = p.matcher(mobile);

        return m.find();
    }

    //分割
    public static List<Long> splitArrayList(List list, int start, int end) {
        List<Long> newList = new ArrayList<>();
        int length = list.size();

        end = length >= end ? end : length;

        for (int i = 0; i < end; ++i) {
            if (i >= start) {
                newList.add((Long) list.get(i));
            }
        }

        return newList;
    }

    public static boolean hasOneParameterIsNotNullAndEmpty(String... strings) {

        for (String st : strings) {
            if (st != null && !st.equals(""))
                return true;
        }

        return false;
    }

    public static boolean parameterIsExistentArray(Integer parameter, Integer[] array) throws Exception{

        log.info("parameter is "+parameter+"    array is=="+(null!=array&&0!=array.length?array:"is null or empty"));

        if (null==parameter||null==array) {
            log.info("the args is null");
            throw new Exception("args can not be null");
        }

        for (int i = 0; i < array.length; ++i) {
            if (array[i].equals(parameter))
                return true;
        }

        return false;
    }
}
