package com.ptteng.util;

import com.ptteng.common.yi.model.Manager;
import com.ptteng.controller.WithdrawController;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.http.HttpServletRequest;

public class ManagerUtil {
    private static final Log log = LogFactory.getLog(WithdrawController.class);

    public static Long getManagerId(CookieUtil cookieUtil, HttpServletRequest request) {
        String managerIdStr = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        return Long.parseLong(managerIdStr);
    }

    public static boolean judgeMangerIsIllegal(Manager manager, Integer[] managerTypesOfAllow) {

        log.info("manager is==" + manager + "   managerTypesOfAllow is==" + managerTypesOfAllow);

        if (null == manager) {
            return true;
        }

        for (Integer t : managerTypesOfAllow) {
            if (manager.getType().equals(t)) {
                return false;
            }
        }

        return true;
    }
}
