package com.ptteng.util;

import org.apache.commons.collections.CollectionUtils;

import java.util.*;

public class ListUtil {
    public ListUtil() {
    }

    public static <T extends Object> Map<Long, T> convert2Map(List<Long> keys, List<T> values) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(values)) {
            return new HashMap();
        } else {
            Map<Long, T> map = new HashMap();
            Iterator iterator1 = keys.iterator();
            Iterator iterator2 = values.iterator();

            while (iterator1.hasNext()) {
                Long id = (Long) iterator1.next();
                if (iterator2.hasNext()) {
                    T name = (T) iterator2.next();
                    map.put(id, name);
                }
            }
            return map;
        }
    }

    /**
     *  从目标List中获取部分元素,组成一个新的List返回
     * */
    public static <T> List<T> getPartElementsFromList(List<T> list, Integer begin, Integer size) {
        List<T> resultList = new ArrayList<>();

        for (int i = begin; i < begin + size; i++) {
            if (i < list.size()) {
                resultList.add(list.get(i));
            }
        }

        return resultList;
    }

    public static <T> List<List<T>> splitList(List<T> list, int pageSize) {
        int listSize = list.size();
        int page = (listSize + (pageSize - 1)) / pageSize;
        List<List<T>> listArray = new ArrayList<List<T>>();
        for (int i = 0; i < page; i++) {
            List<T> subList = new ArrayList<T>();
            for (int j = 0; j < listSize; j++) {
                int pageIndex = ((j + 1) + (pageSize - 1)) / pageSize;
                if (pageIndex == (i + 1)) {
                    subList.add(list.get(j));
                }
                if ((j + 1) == ((j + 1) * pageSize)) {
                    break;
                }
            }
            listArray.add(subList);
        }
        return listArray;
    }
}



