package com.ptteng.util;

import com.ptteng.util.httpUtils.httpRequestUtils.HttpReqUtil;
import com.ptteng.util.httpUtils.httpResponseUtiils.PostResponseUtil;
import com.ptteng.yi.nucleus.model.Center;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.pub.service.ImAccountService;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.log4j.Logger;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

/**
 * @author himly
 */

public class ImChatUtil {

    private static final Logger log = Logger.getLogger(ImChatUtil.class);
    private static final char[] HEX_DIGITS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd',
            'e', 'f' };

    private static String accessKey;

    private static String accessSecret;

    private static String createAccIdUrl;

    private static int accIdMaxLength;

    private static String updateInfoUrl;

    private static String unifiedPwd;

    private static ImAccountService imAccountService;

    public void setCreateAccIdUrl(String createAccIdUrl) {
        ImChatUtil.createAccIdUrl = createAccIdUrl;
    }

    public void setAccessSecret(String accessSecret) {
        ImChatUtil.accessSecret = accessSecret;
    }

    public void setAccessKey(String accessKey) {
        ImChatUtil.accessKey = accessKey;
    }

    public void setAccIdMaxLength(int accIdMaxLength) {
        ImChatUtil.accIdMaxLength = accIdMaxLength;
    }

    public void setUnifiedPwd(String unifiedPwd) {
        ImChatUtil.unifiedPwd = unifiedPwd;
    }

    public void setUpdateInfoUrl(String updateInfoUrl) {
        ImChatUtil.updateInfoUrl = updateInfoUrl;
    }

    public void setImAccountService(ImAccountService imAccountService) {
        ImChatUtil.imAccountService = imAccountService;
    }

    public Map<String, String> createImAccount(String accid) throws Exception {

        log.info("accid is==" + accid);
        if (accid == null || accid.isEmpty()) {
            log.info("accid is null or empty");
            throw new Exception("accid can not be null or empty");
        }

        boolean accountExistent = imAccountService.isAccidExistent(accid);
        if (accountExistent) {
            log.info("The accid is already existent");
            throw new Exception("The accid is already existent,pls swap another one");
        }

        Map<String, String> headers = getHeadersOfWYImChatRequest();
        Map<String, String> values = new HashMap<>(16);
        values.put("accid", accid);
        values.put("token", unifiedPwd);

        CloseableHttpResponse response = HttpReqUtil.sendPost(createAccIdUrl, headers, values);
        return PostResponseUtil.handleResponseOfCreateImAccountRequest(response);
    }

    /**
     * 更新学员im账号基本信息
     *
     * @param accid
     * @param students 学员信息
     * @return
     */
    public boolean updateStudentInfo(String accid, Students students) throws Exception {

        log.info("accid is==" + accid + "   students is==" + students);

        if (null == accid || accid.isEmpty() || null == students) {
            log.info("args is null or empty");
            throw new Exception("args can not be null or empty");
        }

        String name = students.getName();
        String mobile = students.getMobile();
        String icon = students.getImg();

        boolean hasOneParameterIsNotEmptyAndNull = ParametersUtil.hasOneParameterIsNotNullAndEmpty(name, mobile, icon);

        //无需更新
        if (!hasOneParameterIsNotEmptyAndNull) {
            log.error("students info is null or empty");
            return true;
        }

        Map<String, String> headers = getHeadersOfWYImChatRequest();
        Map<String, String> values = new HashMap<>(4);

        values.put("accid", accid);
        if (null != name && !name.equals(""))
            values.put("name", name);
        if (null != icon && !icon.equals(""))
            values.put("icon", icon);
        if (null != mobile && !mobile.equals(""))
            values.put("mobile", mobile);

        CloseableHttpResponse response = HttpReqUtil.sendPost(updateInfoUrl, headers, values);
        return PostResponseUtil.handleResponseOfUpdateInfoRequest(response);
    }

    /**
     * 更新教练im账号基本信息
     *
     * @param accid
     * @param coach 教练信息
     * @return
     */
    public boolean updateCoachInfo(String accid, Coach coach) throws Exception {

        log.info("accid is==" + accid + "   coach is==" + coach);

        if (null == accid || accid.isEmpty() || null == coach) {
            log.info("args is null or empty");
            throw new Exception("args can not be null or empty");
        }

        String name = coach.getName();
        String mobile = coach.getMobile();
        String icon = coach.getImg();

        boolean hasOneParameterIsNotEmptyAndNull = ParametersUtil.hasOneParameterIsNotNullAndEmpty(name, mobile, icon);

        //无需更新
        if (!hasOneParameterIsNotEmptyAndNull) {
            log.error("coach info is null or empty");
            return true;
        }

        Map<String, String> headers = getHeadersOfWYImChatRequest();
        Map<String, String> values = new HashMap<>(4);

        values.put("accid", accid);
        if (null != name && !name.equals(""))
            values.put("name", name);
        if (null != icon && !icon.equals(""))
            values.put("icon", icon);
        if (null != mobile && !mobile.equals(""))
            values.put("mobile", mobile);

        CloseableHttpResponse response = HttpReqUtil.sendPost(updateInfoUrl, headers, values);
        return PostResponseUtil.handleResponseOfUpdateInfoRequest(response);
    }

    /**
     * 更新驾校考务im账号基本信息
     *
     * @param accid
     * @param school 驾校考务信息
     * @return
     */
    public boolean updateSchoolManagerInfo(String accid, School school) throws Exception {

        log.info("accid is==" + accid + "   school is==" + school);

        if (null == accid || accid.isEmpty() || null == school) {
            log.info("args is null or empty");
            throw new Exception("args can not be null or empty");
        }

        String name = school.getName();
        String mobile = school.getMobile();
        String icon = school.getImg();

        boolean hasOneParameterIsNotEmptyAndNull = ParametersUtil.hasOneParameterIsNotNullAndEmpty(name, mobile, icon);

        //无需更新
        if (!hasOneParameterIsNotEmptyAndNull) {
            log.error("school info is null or empty");
            return true;
        }

        Map<String, String> headers = getHeadersOfWYImChatRequest();
        Map<String, String> values = new HashMap<>(4);

        values.put("accid", accid);
        if (null != name && !name.equals(""))
            values.put("name", name);
        if (null != icon && !icon.equals(""))
            values.put("icon", icon);
        if (null != mobile && !mobile.equals(""))
            values.put("mobile", mobile);

        CloseableHttpResponse response = HttpReqUtil.sendPost(updateInfoUrl, headers, values);
        return PostResponseUtil.handleResponseOfUpdateInfoRequest(response);
    }

    /**
     * 更新运营中心客服im账号基本信息
     *
     * @param accid
     * @param center 运营中心信息
     * @return
     */
    public boolean updateCustomerServiceInfo(String accid, Center center) throws Exception {

        log.info("accid is==" + accid + "   center is==" + center);

        if (null == accid || accid.isEmpty() || null == center) {
            log.info("args is null or empty");
            throw new Exception("args can not be null or empty");
        }

        String name = accid.contains("sqkf_") ? "售前客服" : "售后客服";
        String mobile = accid.contains("sqkf_") ? center.getProMobile() : center.getAfterMobile() + "";

        boolean hasOneParameterIsNotEmptyAndNull = ParametersUtil.hasOneParameterIsNotNullAndEmpty(name, mobile);

        //无需更新
        if (!hasOneParameterIsNotEmptyAndNull) {
            log.error("customer info is null or empty");
            return true;
        }

        Map<String, String> headers = getHeadersOfWYImChatRequest();
        Map<String, String> values = new HashMap<>(4);

        values.put("accid", accid);
        values.put("name", name);

        if (null != mobile && !mobile.equals(""))
            values.put("mobile", mobile);

        CloseableHttpResponse response = HttpReqUtil.sendPost(updateInfoUrl, headers, values);
        return PostResponseUtil.handleResponseOfUpdateInfoRequest(response);
    }

    private Map<String, String> getHeadersOfWYImChatRequest() {

        Map<String, String> headers = new HashMap<>(16);
        String nonce = RandomUtils.generateString(20);
        String cureTime = String.valueOf(System.currentTimeMillis() / 1000);
        String checkSum = getCheckSum(accessSecret, nonce, cureTime);

        headers.put("AppKey", accessKey);
        headers.put("Nonce", nonce);
        headers.put("CurTime", cureTime);
        headers.put("CheckSum", checkSum);
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");

        return headers;
    }

    /**
     * 创建应用内唯一accid账号
     * 规则:账号所属人员类型枚举值+"|"+所属人员id+"UUID"(共32位,若超过则缩减UUID位数)
     * @param id 账号所属人员id
     * @param type 账号所属人员类型
     * @return
     */
    public String getAccid(Long id, AccidType type) throws Exception {

        log.info("id is==" + id + " type is==" + type);

        if (null == id || 0 >= id) {
            log.info("id is null or zero");
            throw new Exception("id cant not be null or zero");
        }

        String accid = null;
        int accidLength = 0;
        int UUIDLength = 0;
        switch (type) {
        case STUDENT:
            accid = "xy" + "_" + id + "_";
            break;
        case COACH:
            accid = "jl" + "_" + id + "_";
            break;
        case SCHOOL_MANAGER:
            accid = "kw" + "_" + id + "_";
            break;
        case PresaleCustomerService:
            accid = "sqkf" + "_" + id + "_";
            break;
        case AftersalesCustomerService:
            accid = "shkf" + "_" + id + "_";
            break;
        default:
            break;
        }

        accidLength = accid.length();
        UUIDLength = accIdMaxLength - accidLength;
        accid = accid + RandomUtils.toFixedLengthStringByUUID(UUIDLength);

        return accid;
    }

    public enum AccidType {
        //学员
        STUDENT,
        //教练
        COACH,
        //驾校考务
        SCHOOL_MANAGER,
        //售前服务人员
        PresaleCustomerService,
        //售后客服人员
        AftersalesCustomerService
    }

    // 计算并获取CheckSum
    private String getCheckSum(String appSecret, String nonce, String curTime) {
        return encode("sha1", appSecret + nonce + curTime);
    }

    // 计算并获取md5值
    private String getMD5(String requestBody) {
        return encode("md5", requestBody);
    }

    private String encode(String algorithm, String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(value.getBytes());
            return getFormattedText(messageDigest.digest());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; j++) {
            buf.append(HEX_DIGITS[(bytes[j] >> 4) & 0x0f]);
            buf.append(HEX_DIGITS[bytes[j] & 0x0f]);
        }
        return buf.toString();
    }
}
