package com.ptteng.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.yi.nucleus.model.Students;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.PortableInterceptor.INACTIVE;

import java.util.*;

public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /**
     * 动态查询settlement表的参数
     */
    public static Map<String, Object> getSettlementListParams(Long schoolId, Long startTime, Long endTime,
            Integer status, Long cityId, Boolean count) {

        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);

            if (DataUtils.isNotNullOrEmpty(status)) {
                params.put("status", status);
            }
        }

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
            params.put("status", 0);
        }

        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >= ", startTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <= ", endTime);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " create_at desc ");
            params.put("@query", " id");
        }

        params.put("@table", " settlement ");

        return params;
    }

    /**
     * 动态查询record表的参数
     */
    public static Map<String, Object> getRecordListParams(Long schoolId, Long startTime, Long endTime, Integer status,
            Boolean count) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >=", startTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }

        params.put("@table", "record");

        return params;
    }

    /**
     * 动态查询withdraw表的参数
     */
    public static Map<String, Object> getWithdrawListParams(Long startTime, Long endTime, Long schoolId, Integer status,
            Boolean count) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >=", startTime);
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }

        params.put("@table", "withdraw");

        return params;
    }

    /**
     * getEnrollmentListBySchool方法中的参数
     */
    public static Map<String, Object> getEnrollmentListBySchool(Long startTime, Long endTime, Integer type,
            Integer status, Long schoolId, Boolean count) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("status", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("withdraw_status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >=", startTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }

        params.put("@table", "enrollment_detail");

        return params;
    }

    /**
     * getEnrollmentListByCenter方法中的参数
     */
    public static Map<String, Object> getEnrollmentListByCenter(Long startTime, Long endTime, Integer type,
            Integer status, Long cityId, Boolean count) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("withdraw_status", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >=", startTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }

        params.put("@table", "enrollment_detail");

        return params;
    }

    /**
     * 动态查询enrollment_detail表的参数
     */
    public static Map<String, Object> getEnrollmentDetailParams(Long startTime, Long endTime, Integer type,
            Integer status, Long cityId, List<Long> schoolIdList) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("withdraw_status", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >=", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }

        if (DataUtils.isNotNullOrEmpty(schoolIdList)) {
            String ids = org.apache.commons.lang3.StringUtils.join(schoolIdList, ",");
            params.put("school_id & in", "(" + ids + ")");
        }

        params.put("@query", "id");
        params.put("@order", "create_at desc");

        params.put("@table", "enrollment_detail");

        return params;
    }

    /**
     * 动态查询getFinanceRecordDetailList()方法中的参数
     */
    public static Map<String, Object> getFinanceRecordDetailListParams(Long id, Integer type, Boolean count) {
        Map<String, Object> params = new HashMap();

        switch (type) {
        case 0:
            params.put("income_id", id);
            break;
        case 1:
            params.put("expenses_id", id);
            break;
        case 2:
            params.put("settlement_id", id);
            break;
        case 3:
            params.put("withdraw_id", id);
            break;
        default:
            break;
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }
        params.put("@table", "enrollment_detail");

        return params;
    }

    /**
     * 动态查询subject_operation表的参数
     */
    public static Map<String, Object> getSubjectOperationListParams(String title, Integer subjectType, Integer type,
            Integer status, Boolean count) {

        Map<String, Object> params = new HashedMap();

        if (StringUtils.isNotBlank(title)) {
            params.put("title & like ", "'" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectType)) {
            params.put("subject_type", subjectType);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " sort desc, create_at desc ");
            params.put("@query", " id");
        }

        params.put("@table", "subject_operation");

        return params;
    }

    /**
     * 动态查询subject_broadcast表的参数
     */
    public static Map<String, Object> getSubjectBroadcastListParams(String title, Integer subjectType, Integer type,
            Boolean count) {

        Map<String, Object> params = new HashedMap();

        if (StringUtils.isNotBlank(title)) {
            params.put("title & like ", "'" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectType)) {
            params.put("subject_type", subjectType);
        }
        if (subjectType == 3) {
            if (DataUtils.isNotNullOrEmpty(type)) {
                params.put("type", type);
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " sort desc, create_at desc ");
            params.put("@query", " id");
        }

        params.put("@table", "subject_broadcast");

        return params;
    }

    /**
     * 查询卡券类型
     */
    public static Map<String, Object> getCardTypeListParams(String title, String creator, Long createAtStart,
            Long createAtEnd, Integer value, Integer status, Boolean count) {
        Map<String, Object> params = new HashMap();

        Set<String> tables = new HashSet();
        tables.add("card_type c ");

        if (StringUtils.isNotBlank(title)) {
            params.put("c.title & like ", "'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put("c.value", value);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("c.status", status);
        }

        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("c.create_at & >=", createAtStart);
        }

        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("c.create_at & <=", createAtEnd);
        }

        if (StringUtils.isNotBlank(creator)) {
            tables.add("yi_admin.manager m");
            params.put("m.id", "c.create_by");
            params.put("m.name & like ", "'%" + creator + "%'");
        }

        if (count) {
            params.put("@query", "count(c.id)");
        } else {
            params.put("@query", "c.id");
            params.put("@order", "c.create_at desc");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    /**
     * 搜索管理员
     */
    public static Map<String, Object> getManagerListParams(String creator, String verifier, Boolean count) {

        Map<String, Object> params = new HashMap();

        if (StringUtils.isNotBlank(creator)) {
            params.put("name & like ", "'%" + creator + "%'");
        }

        if (StringUtils.isNotBlank(verifier)) {
            params.put("name & like ", "'%" + verifier + "%'");
        }

        if (count) {
            params.put("@query", "count(c.id)");
        } else {
            params.put("@query", "id");
            params.put("@order", "create_at desc");
        }

        params.put("@table", "  manager ");

        return params;
    }

    /**
     * 查询卡券
     */
    public static Map<String, Object> getCardListParams(String number, List<Long> creatorIdList, String ownerName,
            List<Long> verifierIdList, Long tid, Integer status, Long createAtStart, Long createAtEnd,
            Long exchangeAtStart, Long exchangeAtEnd, Long verifyAtStart, Long verifyAtEnd, Boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(number)) {
            params.put("number & like ", "'%" + number + "%'");
        }

        if (StringUtils.isNotBlank(ownerName)) {
            params.put("owner_name & like ", "'%" + ownerName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(tid)) {
            params.put("tid", tid);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            params.put("create_at & >=", createAtStart);
        }

        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            params.put("create_at & <=", createAtEnd);
        }

        if (DataUtils.isNotNullOrEmpty(exchangeAtStart)) {
            params.put("exchange_at & >=", exchangeAtStart);
        }

        if (DataUtils.isNotNullOrEmpty(exchangeAtEnd)) {
            params.put("exchange_at & <=", exchangeAtEnd);
        }

        if (DataUtils.isNotNullOrEmpty(verifyAtStart)) {
            params.put("verify_at & >=", verifyAtStart);
        }

        if (DataUtils.isNotNullOrEmpty(verifyAtEnd)) {
            params.put("verify_at & <=", verifyAtEnd);
        }

        if (DataUtils.isNotNullOrEmpty(creatorIdList)) {
            String ids = StringUtils.join(creatorIdList, ",");
            params.put("create_by & in ", "(" + ids + ")");
        }

        if (DataUtils.isNotNullOrEmpty(verifierIdList)) {
            String ids = StringUtils.join(verifierIdList, ",");
            params.put("verified_by & in ", "(" + ids + ")");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  create_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " card ");

        return params;
    }

    /**
     * 查询内容
     */
    public static Map<String, Object> getContentListParams(Integer type, String title, Integer status, Integer app,
            Long updateAtStart, Long updateAtEnd, Long publishAtStart, Long publishAtEnd, Long cityId, Boolean count) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (StringUtils.isNotBlank(title)) {
            params.put("title & like ", "'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (DataUtils.isNotNullOrEmpty(app)) {
            params.put("app", app);
        }

        if (DataUtils.isNotNullOrEmpty(updateAtStart)) {
            params.put("update_at & >=", updateAtStart);
        }

        if (DataUtils.isNotNullOrEmpty(updateAtEnd)) {
            params.put("update_at & <=", updateAtEnd);
        }

        if (DataUtils.isNotNullOrEmpty(publishAtStart)) {
            params.put("publish_at & >=", publishAtStart);
        }

        if (DataUtils.isNotNullOrEmpty(publishAtEnd)) {
            params.put("publish_at & <=", publishAtEnd);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " content ");

        return params;
    }

    /**
     * 查询信息
     */
    public static Map<String, Object> getInfoListParams(String title, Integer type, Integer status, Long cityId,
            Boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(title)) {
            params.put("title & like ", "'%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " info ");

        return params;
    }

    /**
     * 查询管理员信息 */
    public static Map<String, Object> getManagerTypeListParams(Integer type, String status, Boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", "'" + status + "'");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " manager ");

        return params;
    }

    /**
     * 查询线索 */
    public static Map<String, Object> getStudentClueListParams(String name, String mobile, String os, Long submitStart,
            Long submitEnd,  Long cityId) {
        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(name)) {
            params.put("name & like ", "'%" + name + "%'");
        }

        if (StringUtils.isNotBlank(mobile)) {
            params.put("mobile & like ", "'%" + mobile + "%'");
        }

        if (StringUtils.isNotBlank(os)) {
            params.put("os & like ", "'%" + os + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(submitStart)) {
            params.put("create_at & >=", submitStart);
        }

        if (DataUtils.isNotNullOrEmpty(submitEnd)) {
            params.put("create_at & <=", submitEnd);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id  ", cityId);
        }
        params.put("@query", " id ");

        params.put("@table", " probation");

        return params;
    }

    /**
     * 查询意见反馈、题目纠错 */
    public static Map<String, Object> getFeedbackListParams(String userMobile, String name, Integer source,
            Long submitStart, Long submitEnd, Long cityId, Boolean count) {
        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(name)) {
            params.put("name & like ", "'%" + name + "%'");
        }

        if (StringUtils.isNotBlank(userMobile)) {
            params.put("user_mobile & like ", "'%" + userMobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(source)) {
            params.put("source", source);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (DataUtils.isNotNullOrEmpty(submitStart)) {
            params.put("create_at & >=", submitStart);
        }

        if (DataUtils.isNotNullOrEmpty(submitEnd)) {
            params.put("create_at & <=", submitEnd);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  create_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " feedback ");

        return params;
    }

    /**
     * manager */
    public static Map<String, Object> getManagerParamsByCityId(Long cityId) {
        Map<String, Object> params = new HashMap<>();
        params.put("city_id & = ", "'" + cityId + "'");
        params.put("type & = ", "" + 1 + "");
        params.put("@query", " id ");
        params.put("@order", "  create_at asc ");
        params.put("@table", " manager ");

        return params;
    }

    /**
     * manager */
    public static Map<String, Object> getSchoolClassRelationByClassId(List<Long> classIds) {
        Map<String, Object> params = new HashMap<>();

        if (CollectionUtils.isNotEmpty(classIds)) {
            params.put(" class_id & in ", "(" + org.apache.commons.lang.StringUtils.join(classIds, ",") + ")");
        }

        params.put("@query", " id ");
        params.put("@order", "  create_at asc ");
        params.put("@table", " school_class_relation ");

        return params;
    }

    /**
     * manager */
    public static Map<String, Object> getDrivingClassIdsByCityId(Long cityId) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }

        params.put("@query", " id ");
        params.put("@order", "  create_at asc ");
        params.put("@table", " driving_class ");

        return params;
    }

    /**
     * manager */
    public static Map<String, Object> getDrivingClassIdsByCityIdAndStatusAndShowingcae(Long cityId, Integer status,
            Integer showcasing) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(showcasing)) {
            params.put("showcasing", showcasing);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }

        params.put("@query", " id ");
        params.put("@order", "  create_at asc ");
        params.put("@table", " driving_class ");

        return params;
    }

    /**
     * 查询运营中心
     */
    public static Map<String, Object> geCenterByCityIdAndStatus(Long cityId, Integer status) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }

        params.put("@query", " id ");
        params.put("@order", " create_at asc ");
        params.put("@table", " center ");

        return params;
    }

    /**
     * 查询运营中心
     */
    public static Map<String, Object> getModuleListbyModuleType(Integer moduleType) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(moduleType)) {
            params.put("module_type", moduleType);
        }
        params.put("@query", " id ");
        params.put("@order", " create_at asc ");
        params.put("@table", " module ");

        return params;
    }

    /**
     * 动态查询学员表的参数
     */
    public static Map<String, Object> getStudentListParams(String name, String nick, Long cityId, Long schoolId,
            Long classId, String mobile, Integer progress, String identification, Integer channel,
            Integer certification, Integer status) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like ", "'" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like ", "'" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(identification)) {
            params.put("identification & like ", "'" + identification + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(classId)) {
            params.put("class_id", classId);
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile & like ", "'" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(progress)) {
            params.put("progress", progress);
        }
        if (DataUtils.isNotNullOrEmpty(channel)) {
            if (channel == 1) {
                params.put("school_id!= 0 and 1", "1");
            } else {
                params.put("school_id", 0);
            }
        }
        //搜索驾校id会覆盖掉搜索渠道的驾校类型搜索
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(certification)) {
            params.put("certification", certification);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        params.put("@query", "id");
        params.put("@order", "create_at desc");
        params.put("@table", "students");

        log.info("params ======" + params);

        return params;
    }

    /**
     * 订单参数
     */
    public static Map<String, Object> getStudentOrderListParams(Long stuId, int status) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(stuId)) {
            params.put("stu_id", stuId);
        }

        params.put("@query", "id");
        params.put("@table", "order");

        return params;
    }

    /**
     * 教练查询
     */
    public static Map<String, Object> getCoachListParams(Long schoolId, Long cityId, String name, String school,
            String identification, String mobile, Integer status, Integer certification, String subject) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(subject)) {
            if (subject.equals("0")) {
                params.put("( subject", subject + "  or subject = " + "2 )");
            } else if (subject.equals("1")) {
                params.put("( subject", subject + "  or subject = " + "2 )");
            } else {
                params.put("subject", subject);
            }
        }

        if (DataUtils.isNotNullOrEmpty(identification)) {
            params.put("identification & like ", "'" + identification + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile & like ", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(school)) {
            params.put("school & like ", "'%" + school + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        } else {
            params.put("certification", 1);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        params.put("@query", "id");
        params.put("@table", "coach");

        return params;
    }

    /**
     * 驾校查询
     */
    public static Map<String, Object> getSchoolListParams(Long cityId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        params.put("@query", "id");
        params.put("@table", "school");

        return params;
    }

    /**
     * role_module查询
     */
    public static Map<String, Object> getRolelListParams(Long id, Long type, Long targetId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("role_id", id);
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(targetId)) {
            params.put("target_id", targetId);
        }

        params.put("@query", "id");
        params.put("@table", "role_module");

        return params;
    }

    /**
     * role查询
     */
    public static Map<String, Object> getRolelParams(Integer type, Long targetId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(targetId)) {
            params.put("target_id", targetId);
        }

        params.put("@query", "id");
        params.put("@table", "role");

        return params;
    }

    /**
     * role查询
     */
    public static Map<String, Object> getManagerNameParams(String name, Long cityId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name", name);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        params.put("@query", "id");
        params.put("@table", "manager");

        return params;
    }

    /**
     * 冻结用户查询
     */
    public static Map<String, Object> getFreezeUserListParams(Long uid, Integer type) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        params.put("@query", "id");
        params.put("@table", "freeze_user");

        return params;
    }

    /**
     *查询驾校-训练场 关系表
     *
     */
    public static Map<String, Object> getSchoolVenuesRelationIdBySchoolId(Long schoolId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        params.put("@query", "id");
        params.put("@table", "school_venues_relation");

        return params;
    }

    /**
     *查询驾校-班型 关系表
     *
     */
    public static Map<String, Object> getSchoolClassRelationIdBySchoolId(Long schoolId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }

        params.put("@query", "id");
        params.put("@table", "school_class_relation");

        return params;
    }

    /**
     * 查询学员数量,通过cityId
     */
    public static Map<String, Object> getStudentIdsByCity(Long cityId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }
        params.put("@query", "id");
        params.put("@table", "students");

        return params;
    }

    /**
     * 查询教练数量,通过驾校id
     */
    public static Map<String, Object> getCoachIdsByCity(Long cityId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        params.put("@query", "id");
        params.put("@table", "coach");

        return params;
    }

    /**
     * 查询教练数量首頁
     */
    public static Map<String, Object> getCoachIdsBySchoolIdAndMore(Long schoolId, Long cityId, Integer certify) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(certify)) {
            params.put("certification", certify);
        }

        params.put("@query", "id");
        params.put("@table", "coach");

        return params;
    }

    /**
     * 查询學員数量首頁
     */
    public static Map<String, Object> getStuIds(Long schoolId, Long cityId, Integer certify, Long before, Long after) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(certify)) {
            params.put("certification", certify);
        }
        if (DataUtils.isNotNullOrEmpty(before)) {
            params.put("registration_date & >=", before);
        }
        if (DataUtils.isNotNullOrEmpty(after)) {
            params.put("registration_date & <=", after);
        }

        params.put("@query", "id");
        params.put("@table", "students");

        return params;
    }

    /**
     * 动态驾校查询
     */
    public static Map<String, Object> getSchoolListByCondition(Long cityId, String name, String location,
            String trainingVenuesName, String resPersion, String mobile) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(location)) {
            params.put("location & like", "'%" + location + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(trainingVenuesName)) {
            params.put("training_venues_name & like", "'%" + trainingVenuesName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(resPersion)) {
            params.put("resPersion & like", "'%" + resPersion + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile & like", "'%" + mobile + "%'");
        }

        params.put("@query", "id");
        params.put("@table", "school");

        return params;
    }

    /**
     * 查询教练评价
     */
    public static Map<String, Object> getCommentByCoachIdAndCondition(Long coachlId, Integer subject, Long beginTime,
                                                                      Long endTime) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(coachlId)) {
            params.put("coach", coachlId);
        }

        if (DataUtils.isNotNullOrEmpty(subject) && (subject == 0 || subject == 1)) {
            params.put("subject", subject);
        }

        if (DataUtils.isNotNullOrEmpty(subject) && subject == 2) {
            params.put(" ( subject", 0 + " or subject = 1 ) ");
        }

        if (DataUtils.isNotNullOrEmpty(beginTime)) {
            params.put("create_at & >=", beginTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }

        params.put(" ( type", 5 + " or type = 7 ) ");

        params.put("@query", "id");
        params.put("@table", "appoint_order");

        return params;
    }

    /**
     * 查询教练评价
     */
    public static Map<String, Object> getOrderByCParam(Long cityId, Long schoolId , Long beginTime,
                                                                      Long endTime) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(schoolId) ) {
            params.put("school_id", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(beginTime)) {
            params.put("create_at & >=", beginTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <=", endTime);
        }

        params.put("@query", "id");
        params.put("@table", "appoint_order");

        return params;
    }

    /**
     *获取学生id，通过姓名 手机
     */
    public static Map<String, Object> getStudentIdByNameAndMobile(String stuName, String mobile, Long coachId,
            Integer subject) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(stuName)) {
            params.put("name & like", "'%" + stuName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile & like", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(coachId) && subject == 0) {
            params.put("section_two_coach_id", coachId);
        }

        if (DataUtils.isNotNullOrEmpty(coachId) && subject == 1) {
            params.put("section_three_coach_id", coachId);
        }

        //科二和科三
        if (DataUtils.isNotNullOrEmpty(coachId) && subject == 2) {
            params.put("( section_two_coach_id ", coachId + "  or section_three_coach_id = " + coachId + " ) ");
        }

        params.put("@query", "id");
        params.put("@table", "students");

        return params;
    }

    /**绩效
     * 获取学生，通过教练id
     */
    public static Map<String, Object> getStudentIdByCoachId(Long cityId, Long coachId) {
        Map<String, Object> params = new HashMap();

        String sql = " and city_id = " + cityId + " and (section_two_coach_id = " + coachId
                + " or section_three_coach_id = " + coachId + ")";

        if (DataUtils.isNotNullOrEmpty(coachId) && DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("1", " 1 " + sql);
        }

        params.put("@query", "id");
        params.put("@table", "students");

        return params;
    }

    /**
     * 获取学生
     */
    public static Map<String, Object> getStudentIdForPerformance(Long cityId) {
        Map<String, Object> params = new HashMap();
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        params.put("@query", "id");
        params.put("@table", "students");
        return params;
    }


    /**
     * 查询绩效
     */
    public static Map<String, Object> getCoachPerformanceForCondition(Long cityId, Long schoolId, String coachName,
                                                                      String mobile) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(coachName)) {
            params.put("name & like", "'%" + coachName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile & like", "'%" + mobile + "%'");
        }

        params.put("@query", "id");
        params.put("@table", "coach");

        return params;
    }

    /**通过率
     * 获取考务信息
     */
    public static Map<String, Object> getTestActivityByCondition(Long beginTime, Long endTime, Integer subject) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(beginTime)) {
            params.put(" test_time & >= ", beginTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put(" test_time & <= ", endTime);
        }

        if (DataUtils.isNotNullOrEmpty(subject) && (subject == 0 || subject == 1)) {
            params.put("type", (subject + 4));
        }

        if (DataUtils.isNotNullOrEmpty(subject) && subject == 2) {
            params.put(" ( type", 4 + " or type = 5 ) ");
        }

        params.put("status", 1);

        params.put("@query", "id");
        params.put("@table", "test_activity");

        return params;
    }

    /**
     *获取考试记录
     */
    public static Map<String, Object> getTestRecordByStuIdAndCoachId(Long stuId, Integer subject) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(stuId)) {
            params.put("stu_id", stuId);
        }

        if (DataUtils.isNotNullOrEmpty(subject)) {
            params.put(" ( type",   4 + " or type = 5 ) and is_news = 0 ");
        }

        params.put("@query", "id");
        params.put("@table", "test_records");

        return params;
    }

    /**通过率
     *  查询考试记录，
     */
    public static Map<String, Object> getTestRecordByCondition(Long coachId, Long tacId, Integer subject,
            boolean isPass) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach_id", coachId);
        }

        if (DataUtils.isNotNullOrEmpty(tacId)) {
            params.put("test_act_id", tacId);
        }

        if (DataUtils.isNotNullOrEmpty(subject) && (subject == 0 || subject == 1)) {
            params.put("type", (subject + 4));
        }

        if (DataUtils.isNotNullOrEmpty(subject) && subject == 2) {
            params.put(" ( type", 4 + " or type = 5 ) ");
        }

        if (isPass) {
            params.put("pass", 1);
        }

        //没通过
        if (!isPass) {
            String sql = " and pass = 2 and is_news = 0 ";
            params.put(" 1 ", " 1 " + sql);
        }

        params.put("@query", "id");
        params.put("@table", "test_records");

        return params;
    }

    /**
     * 获取通过考试人数---教练
     */
    public static Map<String, Object> getNumberByCoachId(Long coachId, boolean isOne) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach_id", coachId);
        }

        if (isOne) {
            params.put("times", 1);
        }

        String sql = " and pass = 1 and (type = 4 or type = 5) and is_news = 0 ";
        params.put("1", " 1 " + sql);

        params.put("@query", "id");
        params.put("@table", "test_records");

        return params;
    }

    /**
     * 参加考试人数
     */
    public static Map<String, Object> getAllTestForPerformance() {
        Map<String, Object> params = new HashMap();
        String sql = " and ( pass = 1 or pass = 2 ) and (type = 4 or type = 5) and is_news = 0 ";
        params.put("1", " 1 " + sql);
        params.put("@query", "id");
        params.put("@table", "test_records");
        return params;
    }

    /**
     * 考试不通过人数
     */
    public static Map<String, Object> getNotPassByCoachId(Long coachId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach_id", coachId);
        }

        String sql = " and pass = 2 and (type = 4 or type = 5) and is_news = 0 ";
        params.put("1", " 1 " + sql);

        params.put("@query", "id");
        params.put("@table", "test_records");

        return params;
    }

    /**学时查看
     * 查询学生
     */
    public static Map<String, Object> getStudyTimeFormStudent(Long cityId, Long schoolId, String stuName, String mobile,
            String identification, Integer subject, Integer progress, String coachName) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(coachName) &&  DataUtils.isNotNullOrEmpty(subject) && subject == 0) {
            params.put("section_two_coach & like", "'%" + coachName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(coachName) && DataUtils.isNotNullOrEmpty(subject) && subject == 1) {
            params.put("section_three_coach & like", "'%" + coachName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(stuName)) {
            params.put(" name & like", "'%" + stuName + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put(" mobile & like", "'%" + mobile + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(identification)) {
            params.put(" identification & like", "'%" + identification + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(progress) && DataUtils.isNotNullOrEmpty(subject) && subject == 0) {
            params.put(" section_two_numerator & >= ", progress);
        }

        if (DataUtils.isNotNullOrEmpty(progress) && DataUtils.isNotNullOrEmpty(subject) && subject == 1) {
            params.put(" section_three_numerator & >= ", progress);
        }

        params.put("@query", "id");
        params.put("@table", "students");

        return params;
    }

    /**
     * 查询驾校 / 运营中心 常量
     */
    public static Map<String, Object> getConstantByTypeAndId(Integer type, Long targetId) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type ", type);
        }

        if (DataUtils.isNotNullOrEmpty(targetId)) {
            params.put(" target_id ", targetId);
        }

        params.put("@query", " id ");
        params.put("@table", " constant ");

        return params;
    }

    /**
     * 运营中心，约车时间
     * type:星期几
     * status:1为默认
     */
    public static Map<String, Object> getTimeForCenter(Integer type, Long cityId) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type ", type);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put(" city_id ", cityId);
        }

        params.put(" status ", 1);

        params.put("@query", " id ");
        params.put("@table", " coach_appoint_time ");

        return params;
    }

    /**
     * 查詢区域时间 */
    public static Map<String, Object> getAppointTimeList(Long coachTimeId, Integer status) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(coachTimeId)) {
            params.put("coach_time_id ", coachTimeId);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status ", status);
        }

        params.put("@query", " id ");
        params.put("@table", " advance_time ");

        return params;
    }

    /**
     * 动态构造查询获取考试计划
     * @param title
     * @param type
     * @param leaderName
     * @param leaderMobile
     * @param location
     * @param time
     * @param schoolId
     * @return
     * @throws Exception
     */
    public static Map<String, Object> getTestPlanIdsByCondition(String title, Integer type, String leaderName,
            String leaderMobile, String location, List<Long> time, List<Long> schoolId) throws Exception {

        log.info("school id is==" + schoolId);
        if (null == schoolId || 0 == schoolId.size()) {
            throw new Exception("school id is null or illegal,pls check it,school id is==" + schoolId);
        }

        Map<String, Object> params = new HashMap<>(16);
        params.put("1", title);
        params.put("2", type);
        params.put("3", leaderName);
        params.put("4", leaderMobile);
        params.put("5", location);
        params.put("6", time);

        Map<String, Object> sqlInfo = new HashMap<>(16);
        String queryCondition = "";

        for (int i = 1; i < params.size() + 1; ++i) {
            String token = i + "";
            if (null == params.get(token)) {
                continue;
            }

            switch (token) {
                case "1":
                    if (!title.equals("")) {
                    queryCondition = " and " + getSqlByTitleToGetTestPlan(title);
                    }
                    break;
                case "2":
                queryCondition = queryCondition + " and " + getSqlByTypeToGetTestPlan(type);
                    break;
                case "3":
                queryCondition = queryCondition + " and " + getSqlByLeaderNameToGetTestPlan(leaderName);
                    break;
                case "4":
                    if (!leaderMobile.equals("")) {
                    queryCondition = queryCondition + " and " + getSqlByLeaderMobileToGetTestPlan(leaderMobile);
                    }
                    break;
                case "5":
                queryCondition = queryCondition + " and " + getSqlByLocationToGetTestPlan(location);
                    break;
                case "6":
                queryCondition = queryCondition + " and " + getSqlByTimeToGetTestPlan(time);
                    break;
            }
        }

        String schoolIdSql = "";
        for (int i = 0; i < schoolId.size(); ++i) {
            if (i == 0)
                schoolIdSql = "(" + schoolId.get(i);
            else
                schoolIdSql = schoolIdSql + ", " + schoolId.get(i);

            if (i == schoolId.size() - 1)
                schoolIdSql = schoolIdSql + ")";
        }

        if (!queryCondition.isEmpty())
            sqlInfo.put("1", " 1 " + queryCondition);

        sqlInfo.put("school_id & in ", schoolIdSql);
        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", " test_plan");

        return sqlInfo;
    }

    private static String getSqlByTitleToGetTestPlan(String title) {
        return "title like '%%" + title + "%%'";
    }

    private static String getSqlByTypeToGetTestPlan(Integer type) {
        return "type = " + type;
    }

    private static String getSqlByLeaderNameToGetTestPlan(String leaderName) {
        return "leader_name like '%%" + leaderName + "%%'";
    }

    private static String getSqlByLeaderMobileToGetTestPlan(String leaderMobile) {
        return "leader_mobile = " + leaderMobile;
    }

    private static String getSqlByLocationToGetTestPlan(String location) {
        return "location like '%%" + location + "%%'";
    }

    private static String getSqlByTimeToGetTestPlan(List<Long> time) throws Exception {
        Long startTime = time.get(0);
        Long endTime = time.get(1);

        //unix毫秒级时间一定大于10位数
        if ((null != startTime && startTime < 9999999999L) || (null != endTime && endTime < 9999999999L))
            throw new Exception("beginTime or endTime is not unix time Of millisecond,beginTime is==" + startTime
                    + "   endTime is==" + endTime);

        String sql = null;
        if (null != startTime && null != endTime) {
            sql = "test_time BETWEEN " + startTime + " and " + endTime;
        } else if (null != startTime) {
            sql = "test_time >= " + startTime;
        } else if (null != endTime) {
            sql = "test_time <= " + endTime;
        }

        return sql;
    }

    /**
     * 通过cityId及类型获取驾校id
     * @param cityId
     * @param type 0 全部 1 未被冻结的驾校 2 被冻结驾校
     * @return
     */
    public static Map<String, Object> getSchoolIdsByCityIdAndType(Long cityId, Integer type) throws Exception {

        if (null == cityId || null == type) {
            log.info("The args name called 'cityId' or 'type' is null");
            throw new Exception("The all of args can not be null");
        }

        Map<String, Object> sqlInfo = new HashMap<>(16);
        if (type == 1) {
            sqlInfo.put("status", 1);
        } else if (type == 2) {
            sqlInfo.put("status", 0);
        }

        sqlInfo.put("city_id", cityId);
        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", " school");

        return sqlInfo;
    }

    public static Map<String, Object> getTestPlanById(Long id, List<Long> schoolId) {

        Map<String, Object> sqlInfo = new HashMap<>(16);

        String schoolIdSql = "";
        for (int i = 0; i < schoolId.size(); ++i) {
            if (i == 0)
                schoolIdSql = "(" + schoolId.get(i);
            else
                schoolIdSql = schoolIdSql + ", " + schoolId.get(i);

            if (i == schoolId.size() - 1)
                schoolIdSql = schoolIdSql + ")";
        }

        sqlInfo.put("id", id);
        sqlInfo.put("school_id & in ", schoolIdSql);
        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", " test_plan");

        return sqlInfo;
    }

    /**
     * 约车订单搜索 */
    public static Map<String, Object> getAppointOrderList(List<String> type, Long time, Long timeStart, Long timeEnd,
            Long coachId, Long studentId, Integer subject, Long createStart, Long createEnd, Long practiceStart,
            Long practiceEnd, String score, String coachMobile, String studentMobile,Long schoolId,Long cityId) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type & in ", "(" + String.join(",", type) + ")");
        }

        if (DataUtils.isNotNullOrEmpty(time)) {
            params.put("time ", time);
        }

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach ", coachId);
        }
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            params.put("time_start ", timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            params.put("time_end ", timeEnd);
        }
        if (DataUtils.isNotNullOrEmpty(studentId)) {
            params.put("student ", studentId);
        }
        if (DataUtils.isNotNullOrEmpty(subject)) {
            params.put("subject ", subject);
        }

        if (DataUtils.isNotNullOrEmpty(score)) {
            params.put("score ", score);
        }

        if (DataUtils.isNotNullOrEmpty(coachMobile)) {
            params.put("coach_mobile ", coachMobile);
        }

        if (DataUtils.isNotNullOrEmpty(studentMobile)) {
            params.put("student_mobile ", studentMobile);
        }

        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id ", schoolId);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }

        if (DataUtils.isNotNullOrEmpty(createStart)) {
            params.put("create_at & >=", createStart);
        }

        if (DataUtils.isNotNullOrEmpty(createEnd)) {
            params.put("create_at & <=", createEnd);
        }

        if (DataUtils.isNotNullOrEmpty(practiceStart)) {
            params.put("time & >=", practiceStart);
        }

        if (DataUtils.isNotNullOrEmpty(practiceEnd)) {
            params.put("time & <=", practiceEnd);
        }

        params.put("@query", " id ");
        params.put("@table", " appoint_order ");

        return params;
    }

    /**
     * 版本搜索 */
    public static Map<String, Object> getPlQuery(int os, int type) {
        Map<String, Object> params = new HashMap<>();
        params.put(" os  ", os);
        params.put(" type ", type);
        params.put("@query", "id");
        params.put("@table", "version");
        return params;
    }

    /**
     * 多个时间区域id搜索约车订单 */
    public static Map<String, Object> advanceIdGetAppointOrderList(List<String> type, List<String> ids) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type & in ", "(" + String.join(",", type) + ")");
        }

        if (DataUtils.isNotNullOrEmpty(ids)) {
            params.put("advance_id & in ", "(" + String.join(",", ids) + ")");
        }

        params.put("@query", " id ");
        params.put("@table", " appoint_order ");

        return params;
    }

    /**
     * 通过条件获取im即时通讯账号id
     * @param type
     * @param ids
     * @return
     * @throws Exception
     */
    public static Map<String, Object> getImAccountIdByCondition(Integer type, List<Long> ids) throws Exception {

        log.info("type is==" + type + " ids is==" + ids);

        if (null == type || null == ids || 0 == ids.size()) {
            log.info("args is null or size is zero");
            throw new Exception("args can not be null or size is zero");
        }

        Map<String, Object> params = new HashMap<>(16);
        params.put("1", type);
        params.put("2", ids);

        Map<String, Object> sqlInfo = new HashMap<>(16);
        String queryCondition = "";

        for (int i = 1; i < params.size() + 1; ++i) {
            String token = i + "";
            if (null == params.get(token)) {
                continue;
            }

            switch (token) {
                case "1":
                queryCondition = " and " + getSqlByTypeToGetImAccountId(type);
                    break;
                case "2":
                queryCondition = queryCondition + " and " + getSqlByIdsToGetImAccountId(ids);
                    break;
                default:
                    break;
            }
        }

        if (!queryCondition.isEmpty())
            sqlInfo.put("1", " 1 " + queryCondition);

        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", " im_account");

        return sqlInfo;
    }

    private static String getSqlByTypeToGetImAccountId(Integer type) {

        log.info("type is==" + type);

        return "type = " + type;
    }

    private static String getSqlByIdsToGetImAccountId(List<Long> ids) {

        log.info("ids is==" + ids);
        return "target_id in " + listValueToSqlKeyWordINValue(ids);
    }

    public static String listValueToSqlKeyWordINValue(List value) {
        log.info("list value is==" + value);

        String valueSql = "";
        for (int i = 0; i < value.size(); ++i) {
            if (0 == i) {
                valueSql = "(" + value.get(i);
            } else {
                valueSql = valueSql + " ," + value.get(i);
            }

            if (i == value.size() - 1) {
                valueSql = valueSql + ")";
            }
        }

        return valueSql;
    }

    /**考务活动列表
     *
     */
    public static Map<String, Object> getTestActivityListParams(String title, Long schoolId, Integer type,
            Integer status, Long startTime, Long endTime) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title  & like ", "'%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {
            params.put("create_at & >= ", startTime);
        }

        if (DataUtils.isNotNullOrEmpty(endTime)) {
            params.put("create_at & <= ", endTime);
        }

        params.put("@order", "  update_at desc ");
        params.put("@query", " id ");

        params.put("@table", " test_activity ");

        return params;
    }

    /**通过考务活动id获取考试记录
     *
     */
    public static Map<String, Object> getExamStudentsListParams(Long id) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("test_act_id", id);
        }
        params.put("@order", "  update_at desc ");
        params.put("@query", " id ");

        params.put("@table", " test_records ");

        return params;
    }

    /**搜索符合条件的考试学员
     *
     */
    public static Map<String, Object> getExamStudentsListParams(Integer type, Long schoolId, String mobile,
            Long coachId) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(type)) {
            //参加科二的考生
            if (type == 4) {
                params.put("progress & in ", "(" + Students.PROGRESS_TYPE_SUBJECT_TWOANDTHREE + ","
                        + Students.PROGRESS_TYPE_SUBJECT_TWO + ")");
            } else if (type == 5) {
                params.put("progress & in ", "(" + Students.PROGRESS_TYPE_SUBJECT_TWOANDTHREE + ","
                        + Students.PROGRESS_TYPE_SUBJECT_THREE + ")");
            } else if (type == 1 || type == 2 || type == 3) {
                params.put("progress", type - 1);
            } else if (type == 6) {
                params.put("progress", type);
            }
        }
        if (DataUtils.isNotNullOrEmpty(coachId)) {
            if (type == 4) {
                params.put("section_two_coach_id", coachId);
            } else if (type == 5) {
                params.put("section_three_coach_id", coachId);
            }
        }
        //搜索驾校id会覆盖掉搜索渠道的驾校类型搜索
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile & like ", "'" + mobile + "%'");
        }

        //未冻结学员才能参加考试
        params.put("status", Students.STATUS_ON);
        params.put("@query", "id");
        params.put("@order", "create_at desc");
        params.put("@table", "students");

        log.info("params ======" + params);

        return params;

    }

    /**通过科目和考题查询考试记录
     *
     */
    public static Map<String, Object> getCountsByConditonsParams(Integer type, Integer score,
            List<Long> studentIdList) {
        Map<String, Object> countsParams = new HashMap();

        if (DataUtils.isNotNullOrEmpty(studentIdList)) {
            String ids = StringUtils.join(studentIdList, ",");
            countsParams.put("student_id  & in", "(" + ids + ")");
        }
        if (DataUtils.isNotNullOrEmpty(type) && type == 3) {
            countsParams.put("type", 1);
        } else if (DataUtils.isNotNullOrEmpty(type) && type == 6) {
            countsParams.put("type", 4);
        }
        if (DataUtils.isNotNullOrEmpty(score)) {

            countsParams.put("correct & >= ", score);
        }

        countsParams.put("@group", " student_id ");
        countsParams.put("@query", " student_id ");
        countsParams.put("@table", " subject_exam ");

        return countsParams;
    }

    /**
     * 获得教练推荐学员
     */
    public static Map<String, Object> getRecommendStudentsByConditonsParams(Integer type, Long startTime, Long endTime,
            List<Long> examStudentsIds) {
        Map<String, Object> countsParams = new HashMap();

        if (DataUtils.isNotNullOrEmpty(type) && type == 4) {
            countsParams.put("type", 2);
        } else if (DataUtils.isNotNullOrEmpty(type) && type == 5) {
            countsParams.put("type", 3);
        }
        if (DataUtils.isNotNullOrEmpty(startTime)) {

            countsParams.put("create_at & >= ", startTime);
        }
        if (DataUtils.isNotNullOrEmpty(endTime)) {

            countsParams.put("create_at & <= ", endTime);
        }
        if (DataUtils.isNotNullOrEmpty(examStudentsIds)) {
            String ids = StringUtils.join(examStudentsIds, ",");
            countsParams.put("student_id  & in", "(" + ids + ")");
        }
        countsParams.put("@group", " student_id ");
        countsParams.put("@query", " student_id ");
        countsParams.put("@table", " subject_exam ");

        return countsParams;
    }

    /**
     * 通过一般条件获得教练推荐学员
     */
    public static Map<String, Object> getRecommendStudents(Long studentId , Integer type , Long schoolId , String mobile ,
                                                           Long coachId , String coachMobile ) {
        Map<String, Object> params = new HashMap();

        if (DataUtils.isNotNullOrEmpty(studentId)) {
            params.put("stu_id", studentId);
        }
        if (DataUtils.isNotNullOrEmpty(type) && type == 4) {
            params.put("subject", 2);
        } else if (DataUtils.isNotNullOrEmpty(type) && type == 5) {
            params.put("subject", 3);
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("mobile", mobile);
        }
        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach_id", coachId);
        }
        if (DataUtils.isNotNullOrEmpty(coachMobile)) {
            params.put("coach_mobile", coachMobile);
        }

        params.put("@query", " id ");
        params.put("@table", " coach_recommend ");

        return params;
    }
    /**
     * 通过学生ID获取教练推荐时间
     */
    public static Map<String, Object> getRecommendStudentsByStudentId(Long studentId) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(studentId)) {
            params.put("stu_id", studentId);
        }
        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " coach_recommend ");

        return params;
    }

    /**
     * 成绩汇总获取学生
     */
    public static  Map<String,Object> getTestRecordStudents(Long cityId , Long schoolId , String param ,Long startAt , Long endAt ,Integer progress){
        Map<String, Object> params = new HashMap<>();

        params.put("certification", 1);

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("school_id", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(param)) {
            params.put("mobile & like", " '%" + param + "%'" + "or nick like '%" + param + "%'"
                    + " or identification like '%" + param + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" registration_date & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" registration_date & <= ", endAt);
        }
        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " students");

        return params;
    }

    /**
     * 成绩汇总获取chengji
     */
    public static Map<String, Object> getTestRecordBySids(List<Long> sList) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(sList)) {
            params.put(" stu_id & in ", "('" + org.apache.commons.lang3.StringUtils.join(sList, "','") + "')");
        }
        params.put("pass", 1);

        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " test_records");

        return params;
    }

    /**
     * 通过姓名获取教练
     * @param name
     * @return
     */
    public static Map<String,Object> getCoachIdByName(String name) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like ", "'%" + name + "%'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " coach");

        return params;
    }

    /**
     * 通过姓名获取学生Id
     * @param name
     * @return
     */
    public static Map<String,Object> getStudentIdByName(String name) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like ", " '%" + name + "%'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " students");

        return params;
    }

    /**
     * 通过考试通过获取消息IDs
     * @param id
     * @param targetReceive
     * @return
     */
    public static Map<String,Object> getMessageIdsByTestActId(Long id , Integer targetReceive ) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(id)) {
            params.put("affair_id", id);
        }
        params.put("message_type",1 );
        params.put("target_receive",targetReceive );
        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", " user_message");

        return params;
    }
}
