package com.ptteng.util;

import com.gemantic.common.util.PasswordUtils;
import com.ptteng.yi.nucleus.model.Card;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.SimpleDateFormat;
import java.util.*;

public class CardUtil {
    private static final Log log = LogFactory.getLog(CardUtil.class);

    /**约定卡券只能在本城市使用，一次生成不超过1000张，编号前三位表示城市ID，补足3位，中间14位为时间字符串，
    月、日、时、分、秒补足两位，后三位为卡券序号，补足三位*/
    public static List<Card> createCardList(Long tid, Integer expire, String schools, String classes, Long managerId,
            Long cityId, Integer amount) throws Exception {

        if (amount < 1 || tid == null || schools == null || classes == null || managerId == null || cityId == null) {
            return new ArrayList<>();
        }

        List<Card> cardList = new ArrayList<>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
        long t = expire.longValue() * 86400000;
        Long expireAt = simpleDateFormat1.parse(simpleDateFormat1.format(new Date(System.currentTimeMillis())))
                .getTime() + t;
        log.info("==============t: " + t);
        log.info("==============expireAt: " + expireAt);
        String time = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        String cid = String.format("%03d", cityId);

        //批量生成密码
        Map<String, List<String>> pwdMap = generatePwdList(8, 0, amount);
        List<String> pwdList = pwdMap.get("1");//明文密码
        log.info(" batch generate , pwdList size = " + pwdList.size());
        List<String> md5pwdList = pwdMap.get("2");//暗文密码
        log.info(" batch generate , md5pwdList size = " + md5pwdList.size());

        for (int i = 0; i < amount; i++) {
            Card card = new Card();
            String number = cid + time + String.format("%03d", i + 1);

            card.setNumber(number);

            card.setTid(tid);

            card.setMd5Pwd(md5pwdList.get(i));

            card.setPwd(pwdList.get(i));

            card.setOwnerId(-1L);

            card.setOwnerMobile("");

            card.setOwnerName("");

            card.setVerifiedBy(-1L);

            card.setSchools(schools);

            card.setClasses(classes);

            card.setStatus(1);

            card.setExchangeAt(-1L);

            card.setUseAt(-1L);

            card.setVerifyAt(-1L);

            card.setExpireAt(expireAt);

            card.setCreateBy(managerId);

            card.setUpdateBy(managerId);

            cardList.add(card);

        }

        return cardList;
    }

    /**
     * 获取随机字母数字组合
     *
     * @param length
     *            字符串长度
     *@param end 生成字符串个数 end - start+1=count
     *
     * @return
     */
    public static Map<String, List<String>> generatePwdList(Integer length, Integer start, Integer end) {
        Random random = new Random();
        Map<String, List<String>> map = new HashMap<>();
        List<String> md5PwdList = new ArrayList<>();
        List<String> pwdList = new ArrayList<>();
        for (int j = start - 1; j < end - 1; j++) {
            String str = "";

            for (int i = 0; i < length; i++) {
                if (i == length - length) {
                    String num1 = String.valueOf(random.nextInt(10));
                    str += num1;

                } else if (i == length - 6) {
                    int choice = random.nextBoolean() ? 97 : 97;// 取得65大写字母还是97小写字母
                    char letter1 = (char) (choice + random.nextInt(26));
                    str += letter1;

                } else if (i == length - 4) {
                    String num2 = String.valueOf(random.nextInt(10));
                    str += num2;

                } else if (i == length - 2) {
                    int choice = random.nextBoolean() ? 97 : 97;// 取得65大写字母还是97小写字母
                    char letter2 = (char) (choice + random.nextInt(26));
                    str += letter2;

                } else {
                    boolean b = random.nextBoolean();
                    if (b) { // 字符串
                        int choice = random.nextBoolean() ? 97 : 97;// 取得65大写字母还是97小写字母
                        char letter3 = (char) (choice + random.nextInt(26));
                        str += letter3;

                    } else { // 数字
                        String num3 = String.valueOf(random.nextInt(10));
                        str += num3;

                    }
                }

            }
            // log.info(" str = "+str);
            String upperStr = str.toUpperCase();
            //log.info("  upperStr =" + upperStr);
            pwdList.add(str);
            str = PasswordUtils.encode(upperStr);
            md5PwdList.add(str);

        }
        map.put("1", pwdList);
        map.put("2", md5PwdList);

        return map;
    }

    public static void main(String[] args) throws Exception {
        //        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        //        String time = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        //        String c = String.format("%03d", 1L);
        //        System.out.println(c+time);
        //
        //        System.out.println(generatePwdList(8, 0, 2));

        //        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        //        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
        //        Integer x = 10;
        //        Integer t = x*86400000;
        //        Long expireAt = simpleDateFormat1.parse(simpleDateFormat1.format(new Date(System.currentTimeMillis()))).getTime() + t.longValue();
        //
        //        System.out.println(t);
        //        System.out.println(Integer.MAX_VALUE);
        //        System.out.println(System.currentTimeMillis());
        //        System.out.println(expireAt);

    }
}
