package com.ptteng.model;

import com.ptteng.yi.nucleus.model.EnrollmentDetail;
import org.apache.commons.collections.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CenterFinance {
    private Long schoolId;

    private BigDecimal totalAmount;

    private BigDecimal serviceFee;

    private BigDecimal settlingAmount;

    private BigDecimal settledAmount;

    private BigDecimal prepareSettlement;

    private BigDecimal amountOfPaidToSchool;

    private int enrollmentNumber;

    public CenterFinance() {
        this.totalAmount = new BigDecimal("0");
        this.serviceFee = new BigDecimal("0");
        this.settlingAmount = new BigDecimal("0");
        this.settledAmount = new BigDecimal("0");
        this.prepareSettlement = new BigDecimal("0");
        this.amountOfPaidToSchool = new BigDecimal("0");
    }

    public Long getSchoolId() {
        return schoolId;
    }

    public void setSchoolId(Long schoolId) {
        this.schoolId = schoolId;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getServiceFee() {
        return serviceFee;
    }

    public void setServiceFee(BigDecimal serviceFee) {
        this.serviceFee = serviceFee;
    }

    public BigDecimal getSettlingAmount() {
        return settlingAmount;
    }

    public void setSettlingAmount(BigDecimal settlingAmount) {
        this.settlingAmount = settlingAmount;
    }

    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    public BigDecimal getPrepareSettlement() {
        return prepareSettlement;
    }

    public void setPrepareSettlement(BigDecimal prepareSettlement) {
        this.prepareSettlement = prepareSettlement;
    }

    public BigDecimal getAmountOfPaidToSchool() {
        return amountOfPaidToSchool;
    }

    public void setAmountOfPaidToSchool(BigDecimal amountOfPaidToSchool) {
        this.amountOfPaidToSchool = amountOfPaidToSchool;
    }

    public Integer getEnrollmentNumber() {
        return enrollmentNumber;
    }

    public void setEnrollmentNumber(Integer enrollmentNumber) {
        this.enrollmentNumber = enrollmentNumber;
    }

    @Override
    public String toString() {
        return "Finance{" + "schoolId=" + schoolId + ", totalAmount=" + totalAmount + ", serviceFee=" + serviceFee
                + ", settlingAmount=" + settlingAmount + ", settledAmount=" + settledAmount + ", prepareSettlement="
                + prepareSettlement + ", amountOfPaidToSchool=" + amountOfPaidToSchool + ", enrollmentNumber="
                + enrollmentNumber + '}';
    }

    /**
     *  统计运营中心财务状况方法
     *  @param enrollmentDetailList 报名学员详情集合
     *  @result Finance 财务统计对象
     * */
    public static CenterFinance countAmountOfCenter(List<EnrollmentDetail> enrollmentDetailList) {
        CenterFinance centerFinance = new CenterFinance();

        if (CollectionUtils.isEmpty(enrollmentDetailList)) {
            return centerFinance;
        }

        for (int i = 0; i < enrollmentDetailList.size(); i++) {
            EnrollmentDetail enrollmentDetail = enrollmentDetailList.get(i);

            centerFinance.setTotalAmount(centerFinance.getTotalAmount().add(enrollmentDetail.getPaymentAmount()));
            centerFinance.setServiceFee(centerFinance.getServiceFee().add(enrollmentDetail.getServiceFee()));
            centerFinance.setAmountOfPaidToSchool(
                    centerFinance.getAmountOfPaidToSchool().add(enrollmentDetail.getActualIncome()));
            if (enrollmentDetail.getWithdrawStatus() == EnrollmentDetail.HAS_WITHDRAW) {
                centerFinance
                        .setSettledAmount(centerFinance.getSettledAmount().add(enrollmentDetail.getActualIncome()));
            }
        }
        return centerFinance;
    }

    /**
     *
     *
     */
    public static Map<Long, CenterFinance> generateSchoolFinanceMap(List<EnrollmentDetail> enrollmentDetailList) {
        Map<Long, CenterFinance> financeMap = new HashMap<>();

        for (int i = 0; i < enrollmentDetailList.size(); i++) {
            EnrollmentDetail enrollmentDetail = enrollmentDetailList.get(i);

            if (financeMap.get(enrollmentDetail.getSchoolId()) == null) {
                CenterFinance centerFinance = new CenterFinance();
                financeMap.put(enrollmentDetail.getSchoolId(), centerFinance);
            }
        }

        return financeMap;
    }

    /**
     *
     *
     * */
    public static List<CenterFinance> countAmountOfSchools(List<EnrollmentDetail> enrollmentDetailList,
            Map<Long, CenterFinance> financeMap) {
        for (int i = 0; i < enrollmentDetailList.size(); i++) {
            EnrollmentDetail enrollmentDetail = enrollmentDetailList.get(i);
            CenterFinance centerFinance = financeMap.get(enrollmentDetail.getSchoolId());

            centerFinance.setTotalAmount(centerFinance.getTotalAmount().add(enrollmentDetail.getPaymentAmount()));
            centerFinance.setServiceFee(centerFinance.getServiceFee().add(enrollmentDetail.getServiceFee()));
            centerFinance.setAmountOfPaidToSchool(
                    centerFinance.getAmountOfPaidToSchool().add(enrollmentDetail.getActualIncome()));
            if (enrollmentDetail.getWithdrawStatus() == EnrollmentDetail.HAS_WITHDRAW) {
                centerFinance
                        .setSettledAmount(centerFinance.getSettledAmount().add(enrollmentDetail.getActualIncome()));
            } else {
                if (enrollmentDetail.getStatus() == EnrollmentDetail.HAS_RECEIVED) {
                    centerFinance.setSettlingAmount(
                            centerFinance.getSettlingAmount().add(enrollmentDetail.getActualIncome()));
                } else {
                    centerFinance.setPrepareSettlement(
                            centerFinance.getPrepareSettlement().add(enrollmentDetail.getActualIncome()));
                }
            }
            centerFinance.setEnrollmentNumber(centerFinance.getEnrollmentNumber() + 1);
            centerFinance.setSchoolId(enrollmentDetail.getSchoolId());
        }

        return new ArrayList<>(financeMap.values());
    }
}
