package com.ptteng.controller.system;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.common.yi.model.Manager;
import com.ptteng.common.yi.model.Role;
import com.ptteng.common.yi.service.ManagerService;
import com.ptteng.common.yi.service.RoleService;
import com.ptteng.interceptor.CookieConstant;
import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.AppointOrder;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.Probation;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.AppointOrderService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.ptteng.yi.nucleus.service.ProbationService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.pwd.PasswordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.*;

@Controller
public class SystemController {
    private static final Log log = LogFactory.getLog(SystemController.class);

    @Autowired
    private ManagerService managerService;

    @Autowired
    private RoleService roleService;

    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @Autowired
    private StudentsService studentsService;
    @Autowired
    private CoachService coachService;
    @Autowired
    private ProbationService probationService;
    @Autowired
    private AppointOrderService appointOrderService;

    /**
     * 游戏准备
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/login/index")
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
            Integer size) throws Exception {
        log.info(" welcome to manager index ");

        return "/index";
    }

    /**
     * 游戏准备
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/test")
    public String test(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
            Integer size) throws Exception {
        log.info(" welcome to manager index ");
        return "/demo/test";
    }

    @RequestMapping(value = "/nologin")
    public String noLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
            Integer size) throws Exception {
        log.info(" login wrong ");
        model.addAttribute("code", -5018);
        return "/data/json";
    }

    @RequestMapping(value = "/noPermissin")
    public String noPermission(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
            Integer size) throws Exception {
        log.info(" login noPermission ");
        model.addAttribute("code", -5020);
        return "/data/json";
    }

    /**
     * 管理员登录
     *
     * @param request
     * @param response
     * @param model
     * @param name
     * @param pwd
     * @return
     */

    //1、管理员登录
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
            String pwd) {
        log.info(" welcome to manager login ");

        try {
            List<Long> managerIds = this.managerService.getManagerIdsByName(name, 0, Integer.MAX_VALUE);
            log.info(name + " get managerIDs  " + managerIds);
            if (managerIds == null || managerIds.isEmpty() || managerIds.size() > 1) {
                log.info(name + " not get any user ");
                model.addAttribute("code", -5003);

            } else {
                log.info(name + "  get user " + managerIds.get(0));
                Manager manager = this.managerService.getObjectById(managerIds.get(0));
                if (PasswordUtils.authenticatePassword(manager.getPwd(), pwd)
                        && manager.getStatus().equals(Manager.STATUS_USING)) {
                    log.info(managerIds.get(0) + " login ");
                    Map<String, String> maps = new HashMap();
                    maps.put(CookieConstant.Cookie_WEB_ManagerName, manager.getName());

                    //maps.put(CookieConstant.Cookie_WEB_PuserPublicsHash, manager.getPublicsHash());
                    //maps.put(CookieConstant.Cookie_WEB_PuserPublicsHash, "-2042484612");

                    maps.put(CookieUtil.USER_ID, manager.getId() + "");
                    cookieUtil.setIdentity(request, response, maps, manager.getId());

                    Role role = roleService.getObjectById(manager.getRoleID());
                    model.addAttribute("code", 0);
                    model.addAttribute("manager", manager);
                    model.addAttribute("role", role);
                    log.info(managerIds.get(0) + " login over ");
                } else {
                    log.info(managerIds.get(0) + " has wrong pwd ");
                    model.addAttribute("code", -5004);
                    model.addAttribute("result", null);
                }
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager login error,name is  " + name);
            model.addAttribute("code", -5002);
            model.addAttribute("result", null);
        }

        return "/data/login";
    }

    /**
     * 退出系统
     *
     * @param request
     * @param response
     * @param model
     * @return
     */

    //2.注销
    @RequestMapping(value = "/a/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager logout ");

        try {
            cookieUtil.clearCookie(response);

            model.addAttribute("code", 0);
            model.addAttribute("result", "/login/index");

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager logout error  ");
            model.addAttribute("code", -5005);
            model.addAttribute("result", null);
        }

        return "/data/json";
    }

    //3.首页数据
    @RequestMapping(value = "/a/u/center/summation", method = RequestMethod.GET)
    public String getCenterSummation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long cityId) {
        log.info(" welcome to manager logout ");

        try {
            Long currentTime = System.currentTimeMillis();
            Long zero = currentTime / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
            Map<String, Object> clueTotalMap = DynamicUtil.getStudentClueListParams(null, null, null, null, null,
                    cityId);
            Integer clueTotal = probationService
                    .getIdsByDynamicCondition(Probation.class, clueTotalMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> stuTotalMap = DynamicUtil.getStuIds(null, null, null, null, null);
            Integer stuTotal = studentsService
                    .getIdsByDynamicCondition(Students.class, stuTotalMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> coachTotalMap = DynamicUtil.getCoachIdsBySchoolIdAndMore(null, null, null);
            Integer coachTotal = coachService.getIdsByDynamicCondition(Coach.class, coachTotalMap, 0, Integer.MAX_VALUE)
                    .size();
            Map<String, Object> certifiedStuMap = DynamicUtil.getStuIds(null, cityId, 1, null, null);
            Integer certifiedStu = studentsService
                    .getIdsByDynamicCondition(Students.class, certifiedStuMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> newStuMap = DynamicUtil.getStuIds(null, cityId, 1, zero, currentTime);
            Integer newStu = studentsService.getIdsByDynamicCondition(Students.class, newStuMap, 0, Integer.MAX_VALUE)
                    .size();
            Map<String, Object> certifiedCoachMap = DynamicUtil.getCoachIdsBySchoolIdAndMore(null, cityId, 1);
            Integer certifiedCoach = coachService
                    .getIdsByDynamicCondition(Coach.class, certifiedCoachMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> practiceOrderTotalMap = DynamicUtil.getOrderByCParam(cityId, null, null, null);
            Integer practiceOrderTotal = appointOrderService
                    .getIdsByDynamicCondition(AppointOrder.class, practiceOrderTotalMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> practiceOrderYesterdayMap = DynamicUtil.getOrderByCParam(cityId, null, null, zero);
            Integer practiceOrderYesterday = appointOrderService
                    .getIdsByDynamicCondition(AppointOrder.class, practiceOrderYesterdayMap, 0, Integer.MAX_VALUE)
                    .size();
            Map<String, Object> practiceOrderMap = DynamicUtil.getOrderByCParam(cityId, null, zero, currentTime);
            Integer practiceOrder = appointOrderService
                    .getIdsByDynamicCondition(AppointOrder.class, practiceOrderMap, 0, Integer.MAX_VALUE).size();
            model.addAttribute("clueTotal", clueTotal);
            model.addAttribute("stuTotal", stuTotal);
            model.addAttribute("coachTotal", coachTotal);
            model.addAttribute("certifiedStu", certifiedStu);
            model.addAttribute("newStu", newStu);
            model.addAttribute("certifiedCoach", certifiedCoach);
            model.addAttribute("practiceOrderTotal", practiceOrderTotal);
            model.addAttribute("practiceOrderYesterday", practiceOrderYesterday);
            model.addAttribute("practiceOrder", practiceOrder);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager logout error  ");
            model.addAttribute("code", -100000);
            model.addAttribute("result", null);
        }

        return "common-yi-service/center/json/summationList";
    }

    //3.首页数据
    @RequestMapping(value = "/a/u/school/summation", method = RequestMethod.GET)
    public String getSchoolSummation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long schoolId) {
        log.info(" welcome to manager logout ");

        try {
            Long currentTime = System.currentTimeMillis();
            Long zero = currentTime / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
            Map<String, Object> stuTotalMap = DynamicUtil.getStuIds(schoolId, null, 1, null, null);
            Integer stuTotal = studentsService
                    .getIdsByDynamicCondition(Students.class, stuTotalMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> coachTotalMap = DynamicUtil.getCoachIdsBySchoolIdAndMore(schoolId, null, 1);
            Integer coachTotal = coachService.getIdsByDynamicCondition(Coach.class, coachTotalMap, 0, Integer.MAX_VALUE)
                    .size();
            Map<String, Object> newStuMap = DynamicUtil.getStuIds(schoolId, null, 1, zero, currentTime);
            Integer newStu = studentsService.getIdsByDynamicCondition(Students.class, newStuMap, 0, Integer.MAX_VALUE)
                    .size();
            Map<String, Object> practiceOrderTotalMap = DynamicUtil.getOrderByCParam(null, schoolId, null, null);
            Integer practiceOrderTotal = appointOrderService
                    .getIdsByDynamicCondition(AppointOrder.class, practiceOrderTotalMap, 0, Integer.MAX_VALUE).size();
            Map<String, Object> practiceOrderYesterdayMap = DynamicUtil.getOrderByCParam(null, schoolId, null, zero);
            Integer practiceOrderYesterday = appointOrderService
                    .getIdsByDynamicCondition(AppointOrder.class, practiceOrderYesterdayMap, 0, Integer.MAX_VALUE)
                    .size();
            Map<String, Object> practiceOrderMap = DynamicUtil.getOrderByCParam(null, schoolId, zero, currentTime);
            Integer practiceOrder = appointOrderService
                    .getIdsByDynamicCondition(AppointOrder.class, practiceOrderMap, 0, Integer.MAX_VALUE).size();
            model.addAttribute("clueTotal", null);
            model.addAttribute("stuTotal", stuTotal);
            model.addAttribute("coachTotal", coachTotal);
            model.addAttribute("certifiedStu", null);
            model.addAttribute("newStu", newStu);
            model.addAttribute("certifiedCoach", null);
            model.addAttribute("practiceOrderTotal", practiceOrderTotal);
            model.addAttribute("practiceOrderYesterday", practiceOrderYesterday);
            model.addAttribute("practiceOrder", practiceOrder);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager logout error  ");
            model.addAttribute("code", -100000);
            model.addAttribute("result", null);
        }

        return "common-yi-service/center/json/summationList";
    }

    /**
     * 无需修改名字的文件尾缀，<b>必须有序存放</b> <br>
     * 例如："apk" < "jpeg" < "jpg"
     */
    // 图片上传
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @RequestParam MultipartFile file, @PathVariable String module) throws Exception {
        log.info("hello upload " + module);
        if (org.apache.commons.lang3.StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        log.info(file.getOriginalFilename());

        //Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            log.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());
            String fileName = "";

            if ("apk".equals(extend)) {
                fileName = file.getOriginalFilename();
            } else {
                fileName = UUID.randomUUID().toString() + "." + extend;

            }

            log.info("new name is " + fileName);
            //  /data/temp/
            log.info("--------------------------------------------");
            String filePath = "/data/temp/" + fileName;
            log.info(filePath);
            File tempPic = new File(filePath);
            log.info("--------------------------------------------");
            file.transferTo(tempPic);
            log.info("--------------------------------------------");

            String url = this.imgStorageUtil.imgStorage(module, module + "/" + fileName, filePath);
            log.info(module + module + "/" + fileName + filePath);
            log.info("--------------------------------------------");
            log.info(url);
            log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
                    + " access url is " + url);
            tempPic.delete();
            log.info(file.getOriginalFilename() + " delete success !");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            return "/common/success";
        }

    }

}
