package com.ptteng.controller.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.Provinces;
import com.ptteng.yi.pub.service.ProvincesService;

/**
 * Provinces  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProvincesController {
	private static final Log log = LogFactory.getLog(ProvincesController.class);

	@Autowired
	private ProvincesService provincesService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/provinces/list ", method = RequestMethod.GET)
	public String getProvincesIdsByProvinceidJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = provincesService.getProvincesIds(start, size);
			log.info("get countProvincesIds  size is " + ids.size());

			List<Provinces> provincesList = provincesService.getObjectsByIds(ids);
			log.info("get provinces data is " + provincesList.size());

			Integer total = provincesService.countProvincesIds();
			log.info("get provinces count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("provincesList", provincesList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get provinces list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-pub-service/provinces/json/provincesListJson";
	}

	@RequestMapping(value = "/a/provinces/{id}", method = RequestMethod.GET)
	public String getProvincesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Provinces provinces = provincesService.getObjectById(id);
			log.info("get provinces data is " + provinces);

			model.addAttribute("code", 0);

			model.addAttribute("provinces", provinces);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get provinces error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-pub-service/provinces/json/provincesDetailJson";
	}

	//	@RequestMapping(value = "/a/provinces", method = RequestMethod.POST)
	//	public String addProvincesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Provinces provinces) throws Exception {
	//
	//		log.info("update provinces : provinces= " + provinces);
	//
	//		try {
	//			provinces.setId(null);
	//
	//			provincesService.insert(provinces);
	//
	//			model.addAttribute("code", 0);
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("add provinces error ");
	//			model.addAttribute("code", -6002);
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//	@RequestMapping(value = "/a/provinces/{id}", method = RequestMethod.DELETE)
	//	public String deleteProvincesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
	//			throws Exception {
	//
	//		log.info("delete provinces : id= " + id);
	//		try {
	//			provincesService.delete(id);
	//
	//			log.info("add provinces success");
	//			model.addAttribute("code", 0);
	//
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("delete provinces error,id is  " + id);
	//			model.addAttribute("code", -6004);
	//
	//		}
	//
	//		return "/data/json";
	//	}

	//
	//	@RequestMapping(value = "/a/multi/provinces", method = RequestMethod.GET)
	//	public String getMultiProvincesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Long[] ids)
	//			throws Exception {
	//
	//		List<Long> idList = new ArrayList();
	//	   if (ids == null) {
	//
	//		} else {
	//			idList = Arrays.asList(ids);
	//		}
	//		try {
	//
	//
	//
	//			List<Provinces> provincesList = provincesService.getObjectsByIds(idList);
	//			log.info("get  provinces data is " + provincesList);
	//
	//			model.addAttribute("code", 0);
	//			model.addAttribute("total",provincesList.size());
	//
	//			model.addAttribute("provincesList", provincesList);
	//
	//		} catch (Throwable t) {
	//			log.error(t.getMessage());
	//			log.error("get provinces error,id is  " + idList);
	//			model.addAttribute("code", -100000);
	//		}
	//
	//		return "/yi-public-service/provinces/json/provincesListJson";
	//	}

}
