package com.ptteng.controller.system;

import com.ptteng.common.yi.model.Module;
import com.ptteng.common.yi.service.ModuleService;
import com.ptteng.common.yi.service.RoleModuleService;
import com.ptteng.common.yi.service.RoleService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.util.*;

/**
 * Module  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class ModuleController {
	private static final Log log = LogFactory.getLog(ModuleController.class);

	@Autowired
	private ModuleService moduleService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private RoleService roleService;

	@Autowired
	private RoleModuleService roleModuleService;

	@RequestMapping(value = "/web/c/module", method = RequestMethod.GET)
	public String getModuleIdsByTypeList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String type) throws Exception {
		log.info("/web/module  to /module/view/moduleList");
		return "/module/view/moduleList";
	}

	//16.查询模块列表
	@RequestMapping(value = "/a/u/module", method = RequestMethod.GET)
	public String getModuleIdsByType(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, Integer moduleType) throws Exception {

		if (DataUtils.isNullOrEmpty(moduleType)) {
			model.addAttribute("code", -8002);
			log.info("get data : id is  null");
			return "/common/success";
		}

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}

		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		int total = 0;

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			Boolean next = false;
			size += 1;
			List<Long> ids = new ArrayList<>();
			Map<String, Object> map = new HashMap<>();
			map = DynamicUtil.getModuleListbyModuleType(moduleType);
			ids = moduleService.getIdsByDynamicCondition(Module.class, map, start, size);
			total = moduleService.getIdsByDynamicCondition(Module.class, map, 0, Integer.MAX_VALUE).size();
			log.info("get countModuleIdsByType size is " + ids.size());

			if (ids != null && ids.size() > 0) {

				if (size.equals(ids.size())) {
					next = true;
					log.info("ss  " + ids.subList(0, size - 1));
					model.addAttribute("ids", ids.subList(0, size - 1));
				} else {
					log.info("ss  " + ids.subList(0, ids.size()));
					model.addAttribute("ids", ids.subList(0, ids.size()));
				}
			} else {
				model.addAttribute("ids", ids);
			}

			model.addAttribute("code", 0);
			model.addAttribute("size", size - 1);
			model.addAttribute("total", total);

			model.addAttribute("page", page);

			model.addAttribute("next", next);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get module list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-yi-service/module/json/moduleListJson";
	}

	//17.根据ID查找模块
	@RequestMapping(value = "/a/u/module/{mid}", method = RequestMethod.GET)
	public String getModuleDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long mid) throws Exception {

		log.info("get data : id= " + mid);
		try {
			List<Long> rmids = roleModuleService.getRoleModuleIdsByMid(mid, 0, Integer.MAX_VALUE);
			log.info(" rmids is  " + rmids);
			Module module = moduleService.getObjectById(mid);

			if (module == null) {
				model.addAttribute("code", -8002);
				log.info("get data : id is  null");
				return "/common/success";
			} else {
				log.info("get module data is " + module);
				model.addAttribute("module", module);
			}

			model.addAttribute("mid", mid);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get module error,id is  " + mid);
			model.addAttribute("code", -100000);
		}

		return "/common-yi-service/module/json/moduleDetailJson";
	}

	//18.增加模块
	@RequestMapping(value = "/a/u/module", method = RequestMethod.POST)
	public String addModule(HttpServletRequest request, HttpServletResponse response, ModelMap model, Module module)
			throws Exception {

		log.info("update module : module= " + module);

		try {
			if (module.getName() == null || module.getName().trim().equals("")) {
				log.info("name is null ");
				model.addAttribute("code", -8000);
				return "/common/success";
			}
			if (module.getName().length() > 30 || module.getName().length() < 0) {
				log.info("name is null ");
				model.addAttribute("code", -8001);
				return "/common/success";
			}

			module.setId(null);

			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

			log.info("curr login user id " + uid);

			module.setUpdateBy(uid);
			module.setCreateBy(uid);

			Long id = moduleService.insert(module);

			log.info("insert success id " + id);

			request.setAttribute("objectId", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add module error ");
			model.addAttribute("code", -100000);
		}

		return "/common/success";
	}

	/**
	 * 修改模块
	 * @param request
	 * @param response
	 * @param model
	 * @param module
	 * @return
	 * @throws Exception
	 */
	//19.修改模块
	@RequestMapping(value = "/a/u/module/{mid}", method = RequestMethod.PUT)
	public String updateModule(HttpServletRequest request, HttpServletResponse response, ModelMap model, Module module)
			throws Exception {

		log.info("update module : module= " + module);

		try {
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			Module m = moduleService.getObjectById(module.getId());
			if (m == null) {
				log.info("module is null ");
				model.addAttribute("code", -8002);
				return "/common/success";
			} else {
				if (module == null) {
					log.info("module is null ");
					model.addAttribute("code", -1004);
					return "/common/success";
				}

				if (module.getName() == null || module.getName().trim().equals("")) {
					log.info("name is null ");
					model.addAttribute("code", -8000);
					return "/common/success";
				}
				if (module.getName().length() > 30 || module.getName().length() < 0) {
					log.info("name is null ");
					model.addAttribute("code", -8001);
					return "/common/success";
				}

				module.setCreateBy(m.getCreateBy());
				module.setCreateAt(m.getCreateAt());
				module.setUpdateBy(Long.parseLong(userId));
				moduleService.update(module);

				model.addAttribute("code", 0);

				model.addAttribute("module", module);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update module error,id is  " + module.getId());
			model.addAttribute("code", -100000);

		}

		return "/common-yi-service/module/json/moduleDetailJson";
	}

	//20.删除模块
	@RequestMapping(value = "/a/u/module/{mid}", method = RequestMethod.DELETE)
	public String deleteModule(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long mid) throws Exception {

		log.info("delete module : id= " + mid);
		try {
			if (mid == null) {
				model.addAttribute("code", -1004);
			} else {
				Module module = moduleService.getObjectById(mid);

				if (module == null) {
					model.addAttribute("code", -8002);
					log.info("get data : id is  null");
				} else {
					List<Long> roleModulesIds = roleModuleService.getRoleModuleIdsByMid(mid, 0, Integer.MAX_VALUE);
					log.info("rolemodulesIds   " + roleModulesIds + "size   " + roleModulesIds.size());
					if (roleModulesIds != null && roleModulesIds.size() > 0) {

						model.addAttribute("code", -8003);
					} else {
						moduleService.delete(mid);
						log.info("add module success");
						model.addAttribute("code", 0);
					}

				}
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete module error,id is  " + mid);
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

	/**
	 * 批量获取模块详细信息
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	//21.批量获取模块详细信息
	@RequestMapping(value = "/a/u/multi/module", method = RequestMethod.GET)
	public String getMultiModule(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
		log.info("get module mid " + ids);
		List<Long> idList = new ArrayList();
		if (ids == null || ids.length <= 0) {
			model.addAttribute("code", 0);
			model.addAttribute("total", 0);
			model.addAttribute("size", 10);

		} else {
			idList = Arrays.asList(ids);
		}
		try {
			if (idList == null || idList.size() <= 0) {
				model.addAttribute("code", 0);
				model.addAttribute("total", 0);
				model.addAttribute("size", 10);
			} else {
				List<Module> moduleList = moduleService.getObjectsByIds(idList);

				if (moduleList != null && moduleList.size() > 0) {
					model.addAttribute("code", 0);

					model.addAttribute("size", 10);
					model.addAttribute("total", moduleList.size());
					model.addAttribute("moduleList", moduleList);

				} else {
					model.addAttribute("code", 0);

					model.addAttribute("size", 10);
					model.addAttribute("total", 0);
					model.addAttribute("moduleList", moduleList);
				}
			}
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get module error,id is  " + Arrays.toString(ids));
			model.addAttribute("code", -100000);
		}

		return "/common-yi-service/module/json/moduleMultiJson";
	}

	/**
	 * 返回id
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/module/id/{id}", method = RequestMethod.GET)
	public String getModule(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {
		log.info("/web/module/" + id + "  to /module/view/moduleDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		model.addAttribute("code", 0);
		return "/module/view/moduleDetail";
	}
}
