package com.ptteng.controller.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.Cities;
import com.ptteng.yi.pub.service.CitiesService;

/**
 * Cities  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CitiesController {
	private static final Log log = LogFactory.getLog(CitiesController.class);

	@Autowired
	private CitiesService citiesService;

	/**
	* 
	* @param 
	* @return 
	* @throws ServiceException
	* @throws ServiceDaoException
	*/

	@RequestMapping(value = "/a/cities/list ", method = RequestMethod.GET)
	public String getCitiesIdsByProvinceidJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size, Long provinceid) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = citiesService.getCitiesIdsByProvinceid(provinceid, start, size);
			log.info("get countCitiesIdsByProvinceid size is " + ids.size());

			List<Cities> citiesList = citiesService.getObjectsByIds(ids);
			log.info("get cities data is " + citiesList.size());

			Integer total = citiesService.countCitiesIdsByProvinceid(provinceid);
			log.info("get cities count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("citiesList", citiesList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get cities list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-pub-service/cities/json/citiesListJson";
	}

	@RequestMapping(value = "/a/cities/{id}", method = RequestMethod.GET)
	public String getCitiesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Cities cities = citiesService.getObjectById(id);
			log.info("get cities data is " + cities);

			model.addAttribute("code", 0);

			model.addAttribute("cities", cities);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get cities error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-pub-service/cities/json/citiesDetailJson";
	}
	//
	//	@RequestMapping(value = "/a/cities/{id}", method = RequestMethod.PUT)
	//	public String updateCitiesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Cities cities) throws Exception {
	//
	//		log.info("update cities : cities= " + cities);
	//
	//		try {
	//
	//			citiesService.update(cities);
	//
	//			model.addAttribute("code", 0);
	//
	//			model.addAttribute("cities", cities);
	//
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("update cities error,id is  " + cities.getId());
	//			model.addAttribute("code", -6003);
	//
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//	@RequestMapping(value = "/a/cities", method = RequestMethod.POST)
	//	public String addCitiesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Cities cities) throws Exception {
	//
	//		log.info("update cities : cities= " + cities);
	//
	//		try {
	//			cities.setId(null);
	//
	//			citiesService.insert(cities);
	//
	//			model.addAttribute("code", 0);
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("add cities error ");
	//			model.addAttribute("code", -6002);
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//	@RequestMapping(value = "/a/cities/{id}", method = RequestMethod.DELETE)
	//	public String deleteCitiesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
	//			throws Exception {
	//
	//		log.info("delete cities : id= " + id);
	//		try {
	//			citiesService.delete(id);
	//
	//			log.info("add cities success");
	//			model.addAttribute("code", 0);
	//
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("delete cities error,id is  " + id);
	//			model.addAttribute("code", -6004);
	//
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//
	//	@RequestMapping(value = "/a/multi/cities", method = RequestMethod.GET)
	//	public String getMultiCitiesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Long[] ids)
	//			throws Exception {
	//
	//		List<Long> idList = new ArrayList();
	//	   if (ids == null) {
	//
	//		} else {
	//			idList = Arrays.asList(ids);
	//		}
	//		try {
	//
	//
	//
	//			List<Cities> citiesList = citiesService.getObjectsByIds(idList);
	//			log.info("get  cities data is " + citiesList);
	//
	//			model.addAttribute("code", 0);
	//			model.addAttribute("total",citiesList.size());
	//
	//			model.addAttribute("citiesList", citiesList);
	//
	//		} catch (Throwable t) {
	//			log.error(t.getMessage());
	//			log.error("get cities error,id is  " + idList);
	//			model.addAttribute("code", -100000);
	//		}
	//
	//		return "/yi-public-service/cities/json/citiesListJson";
	//	}
	//
	//

}
