package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.pub.model.Message;
import com.ptteng.yi.pub.model.UserMessage;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.Version;
import com.ptteng.yi.pub.service.VersionService;

/**
 * Version  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class VersionController {
	private static final Log log = LogFactory.getLog(VersionController.class);

	@Autowired
	private VersionService versionService;

	/**
	 * create_by:qingshan
	 * create_at:2018.1.31
	 * 修改版本接口
	 * @param versionCode
	 * @param versionNumber
	 * @param url
	 * @param isForceUpdate
	 * @param summary
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/version/{id}", method = RequestMethod.PUT)
	public String updateVersion(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, String versionCode, Integer versionNumber, String url, Integer isForceUpdate,
			String summary) throws Exception {

		log.info("update versionId= " + id + " versionCode= " + versionCode + " versionNumber= " + versionNumber
				+ "url= " + url + " isForceUpdate = " + isForceUpdate + " summary= " + summary);
//		验参
		int paramsCode = ParamsUtil.checkParametersOfUpdateVersion(versionCode, versionNumber, url, isForceUpdate,
				summary);
		if (paramsCode != 0) {
				model.addAttribute("code", paramsCode);
			    return "/common/failure";
		}
		try {
			Version versionOld = new Version();
			Version versionNew = new Version();

				log.info("params check OK");
				versionOld = versionService.getObjectById(id);
				log.info("versionOld is " + versionOld);
				if (versionOld == null) {
					log.info("versionOld : " + id + " not exist");
					model.addAttribute("code", -27000);
					return "/common/success";
				} else {
					versionNew.setType(versionOld.getType());
					versionNew.setVersion_code(versionCode);
					versionNew.setVersion_number(versionNumber);
					versionNew.setUrl(url);
					versionNew.setOs(versionOld.getOs());
					versionNew.setIs_force_update(isForceUpdate);
					versionNew.setSummary(summary);
					log.info("insert versionNew : " + versionNew);
					Long versionNewId = versionService.insert(versionNew);
					model.addAttribute("code", 0);
					log.info("version update success,versionId is" + versionNewId);
				}

		} catch (Exception e) {
			e.printStackTrace();
			log.error(e.getMessage());
			log.error("update version error ");
			model.addAttribute("code", -100000);
		}
		return "/common/success";
	}

	/**
	 * create_by:qingshan
	 * create_at:2018.1.31
	 * 获取版本列表接口
	 *
	 * @param
	 * @return
	 * @throws Exception
	 */

	@RequestMapping(value = "/a/version", method = RequestMethod.GET)
	public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
		HashMap<String, String> errorMap = new HashMap<String, String>();
		HashMap<String, Long> numMap = new HashMap<String, Long>();
		HashMap<String, Object> objMap = new HashMap<String, Object>();

		try {

			//学员端
			/*Android*/
			Map<String, Object> paramsStudentAndroid = DynamicUtil.getPlQuery(2, 1);
			log.info("student android version params is :" + paramsStudentAndroid);
			List<Long> studentAndroidIds = versionService.getIdsByDynamicCondition(Version.class, paramsStudentAndroid,
					0, Integer.MAX_VALUE);
			log.info("student android version params get dynamic ids is :" + studentAndroidIds);
			if (CollectionUtils.isNotEmpty(studentAndroidIds)) {
				List<Version> studentAndroidVs = versionService.getObjectsByIds(studentAndroidIds);
				Collections.sort(studentAndroidVs);
				Version studentAndroidVersion = studentAndroidVs.get(0);
				model.addAttribute("studentAndroidVersion", studentAndroidVersion);
			}

			/*iOS*/
			Map<String, Object> paramsStudentIos = DynamicUtil.getPlQuery(1, 1);
			log.info("student android version params is :" + paramsStudentIos);
			List<Long> studentIosIds = versionService.getIdsByDynamicCondition(Version.class, paramsStudentIos, 0,
					Integer.MAX_VALUE);
			log.info("student android version params get dynamic ids is :" + studentIosIds);
			if (CollectionUtils.isNotEmpty(studentIosIds)) {
				List<Version> studentIosVersions = versionService.getObjectsByIds(studentIosIds);
				Collections.sort(studentIosVersions);
				Version studentIosVersioin = studentIosVersions.get(0);
				model.addAttribute("studentIosVersion", studentIosVersioin);
			}

			//教练端
			/*Android*/
			Map<String, Object> paramsCoachAndroid = DynamicUtil.getPlQuery(2, 2);
			log.info("coach android version params is :" + paramsCoachAndroid);
			List<Long> coachAndroids = versionService.getIdsByDynamicCondition(Version.class, paramsCoachAndroid, 0,
					Integer.MAX_VALUE);
			log.info("coach android version params get dynamic ids is :" + coachAndroids);
			if (CollectionUtils.isNotEmpty(coachAndroids)) {
				List<Version> coachAndroidVersions = versionService.getObjectsByIds(coachAndroids);
				Collections.sort(coachAndroidVersions);
				Version coachAndroidVersion = coachAndroidVersions.get(0);
				model.addAttribute("coachAndroidVersion", coachAndroidVersion);
			}

			/*iOS*/
			Map<String, Object> paramsCoachIos = DynamicUtil.getPlQuery(1, 2);
			log.info("student android version params is :" + paramsCoachIos);
			List<Long> coachIosIds = versionService.getIdsByDynamicCondition(Version.class, paramsCoachIos, 0,
					Integer.MAX_VALUE);
			log.info("student android version params get dynamic ids is :" + coachIosIds);
			if (CollectionUtils.isNotEmpty(coachIosIds)) {
				List<Version> coachIosVersions = versionService.getObjectsByIds(coachIosIds);
				Collections.sort(coachIosVersions);
				Version coachIosVersion = coachIosVersions.get(0);
				model.addAttribute("coachIosVersion", coachIosVersion);
			}

			model.addAttribute("code", 0);

		} catch (Exception e) {
			e.printStackTrace();
			log.error("try catch a exception!" + e);
			model.addAttribute("code", -100000);
		}
		return "/yi-pub-service/version/json/versionListJson";
	}
}
