package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

import com.ptteng.util.ManagerUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.pub.model.Message;
import com.ptteng.yi.pub.service.MessageService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.UserMessage;
import com.ptteng.yi.pub.service.UserMessageService;

/**
 * UserMessage  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserMessageController {
	private static final Log log = LogFactory.getLog(UserMessageController.class);
	@Autowired
	MessageService messageService;
	@Autowired
	private UserMessageService userMessageService;
	@Autowired
	private CookieUtil cookieUtil;

	/**
	 *create_by:qingshan
	 *create_at:2018.1.26
	 *新增消息列表接口
	 * @param messageType
	 * @param affairId
	 * @param target
	 * @param content
	 * @param noticeStatus
	 * @param pushType
	 * @param coachUids
	 * @param studentUids
	 * @param targetSend
	 * @param examSubject
	 * @param examTime
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/message", method = RequestMethod.POST)
	public String addUserMessage(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer messageType, Long affairId, Integer target, String content, Integer noticeStatus, Integer pushType,
			Long[] coachUids, Long[] studentUids, Integer targetSend, Integer progress, Integer examSubject,
			Long examTime) throws Exception {
		log.info("params === messageType=" + messageType + "affairId" + affairId + "target" + target + "content"
				+ content + "noticeStatus" + noticeStatus + "pushType" + pushType
				 + "targetSend" + targetSend + "progress" + progress + "examSubject"
				+ examSubject + "examTime" + examTime);
		log.info("studentUids are ");
		for (int i = 0; i <studentUids.length ; i++) {
			log.info(studentUids[i]+" ");
		}
		log.info("coachUids are ");
		for (int i = 0; i <coachUids.length ; i++) {
			log.info(coachUids[i]+" ");
		}
		//		验参
		int paramsCode = ParamsUtil.checkParametersOfAddUserMessage(messageType,  target, content,
				noticeStatus, pushType, coachUids, studentUids, targetSend, progress, examSubject, examTime);
		if (paramsCode != 0) {
				model.addAttribute("code", paramsCode);
			    return "/common/failure";
		}
		Message message = new Message();
		UserMessage userMessage = new UserMessage();
		try {
				//			    获取管理员id
				Long manager_id = ManagerUtil.getManagerId(cookieUtil, request);
				//				初步组装message
				message.setMessage_type(messageType);
				if (DataUtils.isNotNullOrEmpty(affairId)){
					message.setAffair_id(affairId);
				}
				message.setTarget(target);
				message.setContent(content);
				message.setPush_at(System.currentTimeMillis());
				message.setStatus(Message.SENDED_MESSAGE);
				message.setNotice_status(noticeStatus);
				message.setPush_type(pushType);
				message.setCreateBy(manager_id);
				message.setUpdateBy(manager_id);
				if ((DataUtils.isNullOrEmpty(examSubject) == false && DataUtils.isNullOrEmpty(examTime) == false)) {
					message.setExamSubject(examSubject);
					message.setExamTime(examTime);
				}
				//				初步组装userMessage
				userMessage.setMessage_type(messageType);
				if (DataUtils.isNotNullOrEmpty(affairId)){
					userMessage.setAffair_id(affairId);
				}
				userMessage.setTarget_send(targetSend);
				userMessage.setStatus(UserMessage.UNREADED_MESSAGE);
				userMessage.setPush_type(pushType);
				userMessage.setSend_uid(manager_id);
				userMessage.setCreateBy(manager_id);
				userMessage.setUpdateBy(manager_id);
				if (DataUtils.isNotNullOrEmpty(progress)){
				userMessage.setProgress(progress);
				}
				Long message_id = messageService.insert(message);
				if (target != UserMessage.SEND_TO_ALL) {
					log.info("insert message success. message_id =" + message_id);
					//					判断发送目标决定存学生id还是教练id
					if (target == UserMessage.SEND_TO_STUDENT) {
						for (Long studentUid : studentUids) {
							userMessage.setUid(studentUid);
							userMessage.setMessage_id(message_id);
							userMessage.setTarget_receive(target);
							Long userMessage_id = userMessageService.insert(userMessage);
							log.info("insert student_userMessage success. userMessage_id=" + userMessage_id);
						}

					} else if (target == UserMessage.SEND_TO_COACH) {
						if (coachUids!=null && coachUids.length!=0){
						for (Long coachUid : coachUids) {
							userMessage.setUid(coachUid);
							userMessage.setMessage_id(message_id);
							userMessage.setTarget_receive(target);
							Long userMessage_id = userMessageService.insert(userMessage);
							log.info("insert coach_userMessage success. userMessage_id=" + userMessage_id);
						}
					}
					}
				} else if (target == UserMessage.SEND_TO_ALL) {
					log.info("insert message success. message_id is" + message_id);

					//					存学生信息数据 他们的uid是不一样的,所以区分
					for (Long studentUid : studentUids) {
						userMessage.setUid(studentUid);
						userMessage.setMessage_id(message_id);
						userMessage.setTarget_receive(UserMessage.SEND_TO_STUDENT);
						Long student_userMessage_id = userMessageService.insert(userMessage);
						log.info("insert student_userMessage success. userMessage_id=" + student_userMessage_id);
					}
					if (coachUids!=null && coachUids.length!=0  ){
					for (Long coachUid : coachUids) {
						//					存教练信息的数据
						userMessage.setUid(coachUid);
						userMessage.setMessage_id(message_id);
						userMessage.setTarget_receive(UserMessage.SEND_TO_COACH);
						Long coach_userMessage_id = userMessageService.insert(userMessage);
						log.info("insert coach_userMessage success. userMessage_id=" + coach_userMessage_id);
					}
				}
				}
				model.addAttribute("code", 0);

		} catch (Exception e) {
			e.printStackTrace();
			model.addAttribute("code", -100000);
			log.info("try catch a exception ! ");
		}
		return "/common/success";
	}

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 *
	 */

	@RequestMapping(value = "/c/userMessage", method = RequestMethod.GET)
	public String getuserMessageList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/userMessage  to /userMessage/view/userMessageList");

		return "/yi-public-service/userMessage/view/userMessageList";
	}

	@RequestMapping(value = "/c/userMessage/{id}", method = RequestMethod.GET)
	public String getUserMessage(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/userMessage/" + id + "  to /userMessage/view/userMessageDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-public-service/userMessage/view/userMessageDetail";
	}

	@RequestMapping(value = "/a/userMessage/{id}", method = RequestMethod.GET)
	public String getUserMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			UserMessage userMessage = userMessageService.getObjectById(id);
			log.info("get userMessage data is " + userMessage);

			model.addAttribute("code", 0);

			model.addAttribute("userMessage", userMessage);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userMessage error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-public-service/userMessage/json/userMessageDetailJson";
	}

	@RequestMapping(value = "/a/userMessage/{id}", method = RequestMethod.PUT)
	public String updateUserMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			UserMessage userMessage) throws Exception {

		log.info("update userMessage : userMessage= " + userMessage);

		try {

			userMessageService.update(userMessage);

			model.addAttribute("code", 0);

			model.addAttribute("userMessage", userMessage);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userMessage error,id is  " + userMessage.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userMessage", method = RequestMethod.POST)
	public String addUserMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			UserMessage userMessage) throws Exception {

		log.info("update userMessage : userMessage= " + userMessage);

		try {
			userMessage.setId(null);

			userMessageService.insert(userMessage);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userMessage error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userMessage/{id}", method = RequestMethod.DELETE)
	public String deleteUserMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete userMessage : id= " + id);
		try {
			userMessageService.delete(id);

			log.info("add userMessage success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userMessage error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/userMessage", method = RequestMethod.GET)
	public String getMultiUserMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<UserMessage> userMessageList = userMessageService.getObjectsByIds(idList);
			log.info("get  userMessage data is " + userMessageList);

			model.addAttribute("code", 0);
			model.addAttribute("total", userMessageList.size());

			model.addAttribute("userMessageList", userMessageList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userMessage error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-public-service/userMessage/json/userMessageListJson";
	}

}
