package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.TrainingVenues;
import com.ptteng.yi.nucleus.service.TrainingVenuesService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * TrainingVenues  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TrainingVenuesController {
	private static final Log log = LogFactory.getLog(TrainingVenuesController.class);

	@Autowired
	private TrainingVenuesService trainingVenuesService;

	@Autowired
	private CookieUtil cookieUtil;

	@RequestMapping(value = "/a/trainingVenues/{id}", method = RequestMethod.GET)
	public String getTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			TrainingVenues trainingVenues = trainingVenuesService.getObjectById(id);
			log.info("get trainingVenues data is " + trainingVenues);

			model.addAttribute("code", 0);

			model.addAttribute("trainingVenues", trainingVenues);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get trainingVenues error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/trainingVenues/json/trainingVenuesDetailJson";
	}

	@RequestMapping(value = "/a/trainingVenues/{id}", method = RequestMethod.PUT)
	public String updateTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TrainingVenues trainingVenues) throws Exception {

		log.info("update trainingVenues : trainingVenues= " + trainingVenues);

		try {

			trainingVenuesService.update(trainingVenues);

			model.addAttribute("code", 0);

			model.addAttribute("trainingVenues", trainingVenues);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update trainingVenues error,id is  " + trainingVenues.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/trainingVenues", method = RequestMethod.POST)
	public String addTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TrainingVenues trainingVenues) throws Exception {

		log.info("update trainingVenues : trainingVenues= " + trainingVenues);

		try {
			trainingVenues.setId(null);
			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
			trainingVenues.setCreateBy(mid);
			trainingVenues.setUpdateBy(mid);
			Long id = trainingVenuesService.insert(trainingVenues);

			model.addAttribute("id", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add trainingVenues error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json3";
	}

	@RequestMapping(value = "/a/trainingVenues/{id}", method = RequestMethod.DELETE)
	public String deleteTrainingVenuesJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete trainingVenues : id= " + id);
		try {
			trainingVenuesService.delete(id);

			log.info("add trainingVenues success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete trainingVenues error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	//	@RequestMapping(value = "/a/u/trainingVenues/list", method = RequestMethod.GET)
	//	public String getMultiTrainingVenuesJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Long[] ids)
	//			throws Exception {
	//
	//		List<Long> idList = new ArrayList();
	//	   if (ids == null) {
	//
	//		} else {
	//			idList = Arrays.asList(ids);
	//		}
	//		try {
	//
	//			List<TrainingVenues> trainingVenuesList = trainingVenuesService.getObjectsByIds(idList);
	//			log.info("get  trainingVenues data is " + trainingVenuesList);
	//
	//			model.addAttribute("code", 0);
	//			model.addAttribute("total",trainingVenuesList.size());
	//
	//			model.addAttribute("trainingVenuesList", trainingVenuesList);
	//
	//		} catch (Throwable t) {
	//			log.error(t.getMessage());
	//			log.error("get trainingVenues error,id is  " + idList);
	//			model.addAttribute("code", -100000);
	//		}
	//
	//		return "/yi-nucleus-service/trainingVenues/json/trainingVenuesListJson";
	//	}
	//

}
