package com.ptteng.controller;

import com.ptteng.model.TestResult;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ListUtil;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.TestRecords;
import com.ptteng.yi.nucleus.model.TestActivity;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.nucleus.service.TestRecordsService;
import com.ptteng.yi.nucleus.service.TestActivityService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.DATA_CONVERSION;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * TestRecords  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TestRecordsController {
	private static final Log log = LogFactory.getLog(TestRecordsController.class);

	@Autowired
	private TestRecordsService testRecordsService;
	@Autowired
	private StudentsService studentsService;
	@Autowired
	private TestActivityService testActivityService;

	@RequestMapping(value = "/c/testRecords", method = RequestMethod.GET)
	public String gettestRecordsList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/testRecords  to /testRecords/view/testRecordsList");

		return "/yi-nucleus-service/testRecords/view/testRecordsList";
	}

	@RequestMapping(value = "/c/testRecords/{id}", method = RequestMethod.GET)
	public String getTestRecords(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/testRecords/" + id + "  to /testRecords/view/testRecordsDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/testRecords/view/testRecordsDetail";
	}

	@RequestMapping(value = "/a/testRecords/{id}", method = RequestMethod.GET)
	public String getTestRecordsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			TestRecords testRecords = testRecordsService.getObjectById(id);
			log.info("get testRecords data is " + testRecords);

			model.addAttribute("code", 0);

			model.addAttribute("testRecords", testRecords);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get testRecords error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/testRecords/json/testRecordsDetailJson";
	}

	/**
	 *考试标注(登记学员考试成绩)
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param isPass
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = " /a/u/exam/student/{id}", method = RequestMethod.PUT)
	public String updateTestRecordsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Integer isPass) throws Exception {

		log.info("/a/u/exam/student/{id} " + ", isPass == " + isPass + "  id ===== " + id);

		try {
			TestRecords testRecords = testRecordsService.getObjectById(id);
			testRecords.setPass(isPass);

			testRecordsService.update(testRecords);

			//通过为1
			if (isPass.equals(1)) {
				Long testActId = testRecords.getTestActId();
				Long studentId = testRecords.getStuId();
				Students students = studentsService.getObjectById(studentId);
				TestActivity testActivity = testActivityService.getObjectById(testActId);
				//考试类型为科目二type=4;科目三type5的情况
				if (testRecords.getType()==4||testRecords.getType()==5){
					Integer progress = students.getProgress();
					//进度为科目二,科目三均未考
					if (progress.equals(3)&&testRecords.getType()==4){
						students.setProgress(5);
					}
					if (progress.equals(3)&&testRecords.getType()==5){
						students.setProgress(4);
					}
					//进度为通过其中一门.
					if (progress.equals(4)||progress.equals(5)){
						students.setProgress(6);
					}
				}else {
					students.setProgress(students.getProgress()+1);
				}
				log.info(" studengts progress is : " + students.getProgress());

				testActivity.setPassNumber(testActivity.getPassNumber()+1);
				testActivityService.update(testActivity);
				studentsService.update(students);
			}

			model.addAttribute("code", 0);
			model.addAttribute("testRecords", testRecords);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update testRecords error,id is  " + id);
			model.addAttribute("code", -6003);

		}

		return "/common/success";
	}

	@RequestMapping(value = "/a/testRecords", method = RequestMethod.POST)
	public String addTestRecordsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TestRecords testRecords) throws Exception {

		log.info("update testRecords : testRecords= " + testRecords);

		try {
			testRecords.setId(null);

			testRecordsService.insert(testRecords);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add testRecords error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/testRecords/{id}", method = RequestMethod.DELETE)
	public String deleteTestRecordsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete testRecords : id= " + id);
		try {
			testRecordsService.delete(id);

			log.info("add testRecords success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete testRecords error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 * 获取成绩汇总
	 * @param request
	 * @param response
	 * @param model
	 * @param progress
	 * @param schoolId
	 * @param subjectOne
	 * @param subjectTwo
	 * @param subjectThree
	 * @param subjectFour
	 * @param startTime
	 * @param endTime
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/result/student/list", method = RequestMethod.GET)
	public String getMultiTestRecordsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
										  String param ,Long cityId , Integer progress , Long schoolId , Integer subjectOne , Integer subjectTwo , Integer subjectThree , Integer subjectFour ,
										  Long startTime , Long endTime , Integer page , Integer size ) throws Exception {


		log.info(
				"/a/u/exam/student/list param is "
						+ "  param ===== " + param
						+ ", progress ==" + progress
						+ ", schoolId ==" + schoolId
						+ ", subjectOne ==" + subjectOne
						+ ", subjectTwo ==" + subjectTwo
						+ ", subjectThree == " + subjectThree
						+ ", subjectFour == " + subjectFour
						+ ", startTime == " + startTime
						+ ", endTime == " + endTime
						+ ", endTime == " + endTime
						+ ", page == " + page
						+" , size == " + size );
		if (DataUtils.isNotNullOrEmpty(cityId)) {
			log.info("cityId is : " + cityId);
		}else {
			if(DataUtils.isNullOrEmpty(schoolId)){
				model.addAttribute("code", -22010);
				log.info(" schoolId is null");
				return "/data/json";
			}
		}

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 2;
		}

		Map<String,Object> studentMap = new HashMap<>();
		studentMap = DynamicUtil.getTestRecordStudents(cityId,schoolId,param,startTime,endTime,progress);
		List<Long> studentsIds = studentsService.getIdsByDynamicCondition(Students.class,studentMap,0,Integer.MAX_VALUE);
		List<Students> studentsList = studentsService.getObjectsByIds(studentsIds);
		log.info(studentsIds + "学员表");
		Map<String, Object> testRecordsMap = new HashMap<>();
		testRecordsMap = DynamicUtil.getTestRecordBySids(studentsIds);
		List<Long> tids = testRecordsService.getIdsByDynamicCondition(Students.class, testRecordsMap, 0,
				Integer.MAX_VALUE);
		List<TestRecords> testRecordsList = testRecordsService.getObjectsByIds(tids);
		List<TestResult> testResultList = new ArrayList<>();
		log.info(tids + "成绩表");
		for (Students s : studentsList) {
			TestResult testResult = new TestResult();
			testResult.setMobile(s.getMobile());
			testResult.setIdentification(s.getIdentification());
			testResult.setName(s.getNick());
			testResult.setRegistrationDate(s.getRegistrationDate());
			testResult.setProgress(s.getProgress());
			testResult.setSubjectOne(0);
			testResult.setSubjectTwo(0);
			testResult.setSubjectThree(0);
			testResult.setSubjectFour(0);
			for (TestRecords t : testRecordsList) {
				if (s.getId().equals(t.getStuId())) {
					switch (t.getType()) {
					case 3:
							testResult.setSubjectOne(t.getTimes());
							break;
					case 4:
							testResult.setSubjectTwo(t.getTimes());
							break;
					case 5:
							testResult.setSubjectThree(t.getTimes());
							break;
					case 6:
							testResult.setSubjectFour(t.getTimes());
							break;
						default:
							break;
					}
				}
			}
			Boolean b = true;

			if (DataUtils.isNotNullOrEmpty(subjectOne) && !(testResult.getSubjectOne()).equals(subjectOne)) {
				b = false;
			}
			if (DataUtils.isNotNullOrEmpty(subjectTwo) && !(testResult.getSubjectTwo()).equals(subjectTwo)) {
				b = false;
			}
			if (DataUtils.isNotNullOrEmpty(subjectThree) && !(testResult.getSubjectThree()).equals(subjectThree)) {
				b = false;
			}
			if (DataUtils.isNotNullOrEmpty(subjectFour) && !(testResult.getSubjectFour()).equals(subjectFour)) {
				b = false;
			}
			if (b) {
				log.info(testResult);
				testResultList.add(testResult);
			}
		}
		List<List<TestResult>> tList = ListUtil.splitList(testResultList,size);
		log.info(tList.size());
		if(tList.size()<page){
			tList = null;
		}else {
			log.info("正常");
		}
		log.info(tList);
		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", testResultList.size());
		if(DataUtils.isNotNullOrEmpty(tList)){
			model.addAttribute("testResultList", tList.get(page-1));
		}
		return "/yi-nucleus-service/students/json/testResultListJson";
	}

}
