package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;

import com.ptteng.common.yi.model.Manager;
import com.ptteng.common.yi.service.ManagerService;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ManagerUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.TestPlan;
import com.ptteng.yi.nucleus.service.TestPlanService;

/**
 * TestPlan  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TestPlanController {
	private static final Log log = LogFactory.getLog(TestPlanController.class);
	//分别对应 体检,受理,科一,科二,科三,科四
	private static final Integer[] TEST_PLAN_TYPE = new Integer[]{
			1,
			2,
			3,
			4,
			5,
			6
	};
	@Autowired
	private TestPlanService testPlanService;

	@Autowired
	ManagerService managerService;

	@Autowired
	CookieUtil cookieUtil;

	@Autowired
	SchoolService schoolService;

	//允许对test_plan表进行操作的管理员类型 1 运营中心管理员 2 驾校管理员
	private static final Integer[] MANAGER_TYPES_OF_ALLOW_TO_GET_TEST_PLAN = new Integer[] { 1, 2 };

	/**
	 * 
	 * @param
	 * @return
	 */

	@RequestMapping(value = "/c/testPlan", method = RequestMethod.GET)
	public String gettestPlanList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/testPlan  to /testPlan/view/testPlanList");

		return "/yi-nucleus-service/testPlan/view/testPlanList";
	}

	@RequestMapping(value = "/c/testPlan/{id}", method = RequestMethod.GET)
	public String getTestPlan(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/testPlan/" + id + "  to /testPlan/view/testPlanDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/testPlan/view/testPlanDetail";
	}

	@RequestMapping(value = "/a/testPlan/{id}", method = RequestMethod.GET)
	public String getTestPlanJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			TestPlan testPlan = testPlanService.getObjectById(id);
			log.info("get testPlan data is " + testPlan);

			model.addAttribute("code", 0);

			model.addAttribute("testPlan", testPlan);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get testPlan error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/testPlan/json/testPlanDetailJson";
	}

	@RequestMapping(value = "/a/testPlan/{id}", method = RequestMethod.PUT)
	public String updateTestPlanJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TestPlan testPlan) throws Exception {

		log.info("update testPlan : testPlan= " + testPlan);

		try {

			testPlanService.update(testPlan);

			model.addAttribute("code", 0);

			model.addAttribute("testPlan", testPlan);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update testPlan error,id is  " + testPlan.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/testPlan", method = RequestMethod.POST)
	public String addTestPlanJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TestPlan testPlan) throws Exception {

		log.info("update testPlan : testPlan= " + testPlan);

		try {
			testPlan.setId(null);

			testPlanService.insert(testPlan);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add testPlan error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/testPlan/{id}", method = RequestMethod.DELETE)
	public String deleteTestPlanJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete testPlan : id= " + id);
		try {
			testPlanService.delete(id);

			log.info("add testPlan success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete testPlan error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/testPlan", method = RequestMethod.GET)
	public String getMultiTestPlanJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<TestPlan> testPlanList = testPlanService.getObjectsByIds(idList);
			log.info("get  testPlan data is " + testPlanList);

			model.addAttribute("code", 0);
			model.addAttribute("total", testPlanList.size());

			model.addAttribute("testPlanList", testPlanList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get testPlan error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/testPlan/json/testPlanListJson";
	}

	/**
	 *模糊查询获取考试计划
	 * @param title 考试计划标题
	 * @param type 考试计划类型 1 体检 2 受理 3 科一 4 科二 5 科三 6科四
	 * @param leaderName 负责人名称
	 * @param leaderMobile 负责人手机号码
	 * @param location 考试地点
	 * @param startTime 开始时间(考试时间范围)
	 * @param endTime 结束时间(考试时间范围)
	 * @param page 默认从0开始 即 0 代表第一页
	 * @param size 默认为10
	 * @return
	 */
	@RequestMapping(value = "/a/u/test/plan", method = RequestMethod.GET)
	public String getTestPlanByCondition(Long schoolId, String title, Integer type, String leaderName,
			String leaderMobile, String location, Long startTime, Long endTime, Integer page, Integer size, Model model,
			HttpServletRequest request) {

		log.info("schoolId is==" + schoolId + "title is==" + title + "	type is==" + type + "	leaderName is=="
				+ leaderName + "	leaderMobile is==" + leaderMobile + "	location is==" + location
				+ "	startTime is==" + startTime + "	endTime is==" + endTime + "	page is==" + page + "	size is=="
				+ size);


		if (!DataUtils.isNotNullOrEmpty(schoolId)) {
			log.info("parameters is null,end the request");
			model.addAttribute("code", -24101);
			return "yi-pub-service/testPlan/json/testPlansListJson";
		}
		size = null == size ? 10 : size;
		page = ParamsUtil.calculateStartPosition(page, size);

		Map<String, Object> sqlInfo;
		Long managerId = cookieUtil.getID(request);
		log.info("manager id is==" + managerId);
		Manager manager;
		List<Long> allowToGetTestPlanFromSchoolIds;
		List<Long> testPlanIds = null;
		List<TestPlan> testPlans = null;
		Integer total = 0;
		List<Long> testPlansBelongSchoolIds = null;
		List<School> testPlanBelongSchools = null;
		//若起始时间世界时间均为null则时间不参与sql过滤条件设置为null,否则new一个对象并将时间存入.
		List<Long> time = null != startTime || null != endTime ? new ArrayList<Long>(2) : null;
		if (null != time) {
			time.add(startTime);
			time.add(endTime);
		}

		try {
			manager = null != managerId ? managerService.getObjectById(managerId) : null;
			log.info("manager is==" + manager);
			//判断是否有权限调用该接口
			boolean managerIsIllegal = ManagerUtil.judgeMangerIsIllegal(manager,
					MANAGER_TYPES_OF_ALLOW_TO_GET_TEST_PLAN);
			if (manager == null) {
				log.info("manager is nonexistent");
				model.addAttribute("code", -5003);
				return "yi-pub-service/testPlan/json/testPlansListJson";
			}
			if (managerIsIllegal) {
				log.info("This manager is not The school manager,Permission denied");
				model.addAttribute("code", -5020);
				return "yi-pub-service/testPlan/json/testPlansListJson";
			}

			//运营中心管理员操作test_plan表
			if (manager.getType() == 1) {
				sqlInfo = cityMangerGetTestPlanByCondition(manager, time, schoolId, title, type, leaderName,
						leaderMobile, location);
			} else {
				//驾校管理员操作test_plan表,将驾校管理员所在驾校加入允许查看驾校信息列表.
				allowToGetTestPlanFromSchoolIds = new ArrayList<>(16);
				allowToGetTestPlanFromSchoolIds.add(manager.getSchoolId());

				sqlInfo = DynamicUtil.getTestPlanIdsByCondition(title, type, leaderName, leaderMobile, location, time,
						allowToGetTestPlanFromSchoolIds);
			}


			if (null!=sqlInfo) {
				testPlanIds = testPlanService.getIdsByDynamicCondition(
						TestPlan.class,
						sqlInfo,
						0,
						Integer.MAX_VALUE
				);
			}
			log.info("testPlan ids size is=="+(null!=testPlanIds?testPlanIds.size():0));
			total = null != testPlanIds ? testPlanIds.size() : 0;
			testPlanIds = ParametersUtil.splitArrayList(testPlanIds, page, page + size);
			if (null!=testPlanIds&&0!= testPlanIds.size()) {
				testPlans = testPlanService.getObjectsByIds(testPlanIds);
			}

			log.info("testPlans is==" + testPlans);
			log.info("testPlan total is==" + total);

			//获取每个考试计划对应的驾校信息
			if (null!=testPlans&&0!=testPlans.size()) {
				testPlansBelongSchoolIds  = new ArrayList<Long>(16);
				for (int i = 0; i < testPlans.size(); ++i) {
					testPlansBelongSchoolIds.add(testPlans.get(i).getSchoolId());
				}
			}
			if (null!=testPlansBelongSchoolIds) {
				testPlanBelongSchools = schoolService.getObjectsByIds(testPlansBelongSchoolIds);
			}

			model.addAttribute("code", 0);
			model.addAttribute("schools", testPlanBelongSchools);
			model.addAttribute("total", total);
			model.addAttribute("data", testPlans);
		} catch (Exception e) {
			Integer code = -100000;
			String message = e.getMessage();
			String[] strings = message.split("\\|\\|\\|");
			if (2 == strings.length)
				code = Integer.valueOf(strings[0]);

			log.error("has an error,see==" + message);
			model.addAttribute("code", code);
		}

		return "yi-pub-service/testPlan/json/testPlansListJson";
	}

	/**
	 * 运营中心管理员模糊查询获取考试计划
	 * @param schoolId
	 * @param title
	 * @param type
	 * @param leaderName
	 * @param leaderMobile
	 * @param location
	 * @return
	 */
	private Map<String, Object> cityMangerGetTestPlanByCondition(Manager manager, List<Long> time, Long schoolId,
			String title, Integer type, String leaderName, String leaderMobile, String location) throws Exception {
		//允许运营中心管理员操作驾校信息的驾校id列表
		//运营中心管理员仅可操作运营中心所在城市下所有未被冻结的驾校.
		List<Long> allowToGetTestPlanFromSchoolIds;
		boolean isExistent;
		Map<String, Object> sqlInfo;

		try {
			allowToGetTestPlanFromSchoolIds = schoolService.getSchoolIdsByCityId(manager.getCityId());
			//当前运营中心管理员所在城市没有任何驾校
			if (0 == allowToGetTestPlanFromSchoolIds.size())
				throw new Exception("0" + "|||school  list is zero");

			////运营中心管理员指定驾校,判断指定的驾校是否在允许查看驾校信息列表之列.
			if (0 != schoolId) {
				isExistent = allowToGetTestPlanFromSchoolIds.contains(schoolId);
				if (!isExistent)
					throw new Exception("-2403" + "|||school id is nonexistent,end the request");
				else {
					//指定驾校合法,清空合法驾校列表,将指定的驾校作为唯一合法驾校.
					allowToGetTestPlanFromSchoolIds.clear();
					allowToGetTestPlanFromSchoolIds.add(schoolId);
				}
			}

			sqlInfo = DynamicUtil.getTestPlanIdsByCondition(title, type, leaderName, leaderMobile, location, time,
					allowToGetTestPlanFromSchoolIds);
		} catch (Exception e) {
			throw e;
		}

		return sqlInfo;
	}

	@RequestMapping(value = "/a/u/test/plan/{id}", method = RequestMethod.GET)
	public String getTestPlanById(@PathVariable Long id, Model model, HttpServletRequest request) {

		log.info("test plan id is==" + id);

		if (0 >= id) {
			log.info("id is illegal,end the request");
			model.addAttribute("code", -1001);
			return "yi-pub-service/testPlan/json/testPlanDetailJson";
		}

		//权限校验
		Map<String, Object> sqlInfo = null;
		Long managerId = cookieUtil.getID(request);
		Manager manager = null;
		List<Long> allowToGetTestPlanFromSchoolIds = null;
		List<School> allowToGetTestPlanFromSchools = null;
		List<Long> testPlanIds = null;
		TestPlan testPlan = null;
		School school = null;
		log.info("manager id is==" + managerId);

		try {
			if (null!=managerId) {
				manager = managerService.getObjectById(managerId);
			}
			log.info("manager is==" + manager);

			//判断是否有权限调用该接口
			boolean managerIsIllegal = ManagerUtil.judgeMangerIsIllegal(manager,
					MANAGER_TYPES_OF_ALLOW_TO_GET_TEST_PLAN);
			if (manager == null) {
				log.info("manager is nonexistent");
				model.addAttribute("code", -5003);
				return "yi-pub-service/testPlan/json/testPlansListJson";
			}
			if (managerIsIllegal) {
				log.info("This manager is not The school manager,Permission denied");
				model.addAttribute("code", -5020);
				return "yi-pub-service/testPlan/json/testPlansListJson";
			}

			/*
				获取当前管理者能够查看的所有驾校id
				运营中心能够查看该城市下所有驾校未被冻结驾校发布的考试计划
				驾校被冻结则该驾校管理员无法登录.
			 */
			if (manager.getType() == 1) {
				allowToGetTestPlanFromSchoolIds = schoolService.getSchoolIdsByCityId(manager.getCityId());
				//当前运营中心管理员所在城市没有任何驾校
				if (0 == allowToGetTestPlanFromSchoolIds.size()) {
					model.addAttribute("code", 0);
					return "yi-pub-service/testPlan/json/testPlanDetailJson";
				}
			} else {
				//非运营中心管理员,将驾校管理员所在驾校加入允许查看驾校信息列表.
				allowToGetTestPlanFromSchoolIds = new ArrayList<>(16);
				allowToGetTestPlanFromSchoolIds.add(manager.getSchoolId());
			}
			log.info("school ids is==" + allowToGetTestPlanFromSchoolIds);


			if (!allowToGetTestPlanFromSchoolIds.isEmpty()) {
				allowToGetTestPlanFromSchools = schoolService.getObjectsByIds(allowToGetTestPlanFromSchoolIds);
			}
			log.info("schools is==" + allowToGetTestPlanFromSchools + "		" + "schools size is=="
					+ (null != allowToGetTestPlanFromSchools ? allowToGetTestPlanFromSchoolIds.size()
							: "schools is null"));

			sqlInfo = DynamicUtil.getTestPlanById(id, allowToGetTestPlanFromSchoolIds);
			if (null!=sqlInfo) {
				testPlanIds = testPlanService.getIdsByDynamicCondition(
						TestPlan.class,
						sqlInfo,
						0,
						Integer.MAX_VALUE
				);
			}

			if (null!=testPlanIds&&0!=testPlanIds.size()) {
				testPlan = testPlanService.getObjectById(testPlanIds.get(0));
			}
			if (null!=testPlan) {
				school = schoolService.getObjectById(testPlan.getSchoolId());
			}

			model.addAttribute("code", 0);
			model.addAttribute("testPlan", testPlan);
			model.addAttribute("school", school);
		} catch (Exception e) {
			log.error("has an error,see==" + e);
			model.addAttribute("code", -100000);
		}

		return "yi-pub-service/testPlan/json/testPlanDetailJson";
	}

	/**
	 * 新增考试计划
	 * @param title
	 * @param type 考试计划类型 1 体检 2 受理 3 科一 4 科二 5 科三 6科四
	 * @param leaderName 负责人名称
	 * @param leaderMobile 负责人手机号
	 * @param location 考试地点
	 * @param time 考试时间 unix毫秒级时间戳表示
	 * @return
	 */
	@RequestMapping(value = "/a/u/test/plan", method = RequestMethod.POST)
	public String addTestPlan(String title, Integer type, String leaderName, String leaderMobile, String location,
			String time, Model model, HttpServletRequest request) {

		log.info("title is==" + title + "	type is==" + type + "	leaderName is==" + leaderName
				+ "	leaderMobile is==" + leaderMobile + "	location is==" + location + "	time is==" + time);

		if (!DataUtils.isNotNullOrEmpty(type)) {
			log.info("The test plan type is null or empty,end the request");
			model.addAttribute("code",-24103);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}

		if (!DataUtils.isNotNullOrEmpty(time)) {
			log.info("The test time is null or empty,end the request");
			model.addAttribute("code",-24105);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}

		boolean isMobile = true;
		if (DataUtils.isNotNullOrEmpty(leaderMobile)) {
			isMobile = ParametersUtil.isMobile(leaderMobile);
		}
		log.info("isMobile is==" + isMobile);
		if (!isMobile) {
			log.error("parameters is illegal or empty");
			model.addAttribute("code", -1005);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}

		Long managerId = cookieUtil.getID(request);
		Manager manager = null;
		Long schoolId = null;
		TestPlan testPlan = new TestPlan();
		Long testPlanId = null;

		try {
			if (!ParametersUtil.parameterIsExistentArray(type,TEST_PLAN_TYPE)) {
				log.info("The test plan type is illegal,end the request");
				model.addAttribute("code",-24304);
				return "yi-pub-service/testPlan/json/addTestPlanJson";
			}

			if (null!=managerId) {
				manager = managerService.getObjectById(managerId);
			}
			if (null!=manager) {
				schoolId = manager.getSchoolId();
			}

			if (null == manager) {
				log.info("This manager is nonexistent");
				model.addAttribute("code", -2401);
				return "yi-pub-service/testPlan/json/addTestPlanJson";
			}

			if (2 != manager.getType()) {
				log.info("This manager is not The school manager," + "Permission denied");

				model.addAttribute("code", -5020);
				return "yi-pub-service/testPlan/json/addTestPlanJson";
			}

			if (null == schoolId) {
				log.info("This manager is not set school id");
				model.addAttribute("code", -2400);
				return "yi-pub-service/testPlan/json/addTestPlanJson";
			}

			testPlan.setLeaderMobile(leaderMobile);
			testPlan.setLeaderName(leaderName);
			testPlan.setLocation(location);
			testPlan.setSchoolId(schoolId);
			testPlan.setTestTime(Long.valueOf(time));
			testPlan.setTitle(title);
			testPlan.setType(type);
			testPlan.setCreateAt(System.currentTimeMillis());
			testPlan.setCreateBy(managerId);
			testPlan.setUpdateAt(System.currentTimeMillis());
			testPlan.setUpdateBy(managerId);

			testPlanId = testPlanService.insert(testPlan);

			model.addAttribute("code", 0);
		} catch (Exception e) {
			log.error("has an error,see==" + e.getMessage());
			model.addAttribute("code", -100000);

			try {
				if (null != testPlanId)
					testPlanService.delete(testPlanId);
			} catch (Exception e1) {
				log.error("add testPlan failed,delete testPlan data failed,see==" + e1);
				model.addAttribute("code", -1);
			}
		}

		return "yi-pub-service/testPlan/json/addTestPlanJson";
	}

	/**
	 * 更新考试计划
	 * @param title
	 * @param type 考试计划类型 1 体检 2 受理 3 科一 4 科二 5 科三 6科四
	 * @param leaderName 负责人名称
	 * @param leaderMobile 负责人手机号
	 * @param location 考试地点
	 * @param time 考试时间 unix毫秒级时间戳表示
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/a/u/test/plan", method = RequestMethod.PUT)
	public String updateTestPlan(Long id, String title, Integer type, String leaderName, String leaderMobile,
			String location, String time, Model model, HttpServletRequest request) {

		log.info("id is==" + id + "title is==" + title + "	type is==" + type + "	leaderName is==" + leaderName
				+ "	leaderMobile is==" + leaderMobile + "	location is==" + location + "	time is==" + time);


		if (!DataUtils.isNotNullOrEmpty(id)) {
			log.info("The test plan id is null or empty,end the request");
			model.addAttribute("code",-24303);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}

		if (!DataUtils.isNotNullOrEmpty(type)) {
			log.info("The test plan type is null or empty,end the request");
			model.addAttribute("code",-24103);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}

		if (!DataUtils.isNotNullOrEmpty(time)) {
			log.info("The test plan time is null or empty,end the request");
			model.addAttribute("code",-24105);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}


		boolean isMobile = true;
		if (DataUtils.isNotNullOrEmpty(leaderMobile)) {
			isMobile = ParametersUtil.isMobile(leaderMobile);
		}
		log.info("isMobile is==" + isMobile);
		if (!isMobile) {
			log.error("parameters is illegal or empty");
			model.addAttribute("code", -1005);
			return "yi-pub-service/testPlan/json/addTestPlanJson";
		}


		Long managerId = cookieUtil.getID(request);
		Manager manager = null;
		TestPlan testPlan = null;
		try {

			if (null!=managerId) {
				manager = managerService.getObjectById(managerId);
			}
			if (null == manager) {
				log.info("This manager is nonexistent");
				model.addAttribute("code", -2401);
				return "yi-pub-service/testPlan/json/testPlansListJson";
			}

			if (2 != manager.getType()) {
				log.info("This manager is not The school manager," + "Permission denied");

				model.addAttribute("code", -5020);
				return "yi-pub-service/testPlan/json/testPlansListJson";
			}

			testPlan = testPlanService.getObjectById(id);
			if (null == testPlan) {
				log.info("testPlan is==" + testPlan);
				log.info("testPlan is nonexistent,end the request");
				model.addAttribute("code", -2402);
				return "yi-pub-service/testPlan/json/updateTestPlanJson";
			}

			testPlan.setType(type);
			testPlan.setTitle(title);
			testPlan.setTestTime(Long.valueOf(time));
			testPlan.setLocation(location);
			testPlan.setLeaderName(leaderName);
			testPlan.setLeaderMobile(leaderMobile);
			testPlan.setUpdateBy(managerId);
			testPlan.setUpdateAt(System.currentTimeMillis());

			testPlanService.update(testPlan);
			model.addAttribute("code", 0);
		} catch (Exception e) {
			log.error("has an error see==" + e);
			model.addAttribute("code", -100000);
		}

		return "yi-pub-service/testPlan/json/updateTestPlanJson";
	}
}
