package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyMapUtil;
import com.gemantic.common.util.hash.Hash;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.TestRecords;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.School;
import com.ptteng.yi.pub.model.UserMessage;
import com.ptteng.yi.pub.service.UserMessageService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.ptteng.common.yi.model.Manager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.lang.StringUtils;

import com.ptteng.yi.nucleus.model.TestActivity;
import com.ptteng.yi.nucleus.service.*;

/**
 * TestActivity  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class TestActivityController {
	private static final Log log = LogFactory.getLog(TestActivityController.class);

	@Autowired
	private TestActivityService testActivityService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private TestRecordsService testRecordsService;

	@Autowired
	private StudentsService studentsService;

	@Autowired
	private CoachService coachService;

	@Autowired
	private SchoolService schoolService;

	@Autowired
	private UserMessageService userMessageService;
	/**
	 * 查询考务活动列表
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = " /a/u/exam/activity/search", method = RequestMethod.GET)
	public String getTestActivityList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long cityId, String title, Long schoolId, Integer type, Integer status, Long startTime, Long endTime,
			Integer page, Integer size) throws Exception {

		log.info("/a/u/exam/student/list param is " + "  cityId ===== " + cityId + ", schoolId ==" + schoolId
				+ ", type ==" + type + ", status ==" + status + ", startTime ==" + startTime + ", endTime == " + endTime
				+ ", page == " + page + " , size == " + size);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		//判空逻辑(列表接口不用判空)

		Map<String, Object> params = DynamicUtil.getTestActivityListParams(title, schoolId, type, status, startTime,
				endTime);
		log.info(" params is : " + params);
		List<Long> testActivityListIds = testActivityService.getIdsByDynamicCondition(TestActivity.class, params, start,
				size);
		Integer total = testActivityService.getIdsByDynamicCondition(TestActivity.class, params, 0,
				Integer.MAX_VALUE).size();
		log.info(" get testActivityListIds is : " + testActivityListIds);
		List<TestActivity> testActivityList = testActivityService.getObjectsByIds(testActivityListIds);

		log.info("testActivityList is " + testActivityList.size());

		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("testActivityList", testActivityList);

		return "/yi-nucleus-service/testActivity/json/testActivityListJson";
	}

	@RequestMapping(value = "/c/testActivity/{id}", method = RequestMethod.GET)
	public String getTestActivity(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/testActivity/" + id + "  to /testActivity/view/testActivityDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/testActivity/view/testActivityDetail";
	}

	/**
	 * 获取考务活动详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/testActivity/{id}", method = RequestMethod.GET)
	public String getTestActivityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Integer page, Integer size) throws Exception {

		log.info("get testActivity : id= " + id);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Integer stuTargetReceive = 2;
			Integer coachTargetReceive = 1;
			Map<String, Object> examStuParams = DynamicUtil.getExamStudentsListParams(id);
			Map<String, Object> stuMessageParams = DynamicUtil.getMessageIdsByTestActId(id,stuTargetReceive);
			Map<String, Object> coachMessageParams = DynamicUtil.getMessageIdsByTestActId(id,coachTargetReceive);

			List<Long> examStudentsIds = testActivityService.getIdsByDynamicCondition(TestRecords.class, examStuParams, start, size);
			List<Long> stuMessagesIds = userMessageService.getIdsByDynamicCondition(UserMessage.class , stuMessageParams ,0 , Integer.MAX_VALUE);
			List<Long> coachMessageIds = userMessageService.getIdsByDynamicCondition(UserMessage.class , coachMessageParams ,0 , Integer.MAX_VALUE);

			Integer total = testActivityService.getIdsByDynamicCondition(TestRecords.class, examStuParams, 0,
					Integer.MAX_VALUE).size();

			List<TestRecords> examStudentsList = testRecordsService.getObjectsByIds(examStudentsIds);
			List<UserMessage> stuMessageList = userMessageService.getObjectsByIds(stuMessagesIds);
			log.info(" stuMessageList is : " + stuMessageList);
			List<UserMessage> coachMessageList = userMessageService.getObjectsByIds(coachMessageIds);

			Map<Long,Long> testRecId_stuId = MyListUtil.convert2Map(TestRecords.class.getDeclaredField("id"),TestRecords.class.getDeclaredField("stuId"),examStudentsList);
            Map<Long,Long> testRecId_coachId = MyListUtil.convert2Map(TestRecords.class.getDeclaredField("id"),TestRecords.class.getDeclaredField("coachId"),examStudentsList);
            Map<Long,Long> testRecId_schoolId = MyListUtil.convert2Map(TestRecords.class.getDeclaredField("id"),TestRecords.class.getDeclaredField("schooId"),examStudentsList);
			Map<Long,Integer> stuId_msgStatus = MyListUtil.convert2Map(UserMessage.class.getDeclaredField("uid" ), UserMessage.class.getDeclaredField("status") ,stuMessageList );
			Map<Long,Integer> coachId_msgStatus = MyListUtil.convert2Map(UserMessage.class.getDeclaredField("uid" ), UserMessage.class.getDeclaredField("status") ,coachMessageList );


			//剔除重复和null
			Set<Long> stuIds = new HashSet<>();
			for (Long stuId : testRecId_stuId.values()) {
				if (DataUtils.isNullOrEmpty(stuId)) {
					log.info(" stuId is null ");
				} else {
					Long examStuId = stuId;
					log.info(" examStuId is : " + examStuId);
					stuIds.add(examStuId);
				}
			}
			Set<Long> coachIds = new HashSet<>();
			for (Long coachId : testRecId_coachId.values()) {
				if (DataUtils.isNullOrEmpty(coachId)) {
					log.info(" coachId is null ");
				} else {
					Long examCoachId = coachId;
					log.info(" examCoachId is : "  + examCoachId);
					coachIds.add(examCoachId);
				}
			}
			Set<Long> schoolIds = new HashSet<>();
			for (Long schoolId : testRecId_schoolId.values()) {
				if (DataUtils.isNullOrEmpty(schoolId)) {
					log.info(" schoolId is null ");
				} else {
					Long examSchoolId = schoolId;
					log.info(" examSchoolId is : "  + examSchoolId);
					schoolIds.add(examSchoolId);
				}
			}
			//转为list
			List<Long> asListStuIds = new ArrayList<>(stuIds);
			List<Long> asListCoachIds = new ArrayList<>(coachIds);
			List<Long> asListSchoolIds = new ArrayList<>(schoolIds);
			List studentModelList = studentsService.getObjectsByIds(asListStuIds);
			List coachModelList = coachService.getObjectsByIds(asListCoachIds);
			List schoolModelList = schoolService.getObjectsByIds(asListSchoolIds);
			Map<Long,Students> stuId_student = MyListUtil.convert2Map(Students.class.getDeclaredField("id"),studentModelList);
			Map<Long,Coach> coachId_coach = MyListUtil.convert2Map(Coach.class.getDeclaredField("id"),coachModelList);
			Map<Long,School> schoolId_school = MyListUtil.convert2Map(School.class.getDeclaredField("id"),schoolModelList);

			List<HashMap<String, Object>> testActivityDetail = new ArrayList<>();

			for (TestRecords examStudents : examStudentsList) {
				HashMap<String, Object> examStudentTestRecordMap = new HashMap<>();

				//用map代替service调用
				Students studentsModel = stuId_student.get(testRecId_stuId.get(examStudents.getId()));
				Coach coachModel = coachId_coach.get(testRecId_coachId.get(examStudents.getId()));
				School schoolModel = schoolId_school.get(testRecId_schoolId.get(examStudents.getId()));

				//判断学生被删除的情况
				if (DataUtils.isNullOrEmpty(studentsModel)) {
					examStudentTestRecordMap.put("studentId", "id不存在");
					examStudentTestRecordMap.put("studentName", "");
					examStudentTestRecordMap.put("mobile", "");
				} else {
					examStudentTestRecordMap.put("studentId", examStudents.getStuId());
					examStudentTestRecordMap.put("studentName", studentsModel.getName());
					examStudentTestRecordMap.put("mobile", studentsModel.getMobile());
				}
				//判断没有教练的情况
				if (DataUtils.isNullOrEmpty(coachModel)) {

					examStudentTestRecordMap.put("coach", "");
					examStudentTestRecordMap.put("coachMobile", "");
					examStudentTestRecordMap.put("coachMessage", "");
				} else {
					examStudentTestRecordMap.put("coach", coachModel.getName());
					examStudentTestRecordMap.put("coachMobile", coachModel.getMobile());
					if ( DataUtils.isNullOrEmpty(coachId_msgStatus.get(examStudents.getCoachId()))) {
						examStudentTestRecordMap.put("coachMessage", "");
					} else {
						examStudentTestRecordMap.put("coachMessage", coachId_msgStatus.get(examStudents.getCoachId()) - 1);
					}
				}
				//判断没有驾校的情况
				if (DataUtils.isNullOrEmpty(schoolModel)) {
					examStudentTestRecordMap.put("school", "");
				} else {
					examStudentTestRecordMap.put("school", schoolModel.getName());
				}

				examStudentTestRecordMap.put("id", examStudents.getId());
				examStudentTestRecordMap.put("times", examStudents.getTimes());
				examStudentTestRecordMap.put("result", examStudents.getPass());
				if ( DataUtils.isNullOrEmpty(stuId_msgStatus.get(examStudents.getStuId()))) {
					examStudentTestRecordMap.put("studentMessage", "");
				} else  {
					examStudentTestRecordMap.put("studentMessage", stuId_msgStatus.get(examStudents.getStuId())-1);
				}
				log.info(" stuStatus is : " + stuId_msgStatus.get(examStudents.getStuId()));

				testActivityDetail.add(examStudentTestRecordMap);
			}

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("testActivityDetail", testActivityDetail);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get testActivity error,id is  " + id);
			model.addAttribute("code", -100000);

		}

		return "/yi-nucleus-service/testActivity/json/testActivityDetailJson";
	}

	@RequestMapping(value = "/a/testActivity/{id}", method = RequestMethod.PUT)
	public String updateTestActivityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TestActivity testActivity) throws Exception {

		log.info("update testActivity : testActivity= " + testActivity);

		try {

			testActivityService.update(testActivity);

			model.addAttribute("code", 0);

			model.addAttribute("testActivity", testActivity);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update testActivity error,id is  " + testActivity.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	/**
	 * 创建考务活动
	 * @param request
	 * @param response
	 * @param model
	 * @param testActivity
	 * @param studentIdList
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/exam/testActivity", method = RequestMethod.POST)
	public String addTestActivityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			TestActivity testActivity, @RequestParam Long[] studentIdList) throws Exception {

		log.info("/a/u/exam/testActivity param is " + "  testActivity ===== " + testActivity + ", studentIdList size =="
				+ Arrays.toString(studentIdList));

		log.info("studentIdList === " + studentIdList.length);

		if (DataUtils.isNullOrEmpty(testActivity.getTitle())) {
			log.info("title is not null or empyty");
			model.addAttribute("code", -24100);
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(testActivity.getSchoolId())) {
			log.info("title is not null or empyty");
			model.addAttribute("code", -24101);
			return "/common/failure";
		}
		//如何保证输入的是数字,而不是字符
		if (DataUtils.isNullOrEmpty(testActivity.getTakeNumber())) {
			log.info("title is not null or empyty");
			model.addAttribute("code", -24102);
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(testActivity.getType())) {
			log.info("title is not null or empyty");
			model.addAttribute("code", -24103);
			return "/common/failure";
		}
		if (studentIdList.length == 0) {
			log.info("title is not null or empyty");
			model.addAttribute("code", -24104);
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(testActivity.getTestTime())) {
			log.info("title is not null or empyty");
			model.addAttribute("code", -24105);
			return "/common/failure";
		}

		Long managerId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
		Long testActId = null ;
		log.info("try catch begin +++++++++");
		try {

			testActivity.setId(null);

			testActivity.setCreateBy(managerId);
			testActivity.setUpdateBy(managerId);
			//初始为未标注
			testActivity.setStatus(1);
			testActId = testActivityService.insert(testActivity);

			List<Students> studentsList = studentsService.getObjectsByIds(Arrays.asList(studentIdList));

			Set<String> coachIds =  new HashSet<String>();
			String str = "";
			log.info("studentIdList is : " + studentIdList.length);
			for (Students students : studentsList) {

				Long coachId = null ;
				//科二,科三添加教练
				TestRecords testRecords = new TestRecords();
				testRecords.setTestActId(testActId);
				//判断考试类型没有教练的情况
				if (testActivity.getType() == 4) {
					if (DataUtils.isNullOrEmpty(students.getSectionTwoCoachId())) {
						testRecords.setCoachId(null);
					}else {
						testRecords.setCoachId(Long.valueOf(students.getSectionTwoCoachId()));
						coachIds.add(students.getSectionTwoCoachId());
					}
				} else if (testActivity.getType() == 5) {
					if (DataUtils.isNullOrEmpty(students.getSectionThreeCoachId())) {
						testRecords.setCoachId(null);
					}else {
						testRecords.setCoachId(Long.valueOf(students.getSectionThreeCoachId()));
						coachIds.add(students.getSectionTwoCoachId());
					}
				}
				testRecords.setStuId(students.getId());
				testRecords.setSchooId(students.getSchoolId());
				testRecords.setType(testActivity.getType());
				List<Long> oldTestRecordIds = testRecordsService.getTestRecordsIdsByStuIdAndIsNews(students.getId(), 0,
						0, Integer.MAX_VALUE);
				Long oldTestRecordId = null;
				if ((oldTestRecordIds == null ? "null" : oldTestRecordIds.size()).equals(0)) {
					log.info("第一次参加考试");
					testRecords.setTimes(1);
				} else {
					oldTestRecordId = oldTestRecordIds.get(0);
					log.info("oldTestRecordId is ======" + oldTestRecordId);
					TestRecords oldTestRecord = testRecordsService.getObjectById(oldTestRecordId);
					oldTestRecord.setIsNews(1);
					testRecordsService.update(oldTestRecord);
					testRecords.setTimes(oldTestRecord.getTimes() + 1);
				}

				Long testRecId = testRecordsService.insert(testRecords);
			}

			str = StringUtils.join(coachIds.toArray(), ",");

			log.info("str is : " + str);
			model.addAttribute("code", 0);
			model.addAttribute("coachIds", str);
			model.addAttribute("id" , testActId);
			model.addAttribute("coachIds" , coachIds);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add testActivity error ");
			model.addAttribute("id" , testActId);
			model.addAttribute("code", -6002);
		}

		return "/yi-nucleus-service/testActivity/json/insertSuccessJson";
	}

	@RequestMapping(value = "/a/testActivity/{id}", method = RequestMethod.DELETE)
	public String deleteTestActivityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete testActivity : id= " + id);
		try {
			testActivityService.delete(id);

			log.info("add testActivity success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete testActivity error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/testActivity", method = RequestMethod.GET)
	public String getMultiTestActivityJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<TestActivity> testActivityList = testActivityService.getObjectsByIds(idList);
			log.info("get  testActivity data is " + testActivityList);

			model.addAttribute("code", 0);
			model.addAttribute("total", testActivityList.size());

			model.addAttribute("testActivityList", testActivityList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get testActivity error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/testActivity/json/testActivityListJson";
	}
}
