package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ManagerUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.SubjectOperation;
import com.ptteng.yi.nucleus.service.SubjectOperationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * SubjectOperation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SubjectOperationController {
    private static final Log log = LogFactory.getLog(SubjectOperationController.class);

    @Resource
    private SubjectOperationService subjectOperationService;

    @Autowired
    private CookieUtil cookieUtil;

    /**
     * 查询资讯列表接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/information/list", method = RequestMethod.GET)
    public String getSubjectOperationList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String title, Integer subjectType, Integer type, Integer status, Integer page, Integer size)
            throws Exception {
        //打印入参
        log.info("Interface GET /a/u/information/list, Method getSubjectOperationList() parameters: title: " + title
                + ", subjectType: " + subjectType + ", type: " + type + ", status: " + status);
        int actualSize = ParamsUtil.calculateActualSize(size);
        int startPosition = ParamsUtil.calculateStartPosition(page, size);
        log.info("page: " + startPosition + ", size:" + actualSize);

        int validateResult = ParamsUtil.checkParametersOfGetSubjectOperationList(subjectType, type, status);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            Map<String, Object> querySubjectOperationMap = DynamicUtil.getSubjectOperationListParams(title, subjectType,
                    type, status, false);
            List<Long> subjectOperationIdList = subjectOperationService.getIdsByDynamicCondition(SubjectOperation.class,
                    querySubjectOperationMap, startPosition, actualSize);
            log.info("get subjectOperation id list, list size is : " + subjectOperationIdList.size());

            List<SubjectOperation> subjectOperationList = null;
            Long total = 0L;
            if (CollectionUtils.isNotEmpty(subjectOperationIdList)) {
                subjectOperationList = subjectOperationService.getObjectsByIds(subjectOperationIdList);
                log.info("get subjectOperation data list, list size is: " + subjectOperationList.size());

                Map<String, Object> countSubjectOperationMap = DynamicUtil.getSubjectOperationListParams(title,
                        subjectType, type, status, true);
                total = subjectOperationService.getIdsByDynamicCondition(SubjectOperation.class,
                        countSubjectOperationMap, 0, Integer.MAX_VALUE).get(0);
                log.info("count subjectOperation total is : " + total);
            }

            model.addAttribute("code", 0);
            model.addAttribute("size", actualSize);
            model.addAttribute("total", total);
            model.addAttribute("subjectOperationList", subjectOperationList);

            return "/yi-nucleus-service/subjectOperation/json/subjectOperationListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSubjectOperationList() failed : title: " + title + ", subjectType: " + subjectType
                    + ", type: " + type + ", status: " + status);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 查询资讯详情接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/information/{id}", method = RequestMethod.GET)
    public String getSubjectOperationDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("Interface GET /a/u/information/{id}, Method getSubjectOperationDetail() parameters: id: " + id);

        if (id <= 0) {
            log.info("Error value of parameter id, id is: " + id);
            model.addAttribute("code", -1001);
            return "/common/failure";
        }

        try {
            SubjectOperation subjectOperation = subjectOperationService.getObjectById(id);
            log.info("get subjectOperation data, subjectOperation is:" + subjectOperation);

            model.addAttribute("code", 0);
            model.addAttribute("subjectOperation", subjectOperation);
            return "/yi-nucleus-service/subjectOperation/json/subjectOperationDetailJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSubjectOperationDetail() failed, id : " + id);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 上下架资讯接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/information/{id}/status", method = RequestMethod.PUT)
    public String modifySubjectOperationStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer operate) throws Exception {

        log.info("Interface /a/u/information/{id}/status, Method modifySubjectOperationStatus() parameters :" + "id: "
                + id + ", operate: " + operate);

        int validateResult = ParamsUtil.checkParametersOfModifySubjectOperationStatus(id, operate);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            SubjectOperation subjectOperation = subjectOperationService.getObjectById(id);
            log.info("get subjectOperation data, subjectOperation is:" + subjectOperation);

            if (DataUtils.isNullOrEmpty(subjectOperation)) {
                log.info("Can not find subjectOperation data by id, id is : " + id);
                model.addAttribute("code", -1001);
                return "/common/failure";
            }

            subjectOperation.setStatus(operate);
            Long managerId = ManagerUtil.getManagerId(cookieUtil, request);
            subjectOperation.setUpdateBy(managerId);
            subjectOperationService.update(subjectOperation);
            log.info("update subjectOperation status success, status is: " + subjectOperation.getStatus());

            model.addAttribute("code", 0);
            return "/common/success";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method modifySubjectOperationStatus() failed, id: " + id + ", operate: " + operate);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 新增资讯接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/information", method = RequestMethod.POST)
    public String addSubjectOperation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String title, String cover, String content, Integer subjectType, Integer type) throws Exception {

        log.info("Interface POST /a/u/information, Method addSubjectOperation() parameters: title: " + title
                + ", cover: " + cover + ", content: " + content + ", subjectType: " + subjectType + ", type: " + type);

        int validateResult = ParamsUtil.checkParametersOfModifySubjectOperation(title, cover, content, subjectType,
                type);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        Long managerId = ManagerUtil.getManagerId(cookieUtil, request);
        SubjectOperation subjectOperation = new SubjectOperation();
        subjectOperation.setCover(cover);
        subjectOperation.setTitle(title);
        subjectOperation.setSubjectType(subjectType);
        subjectOperation.setType(type);
        subjectOperation.setSort(SubjectOperation.SORT_INIT_VALUE);
        subjectOperation.setContent(content);
        subjectOperation.setStatus(SubjectOperation.OFF_LINE);
        subjectOperation.setCreateBy(managerId);
        subjectOperation.setUpdateBy(managerId);
        try {
            Long subjectOperationId = subjectOperationService.insert(subjectOperation);
            log.info("insert subjectOperation success, subjectOperation id : " + subjectOperationId);

            model.addAttribute("code", 0);
            model.addAttribute("id", subjectOperationId);
            return "/common/insert";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method addSubjectOperation() failed, parameters: title: " + title + ", cover: " + cover
                    + ", content: " + content + ", subjectType: " + subjectType + ", type: " + type);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 编辑资讯接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/information/{id}", method = RequestMethod.PUT)
    public String updateSubjectOperation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, String title, String cover, String content, Integer subjectType, Integer type)
            throws Exception {

        log.info("Interface PUT /a/u/information, Method updateSubjectOperation() parameters: title: " + title
                + ", cover: " + cover + ", content: " + content + ", subjectType: " + subjectType + ", type: " + type);

        int validateResult = ParamsUtil.checkParametersOfModifySubjectOperation(title, cover, content, subjectType,
                type);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            SubjectOperation subjectOperation = subjectOperationService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(subjectOperation)) {
                log.info("Can not find subjectOperation data by id, id is : " + id);
                model.addAttribute("code", -1001);
                return "/common/failure";
            }
            log.info("get subjectOperation data, subjectOperation is : " + subjectOperation);

            subjectOperation.setTitle(title);
            subjectOperation.setCover(cover);
            subjectOperation.setContent(content);
            subjectOperation.setSubjectType(subjectType);
            subjectOperation.setType(type);
            subjectOperationService.update(subjectOperation);
            log.info("update subjectOperation data success, subjectOperation id is :" + subjectOperation.getId());

            model.addAttribute("code", 0);
            return "/common/success";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method updateSubjectOperation() failed, parameters: title: " + title + ", cover: " + cover
                    + ", content: " + content + ", subjectType: " + subjectType + ", type: " + type);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 资讯拖动排序
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/information/sort", method = RequestMethod.PUT)
    public String sortInformation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @RequestParam Long[] ids) throws Exception {
        log.info("Interface PUT /a/u/information/sort, Method sortInformation() parameters : ids : "
                + Arrays.toString(ids));

        if (ids == null || ids.length == 0) {
            log.info("Parameter ids can not be noll or empty!");
            model.addAttribute("code", -1000);
            return "/common/failure";
        }

        try {
            List<SubjectOperation> subjectOperationList = subjectOperationService.getObjectsByIds(Arrays.asList(ids));
            log.info("get subjectOperation list by ids, list size is : " + subjectOperationList.size());

            if (subjectOperationList.size() < ids.length) {
                log.info("Error value of parameter ids, ids is : " + Arrays.toString(ids));
                model.addAttribute("code", -1001);
                return "/common/failure";
            }

            Long managerId = ManagerUtil.getManagerId(cookieUtil, request);
            for (int i = 0; i < ids.length; i++) {
                SubjectOperation subjectOperation = subjectOperationList.get(i);
                subjectOperation.setSort((i + 1) * 10);
                subjectOperation.setUpdateBy(managerId);
            }
            subjectOperationService.updateList(subjectOperationList);
            log.info("update subject operation list field sort success");

            model.addAttribute("code", 0);
            return "/common/success";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method sortInformation() failed, parameters : ids : " + Arrays.toString(ids));
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}
